/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.render;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.extractor.json.jsonpath.JSONManager;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RenderAsJSON;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAsJsonRenderer
implements ResultRenderer,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RenderAsJsonRenderer.class);
    private static final String NO_MATCH = "NO MATCH";
    private static final String TAB_SEPARATOR = "    ";
    private static final String JSONPATH_TESTER_COMMAND = "jsonpath_tester";
    private JPanel jsonWithJSonPathPanel;
    private JSyntaxTextArea jsonDataField;
    private JLabeledTextField jsonPathExpressionField;
    private JTextArea jsonPathResultField;
    private JTabbedPane rightSide;
    private SampleResult sampleResult;

    @Override
    public void clearData() {
        this.jsonDataField.setText("");
        this.jsonPathResultField.setText("");
    }

    @Override
    public void init() {
        this.jsonWithJSonPathPanel = this.createJSonPathExtractorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.sampleResult != null && JSONPATH_TESTER_COMMAND.equals(command)) {
            String response = this.jsonDataField.getText();
            this.executeAndJSonPathTester(response);
        }
    }

    private void executeAndJSonPathTester(String textToParse) {
        if (textToParse != null && textToParse.length() > 0 && this.jsonPathExpressionField.getText().length() > 0) {
            this.jsonPathResultField.setText(this.process(textToParse));
            this.jsonPathResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse) {
        String jsonPathExpression = this.jsonPathExpressionField.getText();
        try {
            List<Object> matchStrings = this.extractWithJSonPath(textToParse, jsonPathExpression);
            if (matchStrings.isEmpty()) {
                return NO_MATCH;
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (Object obj : matchStrings) {
                String objAsString = obj != null ? obj.toString() : "";
                builder.append("Result[").append(i++).append("]=").append(objAsString).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            log.debug("Exception extracting from '{}' with JSON Path expression '{}'", (Object)textToParse, (Object)jsonPathExpression);
            return "Exception: " + e.getMessage();
        }
    }

    private List<Object> extractWithJSonPath(String textToParse, String expression) throws ParseException {
        JSONManager jsonManager = new JSONManager();
        return jsonManager.extractWithJsonPath(textToParse, expression);
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.jsonDataField.setText(response == null ? "" : RenderAsJSON.prettyJSON(response, TAB_SEPARATOR));
        this.jsonDataField.setCaretPosition(0);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"jsonpath_renderer");
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"jsonpath_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"jsonpath_tester_title"), this.jsonWithJSonPathPanel);
        }
        this.clearData();
    }

    private JPanel createJSonPathExtractorPanel() {
        this.jsonDataField = JSyntaxTextArea.getInstance((int)50, (int)80, (boolean)true);
        this.jsonDataField.setCodeFoldingEnabled(true);
        this.jsonDataField.setEditable(false);
        this.jsonDataField.setBracketMatchingEnabled(false);
        this.jsonDataField.setSyntaxEditingStyle("text/json");
        this.jsonDataField.setLanguage("text/json");
        this.jsonDataField.setLineWrap(true);
        this.jsonDataField.setWrapStyleWord(true);
        JTextScrollPane jsonDataPane = JTextScrollPane.getInstance((JSyntaxTextArea)this.jsonDataField, (boolean)true);
        jsonDataPane.setPreferredSize(new Dimension(100, 200));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, (Component)jsonDataPane, this.createJSonPathExtractorTasksPanel());
        mainSplit.setDividerLocation(0.6);
        mainSplit.setOneTouchExpandable(true);
        panel.add((Component)mainSplit, "Center");
        return panel;
    }

    private JPanel createJSonPathExtractorTasksPanel() {
        JPanel jsonPathActionPanel = new JPanel();
        jsonPathActionPanel.setLayout(new BoxLayout(jsonPathActionPanel, 0));
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        jsonPathActionPanel.setBorder(margin);
        this.jsonPathExpressionField = new JLabeledTextField(JMeterUtils.getResString((String)"jsonpath_tester_field"));
        jsonPathActionPanel.add((Component)this.jsonPathExpressionField, "West");
        JButton jsonPathTester = new JButton(JMeterUtils.getResString((String)"jsonpath_tester_button_test"));
        jsonPathTester.setActionCommand(JSONPATH_TESTER_COMMAND);
        jsonPathTester.addActionListener(this);
        jsonPathActionPanel.add((Component)jsonPathTester, "East");
        this.jsonPathResultField = new JTextArea();
        this.jsonPathResultField.setEditable(false);
        this.jsonPathResultField.setLineWrap(true);
        this.jsonPathResultField.setWrapStyleWord(true);
        this.jsonPathResultField.setMinimumSize(new Dimension(100, 150));
        JPanel jsonPathTasksPanel = new JPanel(new BorderLayout(0, 5));
        jsonPathTasksPanel.add((Component)jsonPathActionPanel, "North");
        jsonPathTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.jsonPathResultField), "Center");
        return jsonPathTasksPanel;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public synchronized void setSamplerResult(Object userObject) {
        if (userObject instanceof SampleResult) {
            this.sampleResult = (SampleResult)userObject;
        }
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.jsonDataField.setText(JMeterUtils.getResString((String)"jsonpath_render_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

