/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.extractor.XPath2Extractor;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class XPath2ExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 1L;
    private final JLabeledTextField defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
    private final JLabeledTextField xpathQueryField = new JLabeledTextField(JMeterUtils.getResString((String)"xpath_extractor_query"));
    private final JLabeledTextField matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
    private final JLabeledTextField refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
    private JCheckBox getFragment;
    private JSyntaxTextArea namespacesTA;

    public String getLabelResource() {
        return "xpath2_extractor_title";
    }

    public XPath2ExtractorGui() {
        this.init();
    }

    public void configure(TestElement el) {
        super.configure(el);
        XPath2Extractor xpe = (XPath2Extractor)el;
        this.showScopeSettings(xpe, true);
        this.xpathQueryField.setText(xpe.getXPathQuery());
        this.defaultField.setText(xpe.getDefaultValue());
        this.refNameField.setText(xpe.getRefName());
        this.matchNumberField.setText(xpe.getMatchNumberAsString());
        this.namespacesTA.setText(xpe.getNamespaces());
        this.getFragment.setSelected(xpe.getFragment());
    }

    public TestElement createTestElement() {
        XPath2Extractor extractor = new XPath2Extractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof XPath2Extractor) {
            XPath2Extractor xpath = (XPath2Extractor)extractor;
            this.saveScopeSettings(xpath);
            xpath.setDefaultValue(this.defaultField.getText());
            xpath.setRefName(this.refNameField.getText());
            xpath.setMatchNumber(this.matchNumberField.getText());
            xpath.setXPathQuery(this.xpathQueryField.getText());
            xpath.setFragment(this.getFragment.isSelected());
            xpath.setNamespaces(this.namespacesTA.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.xpathQueryField.setText("");
        this.defaultField.setText("");
        this.refNameField.setText("");
        this.matchNumberField.setText(XPath2Extractor.DEFAULT_VALUE_AS_STRING);
        this.namespacesTA.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true, true, true));
        box.add(this.makeParameterPanel());
        this.add(box, "North");
    }

    private JPanel makeParameterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.xpathQueryField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.matchNumberField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.defaultField, gbc);
        this.resetContraints(gbc);
        panel.add((Component)new JLabel(JMeterUtils.getResString((String)"xpath_extractor_user_namespaces")), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.namespacesTA = JSyntaxTextArea.getInstance((int)5, (int)80);
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.namespacesTA, (boolean)true), gbc.clone());
        this.resetContraints(gbc);
        gbc.gridwidth = 2;
        this.getFragment = new JCheckBox(JMeterUtils.getResString((String)"xpath_extractor_fragment"));
        panel.add((Component)this.getFragment, gbc.clone());
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

