/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.XMLSchemaAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSchemaAssertionGUI
extends AbstractAssertionGui {
    private static final Logger log = LoggerFactory.getLogger(XMLSchemaAssertionGUI.class);
    private static final long serialVersionUID = 241L;
    private JTextField xmlSchema;

    public XMLSchemaAssertionGUI() {
        this.init();
    }

    public String getLabelResource() {
        return "xmlschema_assertion_title";
    }

    public TestElement createTestElement() {
        log.debug("XMLSchemaAssertionGui.createTestElement() called");
        XMLSchemaAssertion el = new XMLSchemaAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement inElement) {
        log.debug("XMLSchemaAssertionGui.modifyTestElement() called");
        this.configureTestElement(inElement);
        ((XMLSchemaAssertion)inElement).setXsdFileName(this.xmlSchema.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.xmlSchema.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        XMLSchemaAssertion assertion = (XMLSchemaAssertion)el;
        this.xmlSchema.setText(assertion.getXsdFileName());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        VerticalPanel assertionPanel = new VerticalPanel();
        assertionPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "XML Schema"));
        HorizontalPanel xmlSchemaPanel = new HorizontalPanel();
        xmlSchemaPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"xmlschema_assertion_label")));
        this.xmlSchema = new JTextField(26);
        xmlSchemaPanel.add((Component)this.xmlSchema);
        assertionPanel.add((Component)xmlSchemaPanel);
        mainPanel.add((Component)assertionPanel, "North");
        this.add(mainPanel, "Center");
    }
}

