/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.TimeRateAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.SeriesData;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class TotalTPSGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String STATUS_SERIES_FORMAT = "%s-%s";
    private static final String SUCCESS_SERIES_SUFFIX = "success";
    private static final String FAILURE_SERIES_SUFFIX = "failure";
    private static final String TRANSACTION_SUCCESS_LABEL = String.format("%s-%s", "Transaction", "success");
    private static final String TRANSACTION_FAILURE_LABEL = String.format("%s-%s", "Transaction", "failure");

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        groupInfos.put("Generic group", new GroupInfo(new TimeRateAggregatorFactory(), new AbstractSeriesSelector(true){

            @Override
            public Iterable<String> select(Sample sample) {
                return Arrays.asList(sample.getSuccess() ? TRANSACTION_SUCCESS_LABEL : TRANSACTION_FAILURE_LABEL);
            }
        }, new CountValueSelector(false), false, false));
        return groupInfos;
    }

    @Override
    public void setGranularity(long granularity) {
        super.setGranularity(granularity);
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        super.initializeExtraResults(parentResult);
        String[] seriesLabels = new String[]{TRANSACTION_SUCCESS_LABEL, TRANSACTION_FAILURE_LABEL};
        this.initializeSeries(parentResult, seriesLabels);
    }

    @Override
    public void initialize() {
        super.initialize();
        ((TimeRateAggregatorFactory)this.getGroupInfos().get("Generic group").getAggregatorFactory()).setGranularity(this.getGranularity());
    }

    private void initializeSeries(MapResultData parentResult, String[] series) {
        ListResultData listResultData = (ListResultData)parentResult.getResult("series");
        for (int i = 0; i < series.length; ++i) {
            listResultData.addResult(this.create(series[i]));
        }
    }

    private MapResultData create(String serie) {
        GroupInfo groupInfo = this.getGroupInfos().get("Generic group");
        SeriesData seriesData = new SeriesData(groupInfo.getAggregatorFactory(), groupInfo.enablesAggregatedKeysSeries(), false, groupInfo.enablesOverallSeries());
        return this.createSerieResult(serie, seriesData);
    }
}

