/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.processor.AggregatorFactory;
import org.apache.jmeter.report.processor.MaxAggregatorFactory;
import org.apache.jmeter.report.processor.MinAggregatorFactory;
import org.apache.jmeter.report.processor.PercentileAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.StaticSeriesSelector;
import org.apache.jmeter.report.processor.graph.SuccessfulElapsedTimeValueSelector;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;
import org.apache.jmeter.util.JMeterUtils;

public class ResponseTimePercentilesOverTimeGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String PERCENTILE_FORMAT = "%dth percentile";

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(8);
        groupInfos.put("aggregate_report_min", this.createMinGroupInfo());
        groupInfos.put("aggregate_report_max", this.createMaxGroupInfo());
        groupInfos.put("aggregate_rpt_pct1", this.createPercentileGroupInfo("aggregate_rpt_pct1", 90));
        groupInfos.put("aggregate_rpt_pct2", this.createPercentileGroupInfo("aggregate_rpt_pct2", 95));
        groupInfos.put("aggregate_rpt_pct3", this.createPercentileGroupInfo("aggregate_rpt_pct3", 99));
        return groupInfos;
    }

    private String formatPercentile(int percentile) {
        return String.format(PERCENTILE_FORMAT, percentile);
    }

    private GroupInfo createMinGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Min");
        return this.createGroupInfo(new MinAggregatorFactory(), seriesSelector);
    }

    private GroupInfo createMaxGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Max");
        return this.createGroupInfo(new MaxAggregatorFactory(), seriesSelector);
    }

    private GroupInfo createPercentileGroupInfo(String propKey, int defaultValue) {
        String seriesName = this.formatPercentile(defaultValue);
        int property = JMeterUtils.getPropDefault(propKey, defaultValue);
        PercentileAggregatorFactory factory = new PercentileAggregatorFactory();
        factory.setPercentileIndex(property);
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName(seriesName);
        return this.createGroupInfo(factory, seriesSelector);
    }

    private GroupInfo createGroupInfo(AggregatorFactory aggregationFactory, StaticSeriesSelector seriesSelector) {
        return new GroupInfo(aggregationFactory, seriesSelector, new SuccessfulElapsedTimeValueSelector(), false, false);
    }
}

