/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeelCommand
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(LookAndFeelCommand.class);
    private static final String JMETER_LAF = "jmeter.laf";
    private static final Set<String> commands;
    private static final Preferences PREFS;
    private static final String USER_PREFS_KEY = "laf.class";

    public static String getJMeterLaf() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        laf = JMeterUtils.getProperty("jmeter.laf." + osName.replace(' ', '_'));
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String[] osFamily = osName.split("\\s");
        laf = JMeterUtils.getProperty("jmeter.laf." + osFamily[0]);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        laf = JMeterUtils.getPropDefault(JMETER_LAF, "com.bulenkov.darcula.DarculaLaf");
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    private static String checkLafName(String laf) {
        if ("System".equalsIgnoreCase(laf)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if ("CrossPlatform".equalsIgnoreCase(laf)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return laf;
    }

    @Override
    public void doAction(ActionEvent ev) {
        try {
            String className = ev.getActionCommand().substring("laf:".length()).replace('/', '.');
            UIManager.setLookAndFeel(className);
            JMeterUtils.refreshUI();
            PREFS.put(USER_PREFS_KEY, className);
            int chosenOption = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("laf_quit_after_change"), JMeterUtils.getResString("exit"), 0, 3);
            if (chosenOption == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(ev.getSource(), ev.getID(), "restart"));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        PREFS = Preferences.userNodeForPackage(LookAndFeelCommand.class);
        log.info("Installing Darcula LAF");
        UIManager.installLookAndFeel("Darcula", "com.bulenkov.darcula.DarculaLaf");
        UIManager.LookAndFeelInfo[] allLAFs = JMeterMenuBar.getAllLAFs();
        commands = Arrays.stream(allLAFs).map(lf -> "laf:" + lf.getClassName()).collect(Collectors.toSet());
        if (log.isInfoEnabled()) {
            String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
            List names = Arrays.stream(allLAFs).filter(laf -> laf.getClassName().equals("com.bulenkov.darcula.DarculaLaf")).map(UIManager.LookAndFeelInfo::getName).collect(Collectors.toList());
            log.info("Using look and feel: {} {}", (Object)jMeterLaf, names);
        }
    }
}

