/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public final class KeyStrokes {
    private static final int CONTROL_MASK;
    public static final KeyStroke COPY;
    public static final KeyStroke DUPLICATE;
    public static final KeyStroke DEBUG_OFF;
    public static final KeyStroke DEBUG_ON;
    public static final KeyStroke CLEAR_ALL;
    public static final KeyStroke CLEAR;
    public static final KeyStroke ESC;
    public static final KeyStroke ENTER;
    public static final KeyStroke FUNCTIONS;
    public static final KeyStroke SAVE_GRAPHICS;
    public static final KeyStroke SAVE_GRAPHICS_ALL;
    public static final KeyStroke HELP;
    public static final KeyStroke CLOSE;
    public static final KeyStroke SSL_MANAGER;
    public static final KeyStroke OPEN;
    public static final KeyStroke EXIT;
    public static final KeyStroke ACTION_START;
    public static final KeyStroke REMOTE_START_ALL;
    public static final KeyStroke SAVE;
    public static final KeyStroke SAVE_ALL_AS;
    public static final KeyStroke SEARCH_TREE;
    public static final KeyStroke TOGGLE;
    public static final KeyStroke PASTE;
    public static final KeyStroke WHAT_CLASS;
    public static final KeyStroke CUT;
    public static final KeyStroke REMOTE_STOP_ALL;
    public static final KeyStroke REMOTE_SHUT_ALL;
    public static final KeyStroke REMOVE;
    public static final KeyStroke ACTION_STOP;
    public static final KeyStroke ACTION_SHUTDOWN;
    public static final KeyStroke COLLAPSE_ALL;
    public static final KeyStroke COLLAPSE_ALL_SUBTRACT;
    public static final KeyStroke EXPAND_ALL;
    public static final KeyStroke EXPAND_ALL_SUBTRACT;
    public static final KeyStroke ALT_UP_ARROW;
    public static final KeyStroke ALT_DOWN_ARROW;
    public static final KeyStroke ALT_LEFT_ARROW;
    public static final KeyStroke ALT_RIGHT_ARROW;
    public static final KeyStroke SHIFT_LEFT_ARROW;
    public static final KeyStroke SHIFT_RIGHT_ARROW;
    public static final KeyStroke CTRL_0;
    public static final KeyStroke CTRL_1;
    public static final KeyStroke CTRL_2;
    public static final KeyStroke CTRL_3;
    public static final KeyStroke CTRL_4;
    public static final KeyStroke CTRL_5;
    public static final KeyStroke CTRL_6;
    public static final KeyStroke CTRL_7;
    public static final KeyStroke CTRL_8;
    public static final KeyStroke CTRL_9;

    private KeyStrokes() {
    }

    public static boolean matches(KeyEvent e, KeyStroke k) {
        int modifiersEx = e.getModifiersEx() | e.getModifiers();
        return e.getKeyCode() == k.getKeyCode() && modifiersEx == k.getModifiers();
    }

    static {
        int mask;
        block2: {
            mask = 128;
            try {
                mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (HeadlessException e) {
                if ("true".equals(System.getProperty("java.awt.headless"))) break block2;
                throw e;
            }
        }
        CONTROL_MASK = mask;
        COPY = KeyStroke.getKeyStroke(67, CONTROL_MASK);
        DUPLICATE = KeyStroke.getKeyStroke(67, CONTROL_MASK | 0x40);
        DEBUG_OFF = KeyStroke.getKeyStroke(68, CONTROL_MASK);
        DEBUG_ON = KeyStroke.getKeyStroke(68, CONTROL_MASK | 0x40);
        CLEAR_ALL = KeyStroke.getKeyStroke(69, CONTROL_MASK);
        CLEAR = KeyStroke.getKeyStroke(69, CONTROL_MASK | 0x40);
        ESC = KeyStroke.getKeyStroke(27, 0);
        ENTER = KeyStroke.getKeyStroke(10, 0);
        FUNCTIONS = KeyStroke.getKeyStroke(112, CONTROL_MASK | 0x40);
        SAVE_GRAPHICS = KeyStroke.getKeyStroke(71, CONTROL_MASK);
        SAVE_GRAPHICS_ALL = KeyStroke.getKeyStroke(71, CONTROL_MASK | 0x40);
        HELP = KeyStroke.getKeyStroke(72, CONTROL_MASK);
        CLOSE = KeyStroke.getKeyStroke(76, CONTROL_MASK);
        SSL_MANAGER = KeyStroke.getKeyStroke(77, CONTROL_MASK);
        OPEN = KeyStroke.getKeyStroke(79, CONTROL_MASK);
        EXIT = KeyStroke.getKeyStroke(81, CONTROL_MASK);
        ACTION_START = KeyStroke.getKeyStroke(82, CONTROL_MASK);
        REMOTE_START_ALL = KeyStroke.getKeyStroke(82, CONTROL_MASK | 0x40);
        SAVE = KeyStroke.getKeyStroke(83, CONTROL_MASK);
        SAVE_ALL_AS = KeyStroke.getKeyStroke(83, CONTROL_MASK | 0x40);
        SEARCH_TREE = KeyStroke.getKeyStroke(70, CONTROL_MASK);
        TOGGLE = KeyStroke.getKeyStroke(84, CONTROL_MASK);
        PASTE = KeyStroke.getKeyStroke(86, CONTROL_MASK);
        WHAT_CLASS = KeyStroke.getKeyStroke(87, CONTROL_MASK);
        CUT = KeyStroke.getKeyStroke(88, CONTROL_MASK);
        REMOTE_STOP_ALL = KeyStroke.getKeyStroke(88, 512);
        REMOTE_SHUT_ALL = KeyStroke.getKeyStroke(90, 512);
        REMOVE = KeyStroke.getKeyStroke(127, 0);
        ACTION_STOP = KeyStroke.getKeyStroke(46, CONTROL_MASK);
        ACTION_SHUTDOWN = KeyStroke.getKeyStroke(44, CONTROL_MASK);
        COLLAPSE_ALL = KeyStroke.getKeyStroke(45, CONTROL_MASK);
        COLLAPSE_ALL_SUBTRACT = KeyStroke.getKeyStroke(109, CONTROL_MASK);
        EXPAND_ALL = KeyStroke.getKeyStroke(45, CONTROL_MASK | 0x40);
        EXPAND_ALL_SUBTRACT = KeyStroke.getKeyStroke(109, CONTROL_MASK | 0x40);
        ALT_UP_ARROW = KeyStroke.getKeyStroke(38, 512);
        ALT_DOWN_ARROW = KeyStroke.getKeyStroke(40, 512);
        ALT_LEFT_ARROW = KeyStroke.getKeyStroke(37, 512);
        ALT_RIGHT_ARROW = KeyStroke.getKeyStroke(39, 512);
        SHIFT_LEFT_ARROW = KeyStroke.getKeyStroke(37, 64);
        SHIFT_RIGHT_ARROW = KeyStroke.getKeyStroke(39, 64);
        CTRL_0 = KeyStroke.getKeyStroke(48, CONTROL_MASK);
        CTRL_1 = KeyStroke.getKeyStroke(49, CONTROL_MASK);
        CTRL_2 = KeyStroke.getKeyStroke(50, CONTROL_MASK);
        CTRL_3 = KeyStroke.getKeyStroke(51, CONTROL_MASK);
        CTRL_4 = KeyStroke.getKeyStroke(52, CONTROL_MASK);
        CTRL_5 = KeyStroke.getKeyStroke(53, CONTROL_MASK);
        CTRL_6 = KeyStroke.getKeyStroke(54, CONTROL_MASK);
        CTRL_7 = KeyStroke.getKeyStroke(55, CONTROL_MASK);
        CTRL_8 = KeyStroke.getKeyStroke(56, CONTROL_MASK);
        CTRL_9 = KeyStroke.getKeyStroke(57, CONTROL_MASK);
    }
}

