/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.CheckBoxPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@GUIMenuSortOrder(value=2)
public class TransactionControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox generateParentSample;
    private JCheckBox includeTimers;

    public TransactionControllerGui() {
        this.init();
    }

    @Override
    public TestElement createTestElement() {
        TransactionController lc = new TransactionController();
        lc.setIncludeTimers(false);
        this.configureTestElement(lc);
        return lc;
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        this.generateParentSample.setSelected(((TransactionController)el).isGenerateParentSample());
        this.includeTimers.setSelected(((TransactionController)el).isIncludeTimers());
    }

    @Override
    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        ((TransactionController)el).setGenerateParentSample(this.generateParentSample.isSelected());
        TransactionController tc = (TransactionController)el;
        tc.setGenerateParentSample(this.generateParentSample.isSelected());
        tc.setIncludeTimers(this.includeTimers.isSelected());
    }

    @Override
    public String getLabelResource() {
        return "transaction_controller_title";
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.generateParentSample = new JCheckBox(JMeterUtils.getResString("transaction_controller_parent"));
        this.add(CheckBoxPanel.wrap(this.generateParentSample));
        this.includeTimers = new JCheckBox(JMeterUtils.getResString("transaction_controller_include_timers"), true);
        this.add(CheckBoxPanel.wrap(this.includeTimers));
    }
}

