/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.DeepCopyRuleSet;
import net.sf.saxon.trans.rules.DeepSkipRuleSet;
import net.sf.saxon.trans.rules.FailRuleSet;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.trans.rules.RuleSetWithWarnings;
import net.sf.saxon.trans.rules.ShallowCopyRuleSet;
import net.sf.saxon.trans.rules.ShallowSkipRuleSet;
import net.sf.saxon.trans.rules.TextOnlyCopyRuleSet;
import net.sf.saxon.value.Whitespace;

public class XSLMode
extends StyleElement {
    private SimpleMode mode;
    private Set<? extends Accumulator> accumulators;
    private boolean prepared = false;
    private boolean streamable = false;
    private boolean failOnMultipleMatch = false;
    private boolean warningOnNoMatch = false;
    private boolean warningOnMultipleMatch = true;
    private boolean traceMatching = false;
    private BuiltInRuleSet defaultRules = TextOnlyCopyRuleSet.getInstance();

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public boolean isInstruction() {
        return false;
    }

    @Override
    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            String nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (nameAtt == null) {
                return Mode.UNNAMED_MODE_NAME;
            }
            try {
                qn = this.makeQName(nameAtt);
                this.setObjectName(qn);
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-mode-" + this.generateId());
            }
        }
        return qn;
    }

    @Override
    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        Component other;
        StructuredQName name = this.getObjectName();
        SymbolicName sName = new SymbolicName(174, name);
        HashMap<SymbolicName, Component> componentIndex = top.getStylesheetPackage().getComponentIndex();
        if (!name.equals(Mode.UNNAMED_MODE_NAME) && (other = componentIndex.get(sName)) != null && other.getDeclaringPackage() != top.getStylesheetPackage()) {
            this.compileError("Mode " + name.getDisplayName() + " conflicts with a public named mode in package " + other.getDeclaringPackage().getPackageName(), "XTSE3050");
        }
        this.mode = (SimpleMode)top.getRuleManager().obtainMode(name, true);
        if (name.equals(Mode.UNNAMED_MODE_NAME)) {
            top.getRuleManager().setUnnamedModeExplicit(true);
        } else if (this.mode.getDeclaringComponent().getDeclaringPackage() != this.getContainingPackage()) {
            this.compileError("Mode name conflicts with a mode in a used package", "XTSE3050");
        } else {
            top.indexMode(decl);
        }
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String visibilityAtt = null;
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        Visibility visibility = Visibility.PRIVATE;
        block48: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "streamable": {
                    this.streamable = this.processStreamableAtt(atts.getValue(a));
                    continue block48;
                }
                case "name": {
                    nameAtt = Whitespace.trim(atts.getValue(a));
                    if (nameAtt.equals("#default")) continue block48;
                    try {
                        this.setObjectName(this.makeQName(nameAtt));
                    }
                    catch (XPathException err) {
                        this.compileError(err);
                    }
                    continue block48;
                }
                case "use-accumulators": {
                    String useAccAtt = atts.getValue(a);
                    this.accumulators = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry().getUsedAccumulators(useAccAtt, this);
                    continue block48;
                }
                case "on-multiple-match": {
                    String att;
                    switch (att = Whitespace.trim(atts.getValue(a))) {
                        case "fail": {
                            this.failOnMultipleMatch = true;
                            continue block48;
                        }
                        case "use-last": {
                            this.failOnMultipleMatch = false;
                            continue block48;
                        }
                    }
                    this.invalidAttribute(f, "fail|use-last");
                    continue block48;
                }
                case "on-no-match": {
                    String value = Whitespace.trim(atts.getValue(a));
                    assert (value != null);
                    switch (value) {
                        case "text-only-copy": {
                            continue block48;
                        }
                        case "shallow-copy": {
                            this.defaultRules = ShallowCopyRuleSet.getInstance();
                            continue block48;
                        }
                        case "deep-copy": {
                            this.defaultRules = DeepCopyRuleSet.getInstance();
                            continue block48;
                        }
                        case "shallow-skip": {
                            this.defaultRules = ShallowSkipRuleSet.getInstance();
                            continue block48;
                        }
                        case "deep-skip": {
                            this.defaultRules = DeepSkipRuleSet.getInstance();
                            continue block48;
                        }
                        case "fail": {
                            this.defaultRules = FailRuleSet.getInstance();
                            continue block48;
                        }
                    }
                    this.invalidAttribute(f, "text-only-copy|shallow-copy|deep-copy|shallow-skip|deep-skip|fail");
                    continue block48;
                }
                case "warning-on-multiple-match": {
                    String att = Whitespace.trim(atts.getValue(a));
                    this.warningOnMultipleMatch = this.processBooleanAttribute("warning-on-multiple-match", att);
                    continue block48;
                }
                case "warning-on-no-match": {
                    String att = Whitespace.trim(atts.getValue(a));
                    this.warningOnNoMatch = this.processBooleanAttribute("warning-on-no-match", att);
                    continue block48;
                }
                case "typed": {
                    String att = Whitespace.trim(atts.getValue(a));
                    this.checkAttributeValue("typed", att, false, new String[]{"0", "1", "false", "lax", "no", "strict", "true", "unspecified", "yes"});
                    continue block48;
                }
                case "visibility": {
                    visibilityAtt = Whitespace.trim(atts.getValue(a));
                    visibility = this.interpretVisibilityValue(visibilityAtt, "");
                    if (visibility == Visibility.ABSTRACT) {
                        this.invalidAttribute(f, "public|private|final");
                    }
                    if (visibility == Visibility.PRIVATE) continue block48;
                    this.mode.setDeclaredVisibility(visibility);
                    continue block48;
                }
                default: {
                    String att;
                    if (atts.getURI(a).equals("http://saxon.sf.net/") && atts.getLocalName(a).equals("trace")) {
                        att = Whitespace.trim(atts.getValue(a));
                        this.traceMatching = this.processBooleanAttribute("saxon:trace", att);
                        continue block48;
                    }
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (nameAtt == null && visibilityAtt != null && this.mode.getDeclaredVisibility() != Visibility.PRIVATE) {
            this.compileError("The unnamed mode must be private", "XTSE0020");
        }
        RuleManager manager = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
        if (this.getObjectName() == null) {
            this.mode = manager.getUnnamedMode();
        } else {
            Mode m = manager.obtainMode(this.getObjectName(), true);
            if (m instanceof SimpleMode) {
                this.mode = (SimpleMode)m;
            } else {
                this.compileError("Mode name refers to an overridden mode");
                this.mode = manager.getUnnamedMode();
            }
        }
        this.mode.setStreamable(this.streamable);
        if (this.streamable) {
            Mode omniMode = manager.obtainMode(Mode.OMNI_MODE, true);
            omniMode.setStreamable(true);
        }
        if (this.warningOnNoMatch) {
            this.defaultRules = new RuleSetWithWarnings(this.defaultRules);
        }
        this.mode.setBuiltInRuleSet(this.defaultRules);
        int recoveryPolicy = this.failOnMultipleMatch ? 2 : (this.warningOnMultipleMatch ? 1 : 0);
        this.mode.setRecoveryPolicy(recoveryPolicy);
        if (this.mode.getDeclaringComponent() == null) {
            this.mode.makeDeclaringComponent(visibility, this.getContainingPackage());
        }
        this.mode.setModeTracing(this.traceMatching);
        this.getContainingPackage().getComponent(this.mode.getSymbolicName()).setVisibility(visibility, visibilityAtt != null);
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("streamable") || f.equals("on-multiple-match") || f.equals("on-no-match") || f.equals("warning-on-multiple-match") || f.equals("warning-on-no-match") || f.equals("typed")) {
                String att = Whitespace.trim(atts.getValue(a));
                String normalizedAtt = "true".equals(att) || "1".equals(att) ? "yes" : ("false".equals(att) || "0".equals(att) ? "no" : att);
                this.mode.getActivePart().setExplicitProperty(f, normalizedAtt, decl.getPrecedence());
                if (!this.mode.isMustBeTyped() || !this.getContainingPackage().getTargetEdition().matches("JS\\d?")) continue;
                this.compileWarning("In Saxon-JS, all data is untyped", "XTTE3110");
                continue;
            }
            if (!f.equals("use-accumulators") || this.accumulators == null) continue;
            Object[] names = new String[this.accumulators.size()];
            int i = 0;
            for (Accumulator accumulator : this.accumulators) {
                names[i++] = accumulator.getAccumulatorName().getEQName();
            }
            Arrays.sort(names);
            String allNames = Arrays.toString(names);
            this.mode.getActivePart().setExplicitProperty(f, allNames, decl.getPrecedence());
        }
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        StylesheetPackage pack = this.getPrincipalStylesheetModule().getStylesheetPackage();
        Component c = pack.getComponent(this.mode.getSymbolicName());
        if (c == null) {
            throw new AssertionError();
        }
        if (this.accumulators != null) {
            this.mode.setAccumulators(this.accumulators);
        }
    }
}

