/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsDayOfWeek<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Set<DayOfWeek> daysOfWeeks = new HashSet<DayOfWeek>();
    private final String description;
    private final TemporalAdapter<T> accessor;

    public IsDayOfWeek(List<DayOfWeek> daysOfWeek, TemporalAdapter<T> accessor) {
        this.daysOfWeeks.addAll(daysOfWeek);
        this.description = this.describeDaysOfWeek(daysOfWeek);
        this.accessor = accessor;
    }

    public IsDayOfWeek(DayOfWeek dayOfWeek, TemporalAdapter<T> accessor) {
        this(Arrays.asList(dayOfWeek), accessor);
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        DayOfWeek actualValue = DayOfWeek.of(this.accessor.asTemporal(actual).get(ChronoField.DAY_OF_WEEK));
        if (this.daysOfWeeks.contains(actualValue)) {
            return true;
        }
        mismatchDesc.appendText("the date is on a " + actualValue.name().toLowerCase());
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date is on a " + this.description);
    }

    private String describeDaysOfWeek(List<DayOfWeek> daysOfWeek) {
        StringBuffer buffer = new StringBuffer();
        String seperator = "";
        for (int i = 0; i < daysOfWeek.size(); ++i) {
            buffer.append(seperator).append(daysOfWeek.get(i).name().toLowerCase());
            seperator = i == daysOfWeek.size() - 2 ? " or " : ", ";
        }
        return buffer.toString();
    }
}

