/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.StylesheetCache;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformFn
extends SystemFunction
implements Callable {
    private static String[] transformOptionNames30 = new String[]{"package-name", "package-version", "package-node", "package-location", "static-params", "global-context-item", "template-params", "tunnel-params", "initial-function", "function-params"};
    private static final String dummyBaseOutputUriScheme = "dummy";

    private boolean isTransformOptionName30(String string) {
        for (String s : transformOptionNames30) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static OptionsParameter makeOptionsParameter() {
        OptionsParameter op = new OptionsParameter();
        op.addAllowedOption("xslt-version", SequenceType.SINGLE_DECIMAL);
        op.addAllowedOption("stylesheet-location", SequenceType.SINGLE_STRING);
        op.addAllowedOption("stylesheet-node", SequenceType.SINGLE_NODE);
        op.addAllowedOption("stylesheet-text", SequenceType.SINGLE_STRING);
        op.addAllowedOption("stylesheet-base-uri", SequenceType.SINGLE_STRING);
        op.addAllowedOption("base-output-uri", SequenceType.SINGLE_STRING);
        op.addAllowedOption("stylesheet-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("initial-match-selection", SequenceType.ANY_SEQUENCE);
        op.addAllowedOption("source-node", SequenceType.SINGLE_NODE);
        op.addAllowedOption("source-location", SequenceType.SINGLE_STRING);
        op.addAllowedOption("initial-mode", SequenceType.SINGLE_QNAME);
        op.addAllowedOption("initial-template", SequenceType.SINGLE_QNAME);
        op.addAllowedOption("delivery-format", SequenceType.SINGLE_STRING);
        op.addAllowedOption("serialization-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("vendor-options", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("cache", SequenceType.SINGLE_BOOLEAN);
        op.addAllowedOption("package-name", SequenceType.SINGLE_STRING);
        op.addAllowedOption("package-version", SequenceType.SINGLE_STRING);
        op.addAllowedOption("package-node", SequenceType.SINGLE_NODE);
        op.addAllowedOption("package-location", SequenceType.SINGLE_STRING);
        op.addAllowedOption("static-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("global-context-item", SequenceType.SINGLE_ITEM);
        op.addAllowedOption("template-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("tunnel-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("initial-function", SequenceType.SINGLE_QNAME);
        op.addAllowedOption("function-params", SequenceType.makeSequenceType(ArrayItemType.ANY_ARRAY_TYPE, 16384));
        op.addAllowedOption("requested-properties", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        op.addAllowedOption("post-process", SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE), 16384));
        return op;
    }

    private void checkTransformOptions(Map<String, Sequence> options, XPathContext context, boolean isXslt30Processor) throws XPathException {
        if (options.size() == 0) {
            throw new XPathException("No transformation options supplied", "FOXT0002");
        }
        for (String keyName : options.keySet()) {
            if (!this.isTransformOptionName30(keyName) || isXslt30Processor) continue;
            throw new XPathException("The transform option " + keyName + " is only available when using an XSLT 3.0 processor", "FOXT0002");
        }
    }

    private String checkStylesheetMutualExclusion(Map<String, Sequence> map) throws XPathException {
        return this.exactlyOneOf(map, "stylesheet-location", "stylesheet-node", "stylesheet-text");
    }

    private String checkStylesheetMutualExclusion30(Map<String, Sequence> map) throws XPathException {
        String styleOption = this.exactlyOneOf(map, "stylesheet-location", "stylesheet-node", "stylesheet-text", "package-name", "package-node", "package-location");
        if (styleOption.equals("package-location")) {
            throw new XPathException("The transform option " + styleOption + " is not implemented in Saxon", "FOXT0002");
        }
        return styleOption;
    }

    private String checkInvocationMutualExclusion(Map<String, Sequence> options) throws XPathException {
        return this.oneOf(options, "initial-mode", "initial-template");
    }

    private String oneOf(Map<String, Sequence> map, String ... keys) throws XPathException {
        String found = null;
        for (String s : keys) {
            if (map.get(s) == null) continue;
            if (found != null) {
                throw new XPathException("The following transform options are mutually exclusive: " + this.enumerate(keys), "FOXT0002");
            }
            found = s;
        }
        return found;
    }

    private String exactlyOneOf(Map<String, Sequence> map, String ... keys) throws XPathException {
        String found = this.oneOf(map, keys);
        if (found == null) {
            throw new XPathException("One of the following transform options must be present: " + this.enumerate(keys));
        }
        return found;
    }

    private String enumerate(String ... keys) {
        boolean first = true;
        FastStringBuffer buffer = new FastStringBuffer(256);
        for (String k : keys) {
            if (first) {
                first = false;
            } else {
                buffer.append(" | ");
            }
            buffer.append(k);
        }
        return buffer.toString();
    }

    private String checkInvocationMutualExclusion30(Map<String, Sequence> map) throws XPathException {
        return this.oneOf(map, "initial-mode", "initial-template", "initial-function");
    }

    private void unsuitable(String option, String value) throws XPathException {
        throw new XPathException("No XSLT processor is available with xsl:" + option + " = " + value, "FOXT0001");
    }

    private boolean asBoolean(AtomicValue value) throws XPathException {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getBooleanValue();
        }
        if (value instanceof StringValue) {
            String s = Whitespace.normalizeWhitespace(value.getStringValue()).toString();
            if (s.equals("yes") || s.equals("true") || s.equals("1")) {
                return true;
            }
            if (s.equals("no") || s.equals("false") || s.equals("0")) {
                return false;
            }
        }
        throw new XPathException("Unrecognized boolean value " + value.toString(), "FOXT0002");
    }

    private void setRequestedProperties(Map<String, Sequence> options, Processor processor) throws XPathException {
        AtomicValue option;
        MapItem requestedProps = (MapItem)options.get("requested-properties").head();
        AtomicIterator optionIterator = requestedProps.keys();
        while ((option = optionIterator.next()) != null) {
            boolean b;
            StructuredQName optionName = ((QNameValue)option.head()).getStructuredQName();
            AtomicValue value = (AtomicValue)requestedProps.get(option).head();
            if (!optionName.hasURI("http://www.w3.org/1999/XSL/Transform")) continue;
            String localName = optionName.getLocalPart();
            if (localName.equals("vendor-url")) {
                if (value.getStringValue().equals("Saxonica")) continue;
                this.unsuitable("vendor-url", value.getStringValue());
                continue;
            }
            if (localName.equals("vendor-url")) {
                if (value.getStringValue().contains("saxonica.com")) continue;
                this.unsuitable("vendor-url", value.getStringValue());
                continue;
            }
            if (localName.equals("product-name")) {
                if (value.getStringValue().equals("SAXON")) continue;
                this.unsuitable("vendor-url", value.getStringValue());
                continue;
            }
            if (localName.equals("product-version")) {
                if (Version.getProductVersion().startsWith(value.getStringValue())) continue;
                this.unsuitable("product-version", value.getStringValue());
                continue;
            }
            if (localName.equals("is-schema-aware")) {
                b = this.asBoolean(value);
                processor.setConfigurationProperty("http://saxon.sf.net/feature/xsltSchemaAware", b);
                if (b || !processor.getUnderlyingConfiguration().isLicensedFeature(2)) continue;
                this.unsuitable("is-schema-aware", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-serialization")) {
                b = this.asBoolean(value);
                if (b) continue;
                this.unsuitable("supports-serialization", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-backwards-compatibility")) {
                b = this.asBoolean(value);
                if (b) continue;
                this.unsuitable("supports-backwards-compatibility", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-namespace-axis")) {
                b = this.asBoolean(value);
                if (b) continue;
                this.unsuitable("supports-namespace-axis", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-streaming")) {
                b = this.asBoolean(value);
                if (b) continue;
                this.unsuitable("supports-streaming", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-dynamic-evaluation")) {
                boolean backwards = this.asBoolean(value);
                if (backwards) continue;
                this.unsuitable("supports-dynamic-evaluation", value.getStringValue());
                continue;
            }
            if (localName.equals("supports-higher-order-functions")) {
                b = this.asBoolean(value);
                if (b) continue;
                this.unsuitable("supports-higher-order-functions", value.getStringValue());
                continue;
            }
            if (localName.equals("xpath-version")) {
                String v = value.getStringValue();
                try {
                    if (!(Double.parseDouble(v) > 3.1)) continue;
                    this.unsuitable("xpath-version", value.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    this.unsuitable("xpath-version", value.getStringValue());
                }
                continue;
            }
            if (!localName.equals("xsd-version")) continue;
            String v = value.getStringValue();
            try {
                if (!(Double.parseDouble(v) > 1.1)) continue;
                this.unsuitable("xsd-version", value.getStringValue());
            }
            catch (NumberFormatException nfe) {
                this.unsuitable("xsd-version", value.getStringValue());
            }
        }
    }

    private void setStaticParams(Map<String, Sequence> options, XsltCompiler xsltCompiler, boolean allowTypedNodes) throws XPathException {
        AtomicValue param;
        MapItem staticParamsMap = (MapItem)options.get("static-params").head();
        AtomicIterator paramIterator = staticParamsMap.keys();
        while ((param = paramIterator.next()) != null) {
            if (!(param instanceof QNameValue)) {
                throw new XPathException("Parameter names in static-params must be supplied as QNames", "FOXT0002");
            }
            QName paramName = new QName(((QNameValue)param).getStructuredQName());
            Sequence value = staticParamsMap.get(param);
            if (!allowTypedNodes) {
                this.checkSequenceIsUntyped(value);
            }
            XdmValue paramVal = XdmValue.wrap(value);
            xsltCompiler.setParameter(paramName, paramVal);
        }
    }

    private XsltExecutable getStylesheet(Map<String, Sequence> options, XsltCompiler xsltCompiler, String styleOptionStr, XPathContext context) throws XPathException {
        boolean cacheable;
        URI styleBase;
        Item styleOptionItem = options.get(styleOptionStr).head();
        StringValue styleBaseUri = null;
        Sequence seq = options.get("stylesheet-base-uri");
        if (seq != null && !(styleBase = URI.create((styleBaseUri = (StringValue)seq.head()).getStringValue())).isAbsolute()) {
            URI staticBase = this.getRetainedStaticContext().getStaticBaseUri();
            styleBase = staticBase.resolve(styleBase);
        }
        final ArrayList<TransformerException> compileErrors = new ArrayList<TransformerException>();
        final ErrorListener originalListener = xsltCompiler.getErrorListener();
        xsltCompiler.setErrorListener(new ErrorListener(){

            public void warning(TransformerException exception) throws TransformerException {
                originalListener.warning(exception);
            }

            public void error(TransformerException exception) throws TransformerException {
                compileErrors.add(exception);
                originalListener.error(exception);
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                compileErrors.add(exception);
                originalListener.fatalError(exception);
            }
        });
        boolean bl = cacheable = options.get("static-params") == null;
        if (options.get("cache") != null) {
            cacheable &= ((BooleanValue)options.get("cache").head()).getBooleanValue();
        }
        StylesheetCache cache = context.getController().getStylesheetCache();
        XsltExecutable executable = null;
        if (styleOptionStr.equals("stylesheet-location")) {
            String stylesheetLocation = styleOptionItem.getStringValue();
            if (cacheable) {
                executable = cache.getStylesheetByLocation(stylesheetLocation);
            }
            if (executable == null) {
                Source style;
                try {
                    String base = this.getStaticBaseUriString();
                    style = xsltCompiler.getURIResolver().resolve(stylesheetLocation, base);
                    if (style == null) {
                        style = xsltCompiler.getProcessor().getUnderlyingConfiguration().getSystemURIResolver().resolve(stylesheetLocation, base);
                    }
                }
                catch (TransformerException e) {
                    throw new XPathException(e);
                }
                try {
                    executable = xsltCompiler.compile(style);
                }
                catch (SaxonApiException e) {
                    return this.reportCompileError(e, compileErrors);
                }
                if (cacheable) {
                    cache.setStylesheetByLocation(stylesheetLocation, executable);
                }
            }
        } else if (styleOptionStr.equals("stylesheet-node") || styleOptionStr.equals("package-node")) {
            NodeInfo stylesheetNode = (NodeInfo)styleOptionItem;
            if (styleBaseUri != null && !stylesheetNode.getBaseURI().equals(styleBaseUri.getStringValue())) {
                final String sysId = styleBaseUri.getStringValue();
                Builder builder = context.getController().makeBuilder();
                builder.setSystemId(sysId);
                final ExplicitLocation fixedLocation = new ExplicitLocation(sysId, -1, -1);
                ProxyReceiver filter = new ProxyReceiver(builder){

                    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
                        super.startElement(elemName, typeCode, fixedLocation, properties);
                    }

                    public void setSystemId(String systemId) {
                        super.setSystemId(sysId);
                    }
                };
                builder.open();
                stylesheetNode.copy(filter, 0, ExplicitLocation.UNKNOWN_LOCATION);
                builder.close();
                stylesheetNode = builder.getCurrentRoot();
            }
            if (cacheable) {
                executable = cache.getStylesheetByNode(stylesheetNode);
            }
            if (executable == null) {
                Source source = stylesheetNode;
                if (styleBaseUri != null) {
                    source = AugmentedSource.makeAugmentedSource(source);
                    source.setSystemId(styleBaseUri.getStringValue());
                }
                try {
                    executable = xsltCompiler.compile(source);
                }
                catch (SaxonApiException e) {
                    this.reportCompileError(e, compileErrors);
                }
                if (cacheable) {
                    cache.setStylesheetByNode(stylesheetNode, executable);
                }
            }
        } else if (styleOptionStr.equals("stylesheet-text")) {
            String stylesheetText = styleOptionItem.getStringValue();
            if (cacheable) {
                executable = cache.getStylesheetByText(stylesheetText);
            }
            if (executable == null) {
                StringReader sr = new StringReader(stylesheetText);
                SAXSource style = new SAXSource(new InputSource(sr));
                if (styleBaseUri != null) {
                    style.setSystemId(styleBaseUri.getStringValue());
                }
                try {
                    executable = xsltCompiler.compile(style);
                }
                catch (SaxonApiException e) {
                    this.reportCompileError(e, compileErrors);
                }
                if (cacheable) {
                    cache.setStylesheetByText(stylesheetText, executable);
                }
            }
        } else if (styleOptionStr.equals("package-name")) {
            String packageName = Whitespace.trim(styleOptionItem.getStringValue());
            String packageVersion = null;
            if (options.get("package-version") != null) {
                packageVersion = options.get("package-version").head().getStringValue();
            }
            try {
                XsltPackage pack = xsltCompiler.obtainPackage(packageName, packageVersion);
                if (pack == null) {
                    throw new XPathException("Cannot locate package " + packageName + " version " + packageVersion, "FOXT0002");
                }
                executable = pack.link();
            }
            catch (SaxonApiException e) {
                if (e.getCause() instanceof XPathException) {
                    throw (XPathException)e.getCause();
                }
                throw new XPathException(e);
            }
        }
        return executable;
    }

    private XsltExecutable reportCompileError(SaxonApiException e, List<TransformerException> compileErrors) throws XPathException {
        for (TransformerException te : compileErrors) {
            if (!(te instanceof XPathException)) continue;
            throw (XPathException)te;
        }
        if (e.getCause() instanceof XPathException) {
            throw (XPathException)e.getCause();
        }
        throw new XPathException(e);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence result;
        Sequence targetConfigValue;
        Map<String, Sequence> options = this.getDetails().optionDetails.processSuppliedOptions((MapItem)arguments[0].head(), context);
        Sequence vendorOptionsValue = options.get("vendor-options");
        MapItem vendorOptions = vendorOptionsValue == null ? null : (MapItem)vendorOptionsValue.head();
        boolean allowTypedNodes = true;
        Configuration targetConfig = context.getConfiguration();
        if (vendorOptions != null && (targetConfigValue = vendorOptions.get(new QNameValue("", "http://saxon.sf.net/", "configuration"))) != null) {
            NodeInfo configFile = (NodeInfo)targetConfigValue.head();
            targetConfig = Configuration.readConfiguration(configFile, targetConfig);
            targetConfig.importLicenseDetails(context.getConfiguration());
            if (!context.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                targetConfig.setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", false);
            }
            allowTypedNodes = false;
        }
        Processor processor = new Processor(true);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/configuration", targetConfig);
        boolean isXslt30Processor = true;
        this.checkTransformOptions(options, context, isXslt30Processor);
        boolean useXslt30Processor = isXslt30Processor;
        if (options.get("xslt-version") != null) {
            BigDecimalValue xsltVersion = (BigDecimalValue)options.get("xslt-version").head();
            if (xsltVersion.compareTo(BigDecimalValue.THREE) >= 0 && !isXslt30Processor || xsltVersion.compareTo(BigDecimalValue.THREE) > 0 && isXslt30Processor) {
                throw new XPathException("The transform option xslt-version is higher than the XSLT version supported by this processor", "FOXT0002");
            }
            useXslt30Processor = xsltVersion.compareTo(BigDecimalValue.THREE) == 0;
        }
        String principalInput = this.oneOf(options, "source-node", "source-location", "initial-match-selection");
        String invocationName = "invocation";
        String invocationOption = this.checkInvocationMutualExclusion30(options);
        if (invocationOption != null) {
            invocationName = invocationOption;
        }
        if (!invocationName.equals("initial-template") && !invocationName.equals("initial-function") && principalInput == null) {
            invocationName = "initial-template";
            options.put("initial-template", new QNameValue("", "http://www.w3.org/1999/XSL/Transform", "initial-template"));
        }
        if (invocationName.equals("initial-function") && options.get("function-params") == null) {
            throw new XPathException("Use of the transform option initial-function requires the function parameters to be supplied using the option function-params", "FOXT0002");
        }
        if (!invocationName.equals("initial-function") && options.get("function-params") != null) {
            throw new XPathException("The transform option function-params can only be used if the option initial-function is also used", "FOXT0002");
        }
        String styleOption = this.checkStylesheetMutualExclusion30(options);
        if (options.get("requested-properties") != null) {
            this.setRequestedProperties(options, processor);
        }
        XsltCompiler xsltCompiler = processor.newXsltCompiler();
        xsltCompiler.setURIResolver(context.getURIResolver());
        xsltCompiler.setJustInTimeCompilation(false);
        if (options.get("static-params") != null) {
            this.setStaticParams(options, xsltCompiler, allowTypedNodes);
        }
        XsltExecutable sheet = this.getStylesheet(options, xsltCompiler, styleOption, context);
        Xslt30Transformer transformer = sheet.load30();
        String deliveryFormat = "document";
        NodeInfo sourceNode = null;
        String sourceLocation = null;
        QName initialTemplate = null;
        QName initialMode = null;
        String baseOutputUri = null;
        HashMap<QName, XdmValue> stylesheetParams = new HashMap<QName, XdmValue>();
        MapItem serializationParamsMap = null;
        Object serializedResult = null;
        Object serializedResultFile = null;
        XdmItem globalContextItem = null;
        XdmValue initialMatchSelection = null;
        HashMap<QName, XdmValue> templateParams = new HashMap<QName, XdmValue>();
        HashMap<QName, XdmValue> tunnelParams = new HashMap<QName, XdmValue>();
        QName initialFunction = null;
        XdmValue[] functionParams = null;
        Function postProcessor = null;
        String principalResultKey = "output";
        int schemaValidation = 0;
        for (String name : options.keySet()) {
            MapItem params;
            Sequence value = options.get(name);
            Item head = value.head();
            if (name.equals("source-node")) {
                sourceNode = (NodeInfo)head;
                if (allowTypedNodes) continue;
                this.checkSequenceIsUntyped(sourceNode);
                continue;
            }
            if (name.equals("source-location")) {
                sourceLocation = head.getStringValue();
                continue;
            }
            if (name.equals("initial-template")) {
                initialTemplate = new QName(((QNameValue)head).getStructuredQName());
                continue;
            }
            if (name.equals("initial-mode")) {
                initialMode = new QName(((QNameValue)head).getStructuredQName());
                continue;
            }
            if (name.equals("initial-match-selection")) {
                initialMatchSelection = XdmValue.wrap(value);
                if (allowTypedNodes) continue;
                this.checkSequenceIsUntyped(value);
                continue;
            }
            if (name.equals("delivery-format")) {
                deliveryFormat = head.getStringValue();
                if (deliveryFormat.equals("document") || deliveryFormat.equals("serialized") || deliveryFormat.equals("raw")) continue;
                throw new XPathException("The transform option delivery-format should be one of: document|serialized|raw ", "FOXT0002");
            }
            if (name.equals("base-output-uri")) {
                principalResultKey = baseOutputUri = head.getStringValue();
                continue;
            }
            if (name.equals("serialization-params")) {
                serializationParamsMap = (MapItem)head;
                continue;
            }
            if (name.equals("stylesheet-params")) {
                params = (MapItem)head;
                this.processParams(params, stylesheetParams, allowTypedNodes);
                continue;
            }
            if (name.equals("global-context-item")) {
                if (!useXslt30Processor) continue;
                globalContextItem = (XdmItem)XdmValue.wrap(head);
                if (allowTypedNodes || !(globalContextItem instanceof NodeInfo) || !((NodeInfo)((Object)globalContextItem)).getTreeInfo().isTyped()) continue;
                throw new XPathException("Schema-validated nodes cannot be passed to fn:transform() when it runs under a different Saxon Configuration", "FOXT0002");
            }
            if (name.equals("template-params")) {
                params = (MapItem)head;
                this.processParams(params, templateParams, allowTypedNodes);
                continue;
            }
            if (name.equals("tunnel-params")) {
                params = (MapItem)head;
                this.processParams(params, tunnelParams, allowTypedNodes);
                continue;
            }
            if (name.equals("initial-function")) {
                initialFunction = new QName(((QNameValue)head).getStructuredQName());
                continue;
            }
            if (name.equals("function-params")) {
                ArrayItem functionParamsArray = (ArrayItem)head;
                functionParams = new XdmValue[functionParamsArray.arrayLength()];
                for (int i = 0; i < functionParams.length; ++i) {
                    Sequence argVal = functionParamsArray.get(i);
                    if (!allowTypedNodes) {
                        this.checkSequenceIsUntyped(argVal);
                    }
                    functionParams[i] = XdmValue.wrap(argVal);
                }
                continue;
            }
            if (!name.equals("post-process")) continue;
            postProcessor = (Function)head;
        }
        if (baseOutputUri == null) {
            baseOutputUri = this.getStaticBaseUriString();
        } else {
            try {
                URI base = new URI(baseOutputUri);
                if (!base.isAbsolute()) {
                    base = this.getRetainedStaticContext().getStaticBaseUri().resolve(baseOutputUri);
                    baseOutputUri = base.toASCIIString();
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Invalid base output URI " + baseOutputUri, "FOXT0002");
            }
        }
        Deliverer deliverer = Deliverer.makeDeliverer(deliveryFormat);
        deliverer.setTransformer(transformer);
        deliverer.setBaseOutputUri(baseOutputUri);
        deliverer.setPrincipalResultKey(principalResultKey);
        deliverer.setPostProcessor(postProcessor, context);
        Controller controller = transformer.getUnderlyingController();
        controller.setOutputURIResolver(deliverer);
        Destination destination = deliverer.getPrimaryDestination(serializationParamsMap);
        try {
            transformer.setStylesheetParameters(stylesheetParams);
            transformer.setBaseOutputURI(baseOutputUri);
            transformer.setInitialTemplateParameters(templateParams, false);
            transformer.setInitialTemplateParameters(tunnelParams, true);
            if (schemaValidation == 1 || schemaValidation == 2) {
                if (sourceNode != null) {
                    sourceNode = TransformFn.validate(sourceNode, targetConfig, schemaValidation);
                } else if (sourceLocation != null) {
                    StreamSource ss = new StreamSource(sourceLocation);
                    ParseOptions parseOptions = new ParseOptions(targetConfig.getParseOptions());
                    parseOptions.setSchemaValidationMode(schemaValidation);
                    TreeInfo tree = targetConfig.buildDocumentTree(ss, parseOptions);
                    sourceNode = tree.getRootNode();
                    sourceLocation = null;
                }
                if (globalContextItem instanceof XdmNode) {
                    NodeInfo v = TransformFn.validate(((XdmNode)globalContextItem).getUnderlyingNode(), targetConfig, schemaValidation);
                    globalContextItem = (XdmNode)XdmValue.wrap(v);
                }
            }
            if (sourceNode != null && globalContextItem == null) {
                transformer.setGlobalContextItem(new XdmNode(sourceNode.getRoot()));
            }
            if (globalContextItem != null) {
                transformer.setGlobalContextItem(globalContextItem);
            }
            if (initialTemplate != null) {
                if (deliveryFormat.equals("raw")) {
                    result = transformer.callTemplate(initialTemplate).getUnderlyingValue();
                    result = deliverer.postProcess(principalResultKey, result);
                } else {
                    transformer.callTemplate(initialTemplate, destination);
                    result = deliverer.getPrimaryResult();
                }
            } else if (initialFunction != null) {
                if (deliveryFormat.equals("raw")) {
                    result = transformer.callFunction(initialFunction, functionParams).getUnderlyingValue();
                    result = deliverer.postProcess(principalResultKey, result);
                } else {
                    transformer.callFunction(initialFunction, functionParams, destination);
                    result = deliverer.getPrimaryResult();
                }
            } else {
                if (initialMode != null) {
                    transformer.setInitialMode(initialMode);
                }
                if (initialMatchSelection == null && sourceNode != null) {
                    initialMatchSelection = XdmValue.wrap(sourceNode);
                }
                if (initialMatchSelection == null) {
                    StreamSource stream = new StreamSource(sourceLocation);
                    if (deliveryFormat.equals("raw")) {
                        result = transformer.applyTemplates(stream).getUnderlyingValue();
                        result = deliverer.postProcess(principalResultKey, result);
                    } else {
                        transformer.applyTemplates(stream, destination);
                        result = deliverer.getPrimaryResult();
                    }
                } else if (deliveryFormat.equals("raw")) {
                    result = transformer.applyTemplates(initialMatchSelection).getUnderlyingValue();
                    result = deliverer.postProcess(principalResultKey, result);
                } else {
                    transformer.applyTemplates(initialMatchSelection, destination);
                    result = deliverer.getPrimaryResult();
                }
            }
        }
        catch (SaxonApiException e) {
            if (e.getCause() instanceof XPathException) {
                XPathException e2 = (XPathException)e.getCause();
                e2.setIsGlobalError(false);
                throw e2;
            }
            throw new XPathException(e);
        }
        HashTrieMap resultMap = new HashTrieMap();
        resultMap = deliverer.populateResultMap(resultMap);
        if (result != null) {
            result = SequenceTool.toGroundedValue(result);
            StringValue resultKey = new StringValue(principalResultKey);
            resultMap = resultMap.addEntry(resultKey, result);
        }
        return resultMap;
    }

    private void processParams(MapItem suppliedParams, Map<QName, XdmValue> checkedParams, boolean allowTypedNodes) throws XPathException {
        AtomicValue param;
        AtomicIterator paramIterator = suppliedParams.keys();
        while ((param = paramIterator.next()) != null) {
            if (!(param instanceof QNameValue)) {
                throw new XPathException("The names of parameters must be supplied as QNames", "FOXT0002");
            }
            QName paramName = new QName(((QNameValue)param).getStructuredQName());
            Sequence value = suppliedParams.get(param);
            if (!allowTypedNodes) {
                this.checkSequenceIsUntyped(value);
            }
            XdmValue paramVal = XdmValue.wrap(value);
            checkedParams.put(paramName, paramVal);
        }
    }

    private void checkSequenceIsUntyped(Sequence value) throws XPathException {
        Item item;
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (!(item instanceof NodeInfo) || !((NodeInfo)item).getTreeInfo().isTyped()) continue;
            throw new XPathException("Schema-validated nodes cannot be passed to fn:transform() when it runs under a different Saxon Configuration", "FOXT0002");
        }
    }

    private static NodeInfo validate(NodeInfo node, Configuration config, int validation) throws XPathException {
        ParseOptions options = new ParseOptions(config.getParseOptions());
        options.setSchemaValidationMode(validation);
        return config.buildDocumentTree(node, options).getRootNode();
    }

    private static class RawDeliverer
    extends Deliverer {
        private Map<String, XdmValue> results = new ConcurrentHashMap<String, XdmValue>();

        public Destination getPrimaryDestination(MapItem serializationParamsMap) throws XPathException {
            return null;
        }

        public Sequence getPrimaryResult() {
            return null;
        }

        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            if (absoluteURI.toString().contains("http://saxonica.com/output-raw/output")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            return new StreamResult(new File(absoluteURI));
        }

        public void close(Result result) throws XPathException {
        }

        public HashTrieMap populateResultMap(HashTrieMap resultMap) throws XPathException {
            for (Map.Entry<String, XdmValue> entry : this.results.entrySet()) {
                String uri = entry.getKey();
                resultMap = resultMap.addEntry(new StringValue(uri), this.postProcess(uri, entry.getValue().getUnderlyingValue()));
            }
            return resultMap;
        }
    }

    private static class SerializedDeliverer
    extends Deliverer {
        private Map<String, String> results = new ConcurrentHashMap<String, String>();
        private Map<String, StringWriter> workInProgress = new ConcurrentHashMap<String, StringWriter>();
        private StringWriter primaryWriter;

        public Destination getPrimaryDestination(MapItem serializationParamsMap) throws XPathException {
            Serializer serializer = this.makeSerializer(serializationParamsMap);
            this.primaryWriter = new StringWriter();
            serializer.setOutputWriter(this.primaryWriter);
            return serializer;
        }

        public Sequence getPrimaryResult() throws XPathException {
            String str = this.primaryWriter.toString();
            if (str.isEmpty()) {
                return null;
            }
            return this.postProcess(this.baseOutputUri, new StringValue(str));
        }

        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            StringWriter writer = new StringWriter();
            if (absoluteURI.getScheme().equals(TransformFn.dummyBaseOutputUriScheme)) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            this.workInProgress.put(absoluteURI.toString(), writer);
            StreamResult streamResult = new StreamResult(writer);
            streamResult.setSystemId(absoluteURI.toString());
            return streamResult;
        }

        public void close(Result result) throws XPathException {
            StringWriter work = this.workInProgress.get(result.getSystemId());
            if (work != null) {
                String output = this.workInProgress.get(result.getSystemId()).toString();
                this.results.put(result.getSystemId(), output);
                this.workInProgress.remove(result.getSystemId());
            }
        }

        public HashTrieMap populateResultMap(HashTrieMap resultMap) throws XPathException {
            for (Map.Entry<String, String> entry : this.results.entrySet()) {
                String uri = entry.getKey();
                resultMap = resultMap.addEntry(new StringValue(uri), this.postProcess(uri, new StringValue(entry.getValue())));
            }
            return resultMap;
        }
    }

    private static class DocumentDeliverer
    extends Deliverer {
        private Map<String, TreeInfo> results = new ConcurrentHashMap<String, TreeInfo>();
        private XdmDestination destination = new XdmDestination();

        public Destination getPrimaryDestination(MapItem serializationParamsMap) throws XPathException {
            return this.destination;
        }

        public Sequence getPrimaryResult() throws XPathException {
            XdmNode node = this.destination.getXdmNode();
            return node == null ? null : this.postProcess(this.baseOutputUri, node.getUnderlyingNode());
        }

        protected Result createResult(URI absoluteURI) throws XPathException, IOException {
            Controller controller = this.transformer.getUnderlyingController();
            Builder builder = controller.makeBuilder();
            if (absoluteURI.getScheme().equals(TransformFn.dummyBaseOutputUriScheme)) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            builder.setSystemId(absoluteURI.toString());
            return builder;
        }

        public void close(Result result) throws XPathException {
            NodeInfo doc = ((Builder)result).getCurrentRoot();
            this.results.put(doc.getSystemId(), doc.getTreeInfo());
        }

        public HashTrieMap populateResultMap(HashTrieMap resultMap) throws XPathException {
            for (Map.Entry<String, TreeInfo> entry : this.results.entrySet()) {
                String uri = entry.getKey();
                resultMap = resultMap.addEntry(new StringValue(uri), this.postProcess(uri, entry.getValue().getRootNode()));
            }
            return resultMap;
        }
    }

    private static abstract class Deliverer
    extends StandardOutputResolver {
        protected Xslt30Transformer transformer;
        protected String baseOutputUri;
        protected String principalResultKey;
        protected Function postProcessor;
        protected XPathContext context;

        private Deliverer() {
        }

        public static Deliverer makeDeliverer(String deliveryFormat) {
            if (deliveryFormat.equals("document")) {
                return new DocumentDeliverer();
            }
            if (deliveryFormat.equals("serialized")) {
                return new SerializedDeliverer();
            }
            if (deliveryFormat.equals("raw")) {
                return new RawDeliverer();
            }
            throw new IllegalArgumentException("delivery-format");
        }

        public final void setTransformer(Xslt30Transformer transformer) {
            this.transformer = transformer;
        }

        public final void setPrincipalResultKey(String key) {
            this.principalResultKey = key;
        }

        public final void setBaseOutputUri(String uri) {
            this.baseOutputUri = uri;
        }

        public void setPostProcessor(Function postProcessor, XPathContext context) {
            this.postProcessor = postProcessor;
            this.context = context;
        }

        public abstract HashTrieMap populateResultMap(HashTrieMap var1) throws XPathException;

        public abstract Destination getPrimaryDestination(MapItem var1) throws XPathException;

        protected Serializer makeSerializer(MapItem serializationParamsMap) throws XPathException {
            Serializer serializer = this.transformer.newSerializer();
            if (serializationParamsMap != null) {
                AtomicValue param;
                AtomicIterator paramIterator = serializationParamsMap.keys();
                while ((param = paramIterator.next()) != null) {
                    QName paramName;
                    if (param instanceof StringValue) {
                        paramName = new QName(param.getStringValue());
                    } else if (param instanceof QNameValue) {
                        paramName = new QName(((QNameValue)param.head()).getStructuredQName());
                    } else {
                        throw new XPathException("Serialization parameters must be strings or QNames", "XPTY0004");
                    }
                    String paramValue = null;
                    GroundedValue supplied = (GroundedValue)serializationParamsMap.get(param);
                    if (supplied.getLength() <= 0) continue;
                    if (supplied.getLength() == 1) {
                        Item val = supplied.itemAt(0);
                        if (val instanceof StringValue) {
                            paramValue = val.getStringValue();
                        } else if (val instanceof BooleanValue) {
                            paramValue = ((BooleanValue)val).getBooleanValue() ? "yes" : "no";
                        } else if (val instanceof DecimalValue) {
                            paramValue = val.getStringValue();
                        } else if (val instanceof QNameValue) {
                            paramValue = ((QNameValue)val).getClarkName();
                        } else if (val instanceof MapItem && paramName.getClarkName().equals("use-character-maps")) {
                            CharacterMap charMap = Serialize.toCharacterMap((MapItem)val);
                            CharacterMapIndex charMapIndex = new CharacterMapIndex();
                            charMapIndex.putCharacterMap(charMap.getName(), charMap);
                            serializer.setCharacterMap(charMapIndex);
                            String existing = serializer.getCombinedOutputProperties().getProperty("use-character-maps");
                            if (existing == null) {
                                serializer.setOutputProperty(Serializer.Property.USE_CHARACTER_MAPS, charMap.getName().getClarkName());
                                continue;
                            }
                            serializer.setOutputProperty(Serializer.Property.USE_CHARACTER_MAPS, existing + " " + charMap.getName().getClarkName());
                            continue;
                        }
                    }
                    if (paramValue == null) {
                        Item it;
                        UnfailingIterator iter = supplied.iterate();
                        paramValue = "";
                        while ((it = iter.next()) != null) {
                            if (it instanceof QNameValue) {
                                paramValue = paramValue + " " + ((QNameValue)it).getClarkName();
                                continue;
                            }
                            throw new XPathException("Value of serialization parameter " + paramName.getEQName() + " not recognized", "XPTY0004");
                        }
                    }
                    Serializer.Property prop = Serializer.getProperty(paramName);
                    if (paramName.getClarkName().equals("cdata-section-elements") || paramName.getClarkName().equals("suppress-indentation")) {
                        String existing = serializer.getCombinedOutputProperties().getProperty(paramName.getLocalName());
                        if (existing == null) {
                            serializer.setOutputProperty(prop, paramValue);
                            continue;
                        }
                        serializer.setOutputProperty(prop, existing + paramValue);
                        continue;
                    }
                    serializer.setOutputProperty(prop, paramValue);
                }
            }
            return serializer;
        }

        public abstract Sequence getPrimaryResult() throws XPathException;

        public Sequence postProcess(String uri, Sequence result) throws XPathException {
            if (this.postProcessor != null) {
                result = this.postProcessor.call(this.context.newCleanContext(), new Sequence[]{new StringValue(uri), result});
            }
            return SequenceTool.makeRepeatable(result);
        }
    }
}

