/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.threads.JMeterContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmeterKeyStore {
    private static final Logger log = LoggerFactory.getLogger(JmeterKeyStore.class);
    private final KeyStore store;
    private final int startIndex;
    private final int endIndex;
    private String clientCertAliasVarName;
    private String[] names = new String[0];
    private Map<String, PrivateKey> privateKeyByAlias = new HashMap<String, PrivateKey>();
    private Map<String, X509Certificate[]> certsByAlias = new HashMap<String, X509Certificate[]>();
    private int lastAliasIndex;

    private JmeterKeyStore(String type, int startIndex, int endIndex, String clientCertAliasVarName) throws KeyStoreException {
        if (startIndex < 0 || endIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException("Invalid index(es). Start=" + startIndex + ", end=" + endIndex);
        }
        this.store = KeyStore.getInstance(type);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.clientCertAliasVarName = clientCertAliasVarName;
    }

    public void load(InputStream is, String pword) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, UnrecoverableKeyException {
        char[] pw = pword == null ? null : pword.toCharArray();
        this.store.load(is, pw);
        ArrayList<String> aliasesList = new ArrayList<String>();
        this.privateKeyByAlias = new HashMap<String, PrivateKey>();
        this.certsByAlias = new HashMap<String, X509Certificate[]>();
        if (null != is) {
            PrivateKey privateKey = null;
            int index = 0;
            Enumeration<String> aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.store.isKeyEntry(alias)) continue;
                if (index >= this.startIndex && index <= this.endIndex) {
                    privateKey = (PrivateKey)this.store.getKey(alias, pw);
                    if (null == privateKey) {
                        throw new IOException("No key found for alias: " + alias);
                    }
                    Certificate[] chain = this.store.getCertificateChain(alias);
                    if (null == chain) {
                        throw new IOException("No certificate chain found for alias: " + alias);
                    }
                    aliasesList.add(alias);
                    X509Certificate[] x509certs = new X509Certificate[chain.length];
                    for (int i = 0; i < x509certs.length; ++i) {
                        x509certs[i] = (X509Certificate)chain[i];
                    }
                    this.privateKeyByAlias.put(alias, privateKey);
                    this.certsByAlias.put(alias, x509certs);
                }
                ++index;
            }
            if (null == privateKey) {
                throw new IOException("No key(s) found");
            }
            if (index <= this.endIndex - this.startIndex && log.isWarnEnabled()) {
                log.warn("Did not find all requested aliases. Start={}, end={}, found={}", new Object[]{this.startIndex, this.endIndex, this.certsByAlias.size()});
            }
        }
        this.names = aliasesList.toArray(new String[aliasesList.size()]);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] result = this.certsByAlias.get(alias);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("No certificate found for alias:'" + alias + "'");
    }

    public String getAlias() {
        if (!StringUtils.isEmpty((CharSequence)this.clientCertAliasVarName)) {
            String aliasName = JMeterContextService.getContext().getVariables().get(this.clientCertAliasVarName);
            if (StringUtils.isEmpty((CharSequence)aliasName)) {
                log.error("No var called '{}' found", (Object)this.clientCertAliasVarName);
                throw new IllegalArgumentException("No var called '" + this.clientCertAliasVarName + "' found");
            }
            return aliasName;
        }
        int length = this.names.length;
        if (length == 0) {
            return null;
        }
        return this.names[this.getIndexAndIncrement(length)];
    }

    public int getAliasCount() {
        return this.names.length;
    }

    public String getAlias(int index) {
        int length = this.names.length;
        if (length == 0 && index == 0) {
            return null;
        }
        if (index >= length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.names[index];
    }

    public PrivateKey getPrivateKey(String alias) {
        PrivateKey pk = this.privateKeyByAlias.get(alias);
        if (pk != null) {
            return pk;
        }
        throw new IllegalArgumentException("No PrivateKey found for alias:'" + alias + "'");
    }

    public static JmeterKeyStore getInstance(String type, int startIndex, int endIndex, String clientCertAliasVarName) throws KeyStoreException {
        return new JmeterKeyStore(type, startIndex, endIndex, clientCertAliasVarName);
    }

    public static JmeterKeyStore getInstance(String type) throws KeyStoreException {
        return JmeterKeyStore.getInstance(type, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexAndIncrement(int length) {
        JmeterKeyStore jmeterKeyStore = this;
        synchronized (jmeterKeyStore) {
            int result = this.lastAliasIndex++;
            if (this.lastAliasIndex >= length) {
                this.lastAliasIndex = 0;
            }
            return result;
        }
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        int count = this.getAliasCount();
        String[] aliases = new String[count];
        for (int i = 0; i < aliases.length; ++i) {
            aliases[i] = this.names[i];
        }
        if (aliases.length > 0) {
            return aliases;
        }
        return null;
    }
}

