/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterVersion;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterUtils
implements UnitTestManager {
    private static final Logger log = LoggerFactory.getLogger(JMeterUtils.class);
    private static final String JMETER_VARS_PREFIX = "__jm__";
    public static final String THREAD_GROUP_DISTRIBUTED_PREFIX_PROPERTY_NAME = "__jm.D_TG";
    public static final String RES_KEY_PFX = "[res_key=";
    private static final String EXPERT_MODE_PROPERTY = "jmeter.expertMode";
    private static final String ENGLISH_LANGUAGE = Locale.ENGLISH.getLanguage();
    private static volatile Properties appProperties;
    private static final Vector<LocaleChangeListener> localeChangeListeners;
    private static volatile Locale locale;
    private static volatile ResourceBundle resources;
    private static String localHostIP;
    private static String localHostName;
    private static String localHostFullName;
    private static String jmDir;
    private static String jmBin;
    private static volatile boolean ignoreResorces;
    private static final ThreadLocal<Perl5Matcher> localMatcher;

    public static Perl5Matcher getMatcher() {
        return localMatcher.get();
    }

    public static Properties getProperties(String file) {
        JMeterUtils.loadJMeterProperties(file);
        JMeterUtils.initLocale();
        return appProperties;
    }

    @Deprecated
    public static void initLogging() {
    }

    public static void initLocale() {
        String loc = appProperties.getProperty("language");
        if (loc != null) {
            String[] parts = JOrphanUtils.split((String)loc, (String)"_");
            if (parts.length == 2) {
                JMeterUtils.setLocale(new Locale(parts[0], parts[1]));
            } else {
                JMeterUtils.setLocale(new Locale(loc, ""));
            }
        } else {
            JMeterUtils.setLocale(Locale.getDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJMeterProperties(String file) {
        Properties p = new Properties(System.getProperties());
        InputStream is = null;
        try {
            File f = new File(file);
            is = new FileInputStream(f);
            p.load(is);
        }
        catch (IOException e) {
            try {
                try {
                    is = ClassLoader.getSystemResourceAsStream("org/apache/jmeter/jmeter.properties");
                    if (is == null) {
                        throw new RuntimeException("Could not read JMeter properties file:" + file);
                    }
                    p.load(is);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not read JMeter properties file:" + file);
                }
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(is);
                throw throwable;
            }
            JOrphanUtils.closeQuietly((Closeable)is);
        }
        JOrphanUtils.closeQuietly((Closeable)is);
        appProperties = p;
    }

    public static Properties loadProperties(String file) {
        return JMeterUtils.loadProperties(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadProperties(String file, Properties defaultProps) {
        Properties p = new Properties(defaultProps);
        InputStream is = null;
        try {
            File f = new File(file);
            is = new FileInputStream(f);
            p.load(is);
        }
        catch (IOException e) {
            block10: {
                URL resource;
                block9: {
                    resource = JMeterUtils.class.getClassLoader().getResource(file);
                    if (resource != null) break block9;
                    log.warn("Cannot find {}", (Object)file);
                    Properties properties = defaultProps;
                    JOrphanUtils.closeQuietly((Closeable)is);
                    return properties;
                }
                is = resource.openStream();
                if (is != null) break block10;
                log.warn("Cannot open {}", (Object)file);
                Properties properties = defaultProps;
                JOrphanUtils.closeQuietly((Closeable)is);
                return properties;
            }
            try {
                p.load(is);
                {
                    catch (IOException ex) {
                        log.warn("Error reading {} {}", (Object)file, (Object)ex.toString());
                        Properties properties = defaultProps;
                        JOrphanUtils.closeQuietly((Closeable)is);
                        return properties;
                    }
                }
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(is);
                throw throwable;
            }
            JOrphanUtils.closeQuietly((Closeable)is);
        }
        JOrphanUtils.closeQuietly((Closeable)is);
        return p;
    }

    public static PatternCacheLRU getPatternCache() {
        return LazyPatternCacheHolder.INSTANCE;
    }

    public static Pattern getPattern(String expression) throws MalformedCachePatternException {
        return JMeterUtils.getPattern(expression, 32768);
    }

    public static Pattern getPattern(String expression, int options) throws MalformedCachePatternException {
        return LazyPatternCacheHolder.INSTANCE.getPattern(expression, options);
    }

    public void initializeProperties(String file) {
        System.out.println("Initializing Properties: " + file);
        JMeterUtils.getProperties(file);
    }

    public static List<String> findClassesThatExtend(Class<?> superClass) throws IOException {
        return ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{superClass}, (boolean)false);
    }

    public static String[] getSearchPaths() {
        String p = JMeterUtils.getPropDefault("search_paths", null);
        String[] result = new String[1];
        if (p != null) {
            String[] paths = p.split(";");
            result = new String[paths.length + 1];
            System.arraycopy(paths, 0, result, 1, paths.length);
        }
        result[0] = JMeterUtils.getJMeterHome() + "/lib/ext";
        return result;
    }

    public static int getRandomInt(int r) {
        return ThreadLocalRandom.current().nextInt(r);
    }

    public static void setLocale(Locale loc) {
        log.info("Setting Locale to {}", (Object)loc);
        Locale def = null;
        boolean isDefault = false;
        if (loc.getLanguage().equals(ENGLISH_LANGUAGE)) {
            isDefault = true;
            def = Locale.getDefault();
            if (!def.getLanguage().equals(ENGLISH_LANGUAGE)) {
                Locale.setDefault(Locale.ENGLISH);
            } else {
                def = null;
            }
        }
        if ("ignoreResources".equals(loc.toString())) {
            log.warn("Resource bundles will be ignored");
            ignoreResorces = true;
        } else {
            ResourceBundle resBund;
            ignoreResorces = false;
            resources = resBund = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", loc);
            locale = loc;
            Locale resBundLocale = resBund.getLocale();
            if (!isDefault && !resBundLocale.equals(loc)) {
                if (resBundLocale.getLanguage().equals(loc.getLanguage())) {
                    log.info("Could not find resources for '{}', using '{}'", (Object)loc, (Object)resBundLocale);
                } else {
                    log.error("Could not find resources for '{}'", (Object)loc);
                }
            }
        }
        JMeterUtils.notifyLocaleChangeListeners();
        if (def != null) {
            Locale.setDefault(def);
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void addLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.add(listener);
    }

    public static void removeLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.remove(listener);
    }

    private static void notifyLocaleChangeListeners() {
        LocaleChangeEvent event = new LocaleChangeEvent(JMeterUtils.class, locale);
        Vector listeners = (Vector)localeChangeListeners.clone();
        for (LocaleChangeListener listener : listeners) {
            listener.localeChanged(event);
        }
    }

    public static String getResString(String key) {
        return JMeterUtils.getResStringDefault(key, RES_KEY_PFX + key + "]");
    }

    public static String getResString(String key, Locale forcedLocale) {
        return JMeterUtils.getResStringDefault(key, RES_KEY_PFX + key + "]", forcedLocale);
    }

    @Deprecated
    public static String getResString(String key, String defaultValue) {
        return JMeterUtils.getResStringDefault(key, defaultValue);
    }

    private static String getResStringDefault(String key, String defaultValue) {
        return JMeterUtils.getResStringDefault(key, defaultValue, null);
    }

    private static String getResStringDefault(String key, String defaultValue, Locale forcedLocale) {
        if (key == null) {
            return null;
        }
        String resKey = key.replace(' ', '_');
        resKey = resKey.toLowerCase(Locale.ENGLISH);
        String resString = null;
        try {
            ResourceBundle bundle = resources;
            if (forcedLocale != null || bundle == null) {
                bundle = JMeterUtils.getBundle(forcedLocale);
            }
            if (bundle.containsKey(resKey)) {
                resString = bundle.getString(resKey);
            } else {
                log.warn("ERROR! Resource string not found: [{}]", (Object)resKey);
                resString = defaultValue;
            }
            if (ignoreResorces) {
                return "[" + key + "]";
            }
        }
        catch (MissingResourceException mre) {
            if (ignoreResorces) {
                return "[?" + key + "?]";
            }
            log.warn("ERROR! Resource string not found: [{}]", (Object)resKey, (Object)mre);
            resString = defaultValue;
        }
        return resString;
    }

    private static ResourceBundle getBundle(Locale forcedLocale) {
        for (Locale locale : Arrays.asList(forcedLocale, JMeterUtils.getLocale())) {
            if (locale == null) continue;
            ResourceBundle bundle = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", locale);
            if (bundle == null) {
                log.warn("Could not resolve ResourceBundle for Locale [{}]", (Object)locale);
                continue;
            }
            return bundle;
        }
        return new DummyResourceBundle();
    }

    public static String getParsedLabel(String key) {
        String value = JMeterUtils.getResString(key);
        if (value != null) {
            return value.replaceFirst("(?m)\\s*?:\\s*$", "");
        }
        return null;
    }

    public static String getLocaleString(String locale) {
        String resKey = locale.toLowerCase(Locale.ENGLISH);
        if (resources.containsKey(resKey)) {
            return resources.getString(resKey);
        }
        return locale;
    }

    public static Properties getJMeterProperties() {
        return appProperties;
    }

    public static ImageIcon getImage(String name) {
        try {
            URL url = JMeterUtils.class.getClassLoader().getResource("org/apache/jmeter/images/" + name.trim());
            if (url != null) {
                return new ImageIcon(url);
            }
            log.warn("no icon for {}", (Object)name);
            return null;
        }
        catch (InternalError | NoClassDefFoundError e) {
            log.info("no icon for {} {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static ImageIcon getImage(String name, String description) {
        ImageIcon icon = JMeterUtils.getImage(name);
        if (icon != null) {
            icon.setDescription(description);
        }
        return icon;
    }

    /*
     * Exception decompiling
     */
    public static String getResourceFileAsText(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getPropDefault(String propName, int defaultVal) {
        int ans;
        try {
            ans = Integer.parseInt(appProperties.getProperty(propName, Integer.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching int property:'{}', defaulting to: {}", new Object[]{e.getMessage(), propName, defaultVal});
            ans = defaultVal;
        }
        return ans;
    }

    public static boolean getPropDefault(String propName, boolean defaultVal) {
        boolean ans;
        try {
            String strVal = appProperties.getProperty(propName, Boolean.toString(defaultVal)).trim();
            ans = "true".equalsIgnoreCase(strVal) || "t".equalsIgnoreCase(strVal) ? true : ("false".equalsIgnoreCase(strVal) || "f".equalsIgnoreCase(strVal) ? false : Integer.parseInt(strVal) == 1);
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching boolean property:'{}', defaulting to: {}", new Object[]{e.getMessage(), propName, defaultVal});
            ans = defaultVal;
        }
        return ans;
    }

    public static long getPropDefault(String propName, long defaultVal) {
        long ans;
        try {
            ans = Long.parseLong(appProperties.getProperty(propName, Long.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching long property:'{}', defaulting to: {}", new Object[]{e.getMessage(), propName, defaultVal});
            ans = defaultVal;
        }
        return ans;
    }

    public static float getPropDefault(String propName, float defaultVal) {
        float ans;
        try {
            ans = Float.parseFloat(appProperties.getProperty(propName, Float.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching float property:'{}', defaulting to: {}", new Object[]{e.getMessage(), propName, Float.valueOf(defaultVal)});
            ans = defaultVal;
        }
        return ans;
    }

    public static String getPropDefault(String propName, String defaultVal) {
        String ans = defaultVal;
        try {
            String value = appProperties.getProperty(propName, defaultVal);
            if (value != null) {
                ans = value.trim();
            }
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching String property:'{}', defaulting to: {}", new Object[]{e.getMessage(), propName, defaultVal});
            ans = defaultVal;
        }
        return ans;
    }

    public static String getProperty(String propName) {
        String ans = null;
        try {
            ans = appProperties.getProperty(propName);
        }
        catch (Exception e) {
            log.warn("Exception '{}' occurred when fetching String property:'{}'", (Object)e.getMessage(), (Object)propName);
            ans = null;
        }
        return ans;
    }

    public static Object setProperty(String propName, String propValue) {
        return appProperties.setProperty(propName, propValue);
    }

    public static void reportErrorToUser(String errorMsg) {
        JMeterUtils.reportErrorToUser(errorMsg, JMeterUtils.getResString("error_title"), null);
    }

    public static void reportErrorToUser(String errorMsg, String titleMsg) {
        JMeterUtils.reportErrorToUser(errorMsg, titleMsg, null);
    }

    public static void reportErrorToUser(String errorMsg, Exception exception) {
        JMeterUtils.reportErrorToUser(errorMsg, JMeterUtils.getResString("error_title"), exception);
    }

    public static void reportErrorToUser(String errorMsg, String titleMsg, Exception exception) {
        GuiPackage instance;
        if (errorMsg == null) {
            errorMsg = "Unknown error - see log file";
            log.warn("Unknown error", new Throwable("errorMsg == null"));
        }
        if ((instance = GuiPackage.getInstance()) == null) {
            if (exception != null) {
                log.error(errorMsg, (Throwable)exception);
            } else {
                log.error(errorMsg);
            }
            System.out.println(errorMsg);
            return;
        }
        try {
            JOptionPane.showMessageDialog(instance.getMainFrame(), errorMsg, titleMsg, 0);
        }
        catch (HeadlessException e) {
            log.warn("reportErrorToUser(\"{}\") caused", (Object)errorMsg, (Object)e);
        }
    }

    public static String unsplit(Object[] splittee, Object splitChar) {
        StringBuilder retVal = new StringBuilder();
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            }
            if (count + 1 >= splittee.length || splittee[count + 1] == null) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String unsplit(Object[] splittee, Object splitChar, String def) {
        StringBuilder retVal = new StringBuilder();
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            } else {
                retVal.append(def);
            }
            if (count + 1 >= splittee.length) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static boolean isTestRunning() {
        return JMeterContextService.getTestStartTime() > 0L;
    }

    public static String getJMeterHome() {
        return jmDir;
    }

    public static String getJMeterBinDir() {
        return jmBin;
    }

    public static void setJMeterHome(String home) {
        jmDir = home;
        jmBin = jmDir + File.separator + "bin";
    }

    public static String getJMeterVersion() {
        return JMeterVersion.getVERSION();
    }

    public static String getJMeterCopyright() {
        return JMeterVersion.getCopyRight();
    }

    public static boolean isExpertMode() {
        return JMeterUtils.getPropDefault(EXPERT_MODE_PROPERTY, false);
    }

    public static File findFile(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            f = new File(JMeterUtils.getJMeterBinDir(), fileName);
        }
        return f;
    }

    public static synchronized String getLocalHostIP() {
        if (localHostIP == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostIP;
    }

    public static synchronized String getLocalHostName() {
        if (localHostName == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostName;
    }

    public static synchronized String getLocalHostFullName() {
        if (localHostFullName == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostFullName;
    }

    private static void getLocalHostDetails() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            log.error("Unable to get local host IP address.", (Throwable)e1);
            return;
        }
        localHostIP = localHost.getHostAddress();
        localHostName = localHost.getHostName();
        localHostFullName = localHost.getCanonicalHostName();
    }

    public static LinkedHashMap<String, String> parseHeaders(String headers) {
        String[] list;
        LinkedHashMap<String, String> linkedHeaders = new LinkedHashMap<String, String>();
        for (String header : list = headers.split("\n")) {
            int colon = header.indexOf(58);
            if (colon <= 0) {
                linkedHeaders.put(header, "");
                continue;
            }
            linkedHeaders.put(header.substring(0, colon).trim(), header.substring(colon + 1).trim());
        }
        return linkedHeaders;
    }

    public static void runSafe(Runnable runnable) {
        JMeterUtils.runSafe(true, runnable);
    }

    public static void runSafe(boolean synchronous, Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else if (synchronous) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted in thread {}", (Object)Thread.currentThread().getName(), (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new Error(e);
            }
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void helpGC() {
        System.gc();
        System.runFinalization();
    }

    public static void clearMatcherMemory(Perl5Matcher matcher, Pattern pattern) {
        try {
            if (pattern != null) {
                matcher.matches("", pattern);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getHiDPIMode() {
        return JMeterUtils.getPropDefault("jmeter.hidpi.mode", false);
    }

    public static double getHiDPIScaleFactor() {
        return Double.parseDouble(JMeterUtils.getPropDefault("jmeter.hidpi.scale.factor", "1.0"));
    }

    public static void applyHiDPI(JTable table) {
        if (JMeterUtils.getHiDPIMode()) {
            table.setRowHeight((int)Math.round((double)table.getRowHeight() * JMeterUtils.getHiDPIScaleFactor()));
        }
    }

    public static String getDelimiter(String delimiterValue) {
        if ("\\t".equals(delimiterValue)) {
            delimiterValue = "\t";
        }
        if (delimiterValue.length() != 1) {
            throw new JMeterError("Delimiter '" + delimiterValue + "' must be of length 1.");
        }
        return delimiterValue;
    }

    public static void applyHiDPIOnFonts() {
        if (!JMeterUtils.getHiDPIMode()) {
            return;
        }
        JMeterUtils.applyScaleOnFonts((float)JMeterUtils.getHiDPIScaleFactor());
    }

    public static void applyScaleOnFonts(float scale) {
        log.info("Applying HiDPI scale: {}", (Object)Float.valueOf(scale));
        SwingUtilities.invokeLater(() -> {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            for (Object key : new ArrayList(defaults.keySet())) {
                Object value = defaults.get(key);
                log.debug("Try key {} with value {}", key, value);
                if (!(value instanceof Font)) continue;
                Font font = (Font)value;
                float newSize = (float)font.getSize() * scale;
                if (font instanceof FontUIResource) {
                    defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), Math.round(newSize)));
                    continue;
                }
                defaults.put(key, font.deriveFont(newSize));
            }
            JMeterUtils.refreshUI();
        });
    }

    public static final void refreshUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
            if (!w.isDisplayable() || !(w instanceof Frame ? !((Frame)w).isResizable() : !(w instanceof Dialog) || !((Dialog)w).isResizable())) continue;
            w.pack();
        }
    }

    public static void setupXStreamSecurityPolicy(XStream xstream) {
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(AnyTypePermission.ANY);
    }

    public static String formatJMeterExportedVariableName(String elementName) {
        StringBuilder builder = new StringBuilder(JMETER_VARS_PREFIX.length() + elementName.length());
        return builder.append(JMETER_VARS_PREFIX).append(elementName).toString();
    }

    static {
        localeChangeListeners = new Vector();
        localHostIP = null;
        localHostName = null;
        localHostFullName = null;
        ignoreResorces = false;
        localMatcher = new ThreadLocal<Perl5Matcher>(){

            @Override
            protected Perl5Matcher initialValue() {
                return new Perl5Matcher();
            }
        };
    }

    private static class DummyResourceBundle
    extends ResourceBundle {
        private DummyResourceBundle() {
        }

        @Override
        protected Object handleGetObject(String key) {
            return "[" + key + "]";
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }
    }

    private static class LazyPatternCacheHolder {
        public static final PatternCacheLRU INSTANCE = new PatternCacheLRU(JMeterUtils.getPropDefault("oro.patterncache.size", 1000), (PatternCompiler)new Perl5Compiler());

        private LazyPatternCacheHolder() {
        }
    }
}

