/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.UnmodifiableJMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public final class JMeterContextService {
    private static final ThreadLocal<JMeterContext> threadContext = ThreadLocal.withInitial(JMeterContext::new);
    private static long testStart = 0L;
    private static int numberOfActiveThreads = 0;
    private static int numberOfThreadsStarted = 0;
    private static int numberOfThreadsFinished = 0;
    private static int totalThreads = 0;
    private static UnmodifiableJMeterVariables variables;

    private JMeterContextService() {
    }

    public static JMeterContext getContext() {
        return threadContext.get();
    }

    static void removeContext() {
        threadContext.remove();
    }

    public static void replaceContext(JMeterContext context) {
        threadContext.remove();
        threadContext.set(context);
    }

    public static synchronized void startTest() {
        if (testStart == 0L) {
            numberOfActiveThreads = 0;
            testStart = System.currentTimeMillis();
            JMeterUtils.setProperty("TESTSTART.MS", Long.toString(testStart));
        }
    }

    static synchronized void incrNumberOfThreads() {
        ++numberOfActiveThreads;
        ++numberOfThreadsStarted;
    }

    static synchronized void decrNumberOfThreads() {
        --numberOfActiveThreads;
        ++numberOfThreadsFinished;
    }

    public static synchronized int getNumberOfThreads() {
        return numberOfActiveThreads;
    }

    public static synchronized ThreadCounts getThreadCounts() {
        return new ThreadCounts(numberOfActiveThreads, numberOfThreadsStarted, numberOfThreadsFinished);
    }

    public static synchronized void endTest() {
        testStart = 0L;
    }

    public static synchronized long getTestStartTime() {
        return testStart;
    }

    public static synchronized int getTotalThreads() {
        return totalThreads;
    }

    public static synchronized void addTotalThreads(int thisGroup) {
        totalThreads += thisGroup;
    }

    public static synchronized void clearTotalThreads() {
        totalThreads = 0;
        numberOfThreadsStarted = 0;
        numberOfThreadsFinished = 0;
    }

    public static JMeterVariables getClientSideVariables() {
        return variables;
    }

    public static void initClientSideVariables(JMeterVariables clientSideVariables) {
        variables = new UnmodifiableJMeterVariables(clientSideVariables);
    }

    public static class ThreadCounts {
        public final int activeThreads;
        public final int startedThreads;
        public final int finishedThreads;

        ThreadCounts(int active, int started, int finished) {
            this.activeThreads = active;
            this.startedThreads = started;
            this.finishedThreads = finished;
        }
    }
}

