/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class MapProperty
extends MultiProperty {
    private static final long serialVersionUID = 221L;
    private Map<String, JMeterProperty> value;
    private transient Map<String, JMeterProperty> savedValue = null;

    public MapProperty(String name, Map<?, ?> value) {
        super(name);
        log.info("map = {}", value);
        this.value = this.normalizeMap(value);
        log.info("normalized map = {}", this.value);
    }

    public MapProperty() {
        this.value = new HashMap<String, JMeterProperty>();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MapProperty && this.value != null) {
            return this.value.equals(((JMeterProperty)o).getObjectValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.value != null) {
            hash = hash * 37 + this.value.hashCode();
        }
        return hash;
    }

    @Override
    public void setObjectValue(Object v) {
        if (v instanceof Map) {
            this.setMap((Map)v);
        }
    }

    @Override
    public void addProperty(JMeterProperty prop) {
        this.addProperty(prop.getName(), prop);
    }

    public JMeterProperty get(String key) {
        return this.value.get(key);
    }

    @Override
    protected Class<? extends JMeterProperty> getPropertyType() {
        if (!this.value.isEmpty()) {
            return this.valueIterator().next().getClass();
        }
        return NullProperty.class;
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public MapProperty clone() {
        MapProperty prop = (MapProperty)super.clone();
        prop.value = this.cloneMap();
        return prop;
    }

    private Map<String, JMeterProperty> cloneMap() {
        try {
            Map newCol = (Map)this.value.getClass().newInstance();
            PropertyIterator iter = this.valueIterator();
            while (iter.hasNext()) {
                JMeterProperty item = iter.next();
                newCol.put(item.getName(), item.clone());
            }
            return newCol;
        }
        catch (Exception e) {
            log.error("Couldn't clone map", (Throwable)e);
            return this.value;
        }
    }

    public PropertyIterator valueIterator() {
        return this.getIterator(this.value.values());
    }

    public void addProperty(String name, JMeterProperty prop) {
        if (!this.value.containsKey(name)) {
            this.value.put(name, prop);
        }
    }

    public void setMap(Map<?, ?> newMap) {
        this.value = this.normalizeMap(newMap);
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.recoverRunningVersionOfSubElements(owner);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public PropertyIterator iterator() {
        return this.valueIterator();
    }

    @Override
    public void setRunningVersion(boolean running) {
        super.setRunningVersion(running);
        this.savedValue = running ? this.value : null;
    }
}

