/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.LoadRecentProject;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class JMeterMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(JMeterMenuBar.class);
    private JMenu fileMenu;
    private JMenuItem fileSaveAs;
    private JMenuItem fileRevert;
    private JMenuItem fileLoad;
    private JMenu recentFilesOpen;
    private List<JComponent> fileLoadRecentFiles = new LinkedList<JComponent>();
    private JMenuItem fileMerge;
    private JMenu editMenu;
    private JMenu editAdd;
    private JMenu runMenu;
    private JMenuItem runStart;
    private JMenuItem runStartNoTimers;
    private JMenu remoteStart;
    private Collection<JMenuItem> remoteEngineStart = new LinkedList<JMenuItem>();
    private JMenuItem runStop;
    private JMenuItem runShut;
    private JMenu remoteStop;
    private JMenu remoteShut;
    private Collection<JMenuItem> remoteEngineStop = new LinkedList<JMenuItem>();
    private Collection<JMenuItem> remoteEngineShut = new LinkedList<JMenuItem>();
    private JMenu optionsMenu;
    private JMenu helpMenu;
    private String[] remoteHosts;
    private JMenu remoteExit;
    private Collection<JMenuItem> remoteEngineExit = new LinkedList<JMenuItem>();
    private JMenu searchMenu;
    private List<MenuCreator> menuCreators;
    public static final String SYSTEM_LAF = "System";
    public static final String CROSS_PLATFORM_LAF = "CrossPlatform";
    public static final String DARCULA_LAF = "Darcula";
    public static final String DARCULA_LAF_CLASS = "com.bulenkov.darcula.DarculaLaf";

    public JMeterMenuBar() {
        this.remoteHosts = JOrphanUtils.split((String)JMeterUtils.getPropDefault("remote_hosts", ""), (String)",");
        if (this.remoteHosts.length == 1 && this.remoteHosts[0].isEmpty()) {
            this.remoteHosts = new String[0];
        }
        this.getRemoteItems();
        this.createMenuBar();
        JMeterUtils.addLocaleChangeListener(this);
    }

    public void setFileSaveEnabled(boolean enabled) {
        if (this.fileSaveAs != null) {
            this.fileSaveAs.setEnabled(enabled);
        }
    }

    public void setFileLoadEnabled(boolean enabled) {
        if (this.fileLoad != null) {
            this.fileLoad.setEnabled(enabled);
        }
        if (this.fileMerge != null) {
            this.fileMerge.setEnabled(enabled);
        }
    }

    public void setFileRevertEnabled(boolean enabled) {
        if (this.fileRevert != null) {
            this.fileRevert.setEnabled(enabled);
        }
    }

    public void setProjectFileLoaded(String file) {
        if (this.fileLoadRecentFiles != null && file != null) {
            LoadRecentProject.updateRecentFileMenuItems(this.fileLoadRecentFiles, file);
            this.recentFilesOpen.setEnabled(true);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.editMenu != null) {
            this.editMenu.setEnabled(enabled);
        }
    }

    public void setEditAddMenu(JMenu menu) {
        if (this.editAdd != null) {
            this.editMenu.remove(this.editAdd);
        }
        this.editAdd = menu;
        this.editMenu.insert(this.editAdd, 0);
    }

    public void setEditMenu(JPopupMenu menu) {
        if (menu != null) {
            this.editMenu.removeAll();
            for (Component comp : menu.getComponents()) {
                this.editMenu.add(comp);
            }
            this.editMenu.setEnabled(true);
        } else {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditAddEnabled(boolean enabled) {
        if (this.editAdd != null) {
            this.editAdd.setEnabled(enabled);
        }
        this.setEditEnabled(enabled);
    }

    public void createMenuBar() {
        this.menuCreators = this.findMenuCreators();
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeRunMenu();
        this.makeSearchMenu();
        this.makeOptionsMenu();
        this.makeHelpMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.searchMenu);
        this.add(this.runMenu);
        this.add(this.optionsMenu);
        this.menuCreators.stream().map(MenuCreator::getTopLevelMenus).flatMap(Arrays::stream).forEachOrdered(this::add);
        this.add(this.helpMenu);
    }

    private List<MenuCreator> findMenuCreators() {
        ArrayList<MenuCreator> creators = new ArrayList<MenuCreator>();
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{MenuCreator.class});
            for (String strClassName : listClasses) {
                try {
                    log.debug("Loading menu creator class: {}", (Object)strClassName);
                    Class<?> commandClass = Class.forName(strClassName);
                    if (Modifier.isAbstract(commandClass.getModifiers())) continue;
                    log.debug("Instantiating: {}", commandClass);
                    MenuCreator creator = (MenuCreator)commandClass.newInstance();
                    creators.add(creator);
                }
                catch (Exception e) {
                    log.error("Exception registering {} with implementation: {}", new Object[]{MenuCreator.class, strClassName, e});
                }
            }
        }
        catch (IOException e) {
            log.error("Exception finding implementations of {}", MenuCreator.class, (Object)e);
        }
        return creators;
    }

    private void makeHelpMenu() {
        this.helpMenu = JMeterMenuBar.makeMenuRes("help", 72);
        JMenuItem contextHelp = JMeterMenuBar.makeMenuItemRes("help", 72, "help", KeyStrokes.HELP);
        JMenuItem whatClass = JMeterMenuBar.makeMenuItemRes("help_node", 87, "what_class", KeyStrokes.WHAT_CLASS);
        JMenuItem setDebug = JMeterMenuBar.makeMenuItemRes("debug_on", "debug_on", KeyStrokes.DEBUG_ON);
        JMenuItem resetDebug = JMeterMenuBar.makeMenuItemRes("debug_off", "debug_off", KeyStrokes.DEBUG_OFF);
        JMenuItem heapDump = JMeterMenuBar.makeMenuItemRes("heap_dump", "heap_dump");
        JMenuItem threadDump = JMeterMenuBar.makeMenuItemRes("thread_dump", "thread_dump");
        JMenu usefulLinks = JMeterMenuBar.makeMenuRes("useful_links");
        usefulLinks.add(JMeterMenuBar.makeMenuItemRes("link_release_notes", "link_release_notes"));
        usefulLinks.add(JMeterMenuBar.makeMenuItemRes("link_bug_tracker", "link_bug_tracker:"));
        usefulLinks.add(JMeterMenuBar.makeMenuItemRes("link_comp_ref", "link_component_reference:"));
        usefulLinks.add(JMeterMenuBar.makeMenuItemRes("link_func_ref", "link_function_reference:"));
        usefulLinks.add(JMeterMenuBar.makeMenuItemRes("link_nightly_build", "link_nightly_build:"));
        JMenuItem helpAbout = JMeterMenuBar.makeMenuItemRes("about", 65, "about");
        this.helpMenu.add(contextHelp);
        this.helpMenu.addSeparator();
        this.helpMenu.add(whatClass);
        this.helpMenu.add(setDebug);
        this.helpMenu.add(resetDebug);
        this.helpMenu.add(heapDump);
        this.helpMenu.add(threadDump);
        this.addPluginsMenuItems(this.helpMenu, this.menuCreators, MenuCreator.MENU_LOCATION.HELP);
        this.helpMenu.addSeparator();
        this.helpMenu.add(usefulLinks);
        this.helpMenu.addSeparator();
        this.helpMenu.add(helpAbout);
    }

    private void makeOptionsMenu() {
        this.optionsMenu = JMeterMenuBar.makeMenuRes("option", 79);
        this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("function_dialog_menu_item", 70, "functions", KeyStrokes.FUNCTIONS));
        this.optionsMenu.add(this.createLaFMenu());
        JCheckBoxMenuItem menuLoggerPanel = JMeterMenuBar.makeCheckBoxMenuItemRes("menu_logger_panel", "logger_panel_enable_disable");
        GuiPackage guiInstance = GuiPackage.getInstance();
        if (guiInstance != null) {
            guiInstance.setMenuItemLoggerPanel(menuLoggerPanel);
        }
        this.optionsMenu.add(menuLoggerPanel);
        JMenu menuLoggerLevel = JMeterMenuBar.makeMenuRes("menu_logger_level");
        for (Level level : Level.values()) {
            String levelString = level.toString();
            JMenuItem menuItem = new JMenuItem(levelString);
            menuItem.addActionListener(ActionRouter.getInstance());
            menuItem.setActionCommand("loglevel:" + levelString);
            menuItem.setToolTipText(levelString);
            menuLoggerLevel.add(menuItem);
        }
        this.optionsMenu.add(menuLoggerLevel);
        if (SSLManager.isSSLSupported()) {
            this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("sslmanager", 83, "sslManager", KeyStrokes.SSL_MANAGER));
        }
        this.optionsMenu.add(JMeterMenuBar.makeLanguageMenu());
        this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("menu_collapse_all", 65, "collapse all", KeyStrokes.COLLAPSE_ALL));
        this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("menu_expand_all", 88, "expand all", KeyStrokes.EXPAND_ALL));
        this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("menu_zoom_in", 73, "zoom_in"));
        this.optionsMenu.add(JMeterMenuBar.makeMenuItemRes("menu_zoom_out", 85, "zoom_out"));
        JCheckBoxMenuItem saveBeforeRun = JMeterMenuBar.makeCheckBoxMenuItemRes("menu_save_before_run", "save_before_run");
        if (guiInstance != null) {
            saveBeforeRun.setSelected(guiInstance.shouldSaveBeforeRunByPreference());
            guiInstance.setMenuItemSaveBeforeRunPanel(saveBeforeRun);
        }
        this.optionsMenu.add(saveBeforeRun);
        this.addPluginsMenuItems(this.optionsMenu, this.menuCreators, MenuCreator.MENU_LOCATION.OPTIONS);
    }

    private JMenu createLaFMenu() {
        JMenu lafMenu = JMeterMenuBar.makeMenuRes("appearance", 76);
        for (UIManager.LookAndFeelInfo laf : JMeterMenuBar.getAllLAFs()) {
            JMenuItem menuItem = new JMenuItem(laf.getName());
            menuItem.addActionListener(ActionRouter.getInstance());
            menuItem.setActionCommand("laf:" + laf.getClassName());
            menuItem.setToolTipText(laf.getClassName());
            lafMenu.add(menuItem);
        }
        return lafMenu;
    }

    public static String[] getLanguages() {
        ArrayList<String> lang = new ArrayList<String>(20);
        lang.add(Locale.ENGLISH.toString());
        lang.add(Locale.FRENCH.toString());
        lang.add(Locale.GERMAN.toString());
        lang.add("no");
        lang.add("pl");
        lang.add("pt_BR");
        lang.add("es");
        lang.add("tr");
        lang.add(Locale.JAPANESE.toString());
        lang.add(Locale.SIMPLIFIED_CHINESE.toString());
        lang.add(Locale.TRADITIONAL_CHINESE.toString());
        String addedLocales = JMeterUtils.getProperty("locales.add");
        if (addedLocales != null) {
            Arrays.stream(addedLocales.split(",")).peek(newLang -> log.info("Adding locale {}", newLang)).forEachOrdered(lang::add);
        }
        return lang.toArray(new String[lang.size()]);
    }

    private static JMenu makeLanguageMenu() {
        JMenu languageMenu = JMeterMenuBar.makeMenuRes("choose_language", 67);
        LangMenuHelper langMenu = new LangMenuHelper(languageMenu);
        for (String lang : JMeterMenuBar.getLanguages()) {
            langMenu.addLang(lang);
        }
        return languageMenu;
    }

    private void makeRunMenu() {
        this.runMenu = JMeterMenuBar.makeMenuRes("run", 82);
        this.runStart = JMeterMenuBar.makeMenuItemRes("start", 83, "start", KeyStrokes.ACTION_START);
        this.runStartNoTimers = JMeterMenuBar.makeMenuItemRes("start_no_timers", 78, "start_no_timers");
        this.runStop = JMeterMenuBar.makeMenuItemRes("stop", 84, "stop", KeyStrokes.ACTION_STOP);
        this.runStop.setEnabled(false);
        this.runShut = JMeterMenuBar.makeMenuItemRes("shutdown", 89, "shutdown", KeyStrokes.ACTION_SHUTDOWN);
        this.runShut.setEnabled(false);
        JMenuItem runClear = JMeterMenuBar.makeMenuItemRes("clear", 67, "action.clear", KeyStrokes.CLEAR);
        JMenuItem runClearAll = JMeterMenuBar.makeMenuItemRes("clear_all", 97, "action.clear_all", KeyStrokes.CLEAR_ALL);
        this.runMenu.add(this.runStart);
        this.runMenu.add(this.runStartNoTimers);
        this.runMenu.add(this.runStop);
        this.runMenu.add(this.runShut);
        this.runMenu.addSeparator();
        if (this.remoteStart != null) {
            this.runMenu.add(this.remoteStart);
        }
        JMenuItem remoteStartAll = JMeterMenuBar.makeMenuItemRes("remote_start_all", "remote_start_all", KeyStrokes.REMOTE_START_ALL);
        this.runMenu.add(remoteStartAll);
        if (this.remoteStop != null) {
            this.runMenu.add(this.remoteStop);
        }
        JMenuItem remoteStopAll = JMeterMenuBar.makeMenuItemRes("remote_stop_all", 88, "remote_stop_all", KeyStrokes.REMOTE_STOP_ALL);
        this.runMenu.add(remoteStopAll);
        if (this.remoteShut != null) {
            this.runMenu.add(this.remoteShut);
        }
        JMenuItem remoteShutAll = JMeterMenuBar.makeMenuItemRes("remote_shut_all", 88, "remote_shut_all", KeyStrokes.REMOTE_SHUT_ALL);
        this.runMenu.add(remoteShutAll);
        if (this.remoteExit != null) {
            this.runMenu.add(this.remoteExit);
        }
        JMenuItem remoteExitAll = JMeterMenuBar.makeMenuItemRes("remote_exit_all", "remote_exit_all");
        this.runMenu.add(remoteExitAll);
        this.runMenu.addSeparator();
        this.runMenu.add(runClear);
        this.runMenu.add(runClearAll);
        this.addPluginsMenuItems(this.runMenu, this.menuCreators, MenuCreator.MENU_LOCATION.RUN);
    }

    private void makeEditMenu() {
        this.editMenu = JMeterMenuBar.makeMenuRes("edit", 69);
        this.editMenu.setEnabled(false);
        this.addPluginsMenuItems(this.editMenu, this.menuCreators, MenuCreator.MENU_LOCATION.EDIT);
    }

    private void makeFileMenu() {
        this.fileMenu = JMeterMenuBar.makeMenuRes("file", 70);
        JMenuItem fileSave = JMeterMenuBar.makeMenuItemRes("save", 83, "save", KeyStrokes.SAVE);
        this.fileSaveAs = JMeterMenuBar.makeMenuItemRes("save_all_as", 65, "save_all_as", KeyStrokes.SAVE_ALL_AS);
        this.fileSaveAs.setEnabled(true);
        JMenuItem fileSaveSelectionAs = JMeterMenuBar.makeMenuItemRes("save_as", 76, "save_as");
        fileSaveSelectionAs.setEnabled(true);
        JMenuItem fileSelectionAsTestFragment = JMeterMenuBar.makeMenuItemRes("save_as_test_fragment", 70, "save_as_test_fragment");
        fileSelectionAsTestFragment.setEnabled(true);
        this.fileRevert = JMeterMenuBar.makeMenuItemRes("revert_project", 82, "revert_project");
        this.fileRevert.setEnabled(false);
        this.fileLoad = JMeterMenuBar.makeMenuItemRes("menu_open", 79, "open", KeyStrokes.OPEN);
        this.fileLoad.setEnabled(false);
        this.recentFilesOpen = JMeterMenuBar.makeMenuRes("menu_recent", 69);
        this.recentFilesOpen.setEnabled(false);
        JMenuItem templates = JMeterMenuBar.makeMenuItemRes("template_menu", 84, "templates");
        templates.setEnabled(true);
        JMenuItem fileNew = JMeterMenuBar.makeMenuItemRes("new", 78, "close", KeyStrokes.CLOSE);
        JMenuItem fileExit = JMeterMenuBar.makeMenuItemRes("exit", 88, "exit", KeyStrokes.EXIT);
        this.fileMerge = JMeterMenuBar.makeMenuItemRes("menu_merge", 77, "merge");
        this.fileMerge.setEnabled(false);
        this.fileMenu.add(fileNew);
        this.fileMenu.add(templates);
        this.fileMenu.add(this.fileLoad);
        this.fileMenu.add(this.recentFilesOpen);
        this.fileMenu.add(this.fileMerge);
        this.fileMenu.addSeparator();
        this.fileMenu.add(fileSave);
        this.fileMenu.add(this.fileSaveAs);
        this.fileMenu.add(fileSaveSelectionAs);
        this.fileMenu.add(fileSelectionAsTestFragment);
        this.fileMenu.add(this.fileRevert);
        this.fileMenu.addSeparator();
        this.fileLoadRecentFiles = LoadRecentProject.getRecentFileMenuItems();
        this.fileLoadRecentFiles.forEach(jc -> this.recentFilesOpen.add((Component)jc));
        this.recentFilesOpen.setEnabled(LoadRecentProject.hasVisibleMenuItem(this.fileLoadRecentFiles));
        this.addPluginsMenuItems(this.fileMenu, this.menuCreators, MenuCreator.MENU_LOCATION.FILE);
        this.fileMenu.add(fileExit);
    }

    private void makeSearchMenu() {
        this.searchMenu = JMeterMenuBar.makeMenuRes("menu_search", 83);
        JMenuItem search = JMeterMenuBar.makeMenuItemRes("menu_search", 70, "search_tree", KeyStrokes.SEARCH_TREE);
        this.searchMenu.add(search);
        search.setEnabled(true);
        JMenuItem searchReset = JMeterMenuBar.makeMenuItemRes("menu_search_reset", 82, "search_reset");
        this.searchMenu.add(searchReset);
        searchReset.setEnabled(true);
        this.addPluginsMenuItems(this.searchMenu, this.menuCreators, MenuCreator.MENU_LOCATION.SEARCH);
    }

    private void addPluginsMenuItems(JMenu menu, List<MenuCreator> menuCreators, MenuCreator.MENU_LOCATION location) {
        for (MenuCreator menuCreator : menuCreators) {
            JMenuItem[] menuItems = menuCreator.getMenuItemsAtLocation(location);
            if (menuItems.length != 0) {
                menu.addSeparator();
            }
            Arrays.stream(menuItems).forEachOrdered(menu::add);
        }
    }

    public void setRunning(boolean running, String host) {
        log.info("setRunning({}, {})", (Object)running, (Object)host);
        if ("*local*".equals(host)) {
            return;
        }
        Iterator<JMenuItem> iter = this.remoteEngineStart.iterator();
        Iterator<JMenuItem> iter2 = this.remoteEngineStop.iterator();
        Iterator<JMenuItem> iter3 = this.remoteEngineExit.iterator();
        Iterator<JMenuItem> iter4 = this.remoteEngineShut.iterator();
        while (iter.hasNext() && iter2.hasNext() && iter3.hasNext() && iter4.hasNext()) {
            JMenuItem start = iter.next();
            JMenuItem stop = iter2.next();
            JMenuItem exit = iter3.next();
            JMenuItem shut = iter4.next();
            if (start.getText().equals(host)) {
                if (log.isDebugEnabled()) {
                    log.debug("Found start host: {}", (Object)start.getText());
                }
                start.setEnabled(!running);
            }
            if (stop.getText().equals(host)) {
                if (log.isDebugEnabled()) {
                    log.debug("Found stop  host: {}", (Object)stop.getText());
                }
                stop.setEnabled(running);
            }
            if (exit.getText().equals(host)) {
                if (log.isDebugEnabled()) {
                    log.debug("Found exit  host: {}", (Object)exit.getText());
                }
                exit.setEnabled(true);
            }
            if (!shut.getText().equals(host)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found shut  host: {}", (Object)exit.getText());
            }
            shut.setEnabled(running);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.runStart.setEnabled(!enable);
        this.runStartNoTimers.setEnabled(!enable);
        this.runStop.setEnabled(enable);
        this.runShut.setEnabled(enable);
    }

    private void getRemoteItems() {
        if (this.remoteHosts.length > 0) {
            this.remoteStart = JMeterMenuBar.makeMenuRes("remote_start");
            this.remoteStop = JMeterMenuBar.makeMenuRes("remote_stop");
            this.remoteShut = JMeterMenuBar.makeMenuRes("remote_shut");
            this.remoteExit = JMeterMenuBar.makeMenuRes("remote_exit");
            for (int i = 0; i < this.remoteHosts.length; ++i) {
                this.remoteHosts[i] = this.remoteHosts[i].trim();
                JMenuItem item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_start");
                this.remoteEngineStart.add(item);
                this.remoteStart.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_stop");
                item.setEnabled(false);
                this.remoteEngineStop.add(item);
                this.remoteStop.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_shut");
                item.setEnabled(false);
                this.remoteEngineShut.add(item);
                this.remoteShut.add(item);
                item = JMeterMenuBar.makeMenuItemNoRes(this.remoteHosts[i], "remote_exit");
                item.setEnabled(false);
                this.remoteEngineExit.add(item);
                this.remoteExit.add(item);
            }
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.updateMenuElement(this.fileMenu);
        this.updateMenuElement(this.editMenu);
        this.updateMenuElement(this.searchMenu);
        this.updateMenuElement(this.runMenu);
        this.updateMenuElement(this.optionsMenu);
        this.updateMenuElement(this.helpMenu);
        for (MenuCreator creator : this.menuCreators) {
            creator.localeChanged();
        }
    }

    public static UIManager.LookAndFeelInfo[] getAllLAFs() {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        int i = lafs.length;
        UIManager.LookAndFeelInfo[] lafsAll = new UIManager.LookAndFeelInfo[i + 2];
        System.arraycopy(lafs, 0, lafsAll, 0, i);
        lafsAll[i++] = new UIManager.LookAndFeelInfo(CROSS_PLATFORM_LAF, UIManager.getCrossPlatformLookAndFeelClassName());
        lafsAll[i] = new UIManager.LookAndFeelInfo(SYSTEM_LAF, UIManager.getSystemLookAndFeelClassName());
        return lafsAll;
    }

    private void updateMenuElement(MenuElement menu) {
        Component component = menu.getComponent();
        String compName = component.getName();
        if (compName != null) {
            for (MenuCreator menuCreator : this.menuCreators) {
                if (!menuCreator.localeChanged(menu)) continue;
                return;
            }
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                if (JMeterMenuBar.isResource(jMenu.getActionCommand())) {
                    jMenu.setText(JMeterUtils.getResString(compName));
                }
            } else {
                JMenuItem jMenuItem = (JMenuItem)component;
                if (JMeterMenuBar.isResource(jMenuItem.getActionCommand())) {
                    jMenuItem.setText(JMeterUtils.getResString(compName));
                } else if ("change_language".equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setText(JMeterUtils.getLocaleString(compName));
                }
            }
        }
        for (MenuElement subElement : menu.getSubElements()) {
            this.updateMenuElement(subElement);
        }
    }

    private static boolean isResource(String actionCommand) {
        if ("change_language".equals(actionCommand)) {
            return false;
        }
        if ("Add".equals(actionCommand)) {
            return false;
        }
        if ("remote_start".equals(actionCommand)) {
            return false;
        }
        if ("remote_stop".equals(actionCommand)) {
            return false;
        }
        if ("remote_shut".equals(actionCommand)) {
            return false;
        }
        if ("remote_exit".equals(actionCommand)) {
            return false;
        }
        if ("open_recent".equals(actionCommand)) {
            return false;
        }
        return actionCommand == null || !actionCommand.startsWith("laf:");
    }

    private static JMenu makeMenuRes(String resource) {
        JMenu menu = new JMenu(JMeterUtils.getResString(resource));
        menu.setName(resource);
        return menu;
    }

    private static JMenu makeMenuRes(String resource, int mnemonic) {
        JMenu menu = JMeterMenuBar.makeMenuRes(resource);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    private static JMenuItem makeMenuItemNoRes(String label, String actionCommand) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setName(label);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(ActionRouter.getInstance());
        return menuItem;
    }

    private static JMenuItem makeMenuItemRes(String resource, String actionCommand) {
        return JMeterMenuBar.makeMenuItemRes(resource, 0, actionCommand, null);
    }

    private static JMenuItem makeMenuItemRes(String resource, String actionCommand, KeyStroke keyStroke) {
        return JMeterMenuBar.makeMenuItemRes(resource, 0, actionCommand, keyStroke);
    }

    private static JMenuItem makeMenuItemRes(String resource, int mnemonic, String actionCommand) {
        return JMeterMenuBar.makeMenuItemRes(resource, mnemonic, actionCommand, null);
    }

    private static JMenuItem makeMenuItemRes(String resource, int mnemonic, String actionCommand, KeyStroke keyStroke) {
        JMenuItem menuItem = new JMenuItem(JMeterUtils.getResString(resource), mnemonic);
        menuItem.setName(resource);
        menuItem.setActionCommand(actionCommand);
        menuItem.setAccelerator(keyStroke);
        menuItem.addActionListener(ActionRouter.getInstance());
        return menuItem;
    }

    private static JCheckBoxMenuItem makeCheckBoxMenuItemRes(String resource, String actionCommand) {
        return JMeterMenuBar.makeCheckBoxMenuItemRes(resource, actionCommand, null);
    }

    private static JCheckBoxMenuItem makeCheckBoxMenuItemRes(String resource, String actionCommand, KeyStroke keyStroke) {
        JCheckBoxMenuItem cbkMenuItem = new JCheckBoxMenuItem(JMeterUtils.getResString(resource));
        cbkMenuItem.setName(resource);
        cbkMenuItem.setActionCommand(actionCommand);
        cbkMenuItem.setAccelerator(keyStroke);
        cbkMenuItem.addActionListener(ActionRouter.getInstance());
        return cbkMenuItem;
    }

    private static class LangMenuHelper {
        final ActionRouter actionRouter = ActionRouter.getInstance();
        final JMenu languageMenu;

        LangMenuHelper(JMenu _languageMenu) {
            this.languageMenu = _languageMenu;
        }

        void addLang(String locale) {
            String localeString = JMeterUtils.getLocaleString(locale);
            JMenuItem language = new JMenuItem(localeString);
            language.addActionListener(this.actionRouter);
            language.setActionCommand("change_language");
            language.setName(locale);
            this.languageMenu.add(language);
        }
    }
}

