/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.jmeter.gui.GUIFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.NamedTreeNode;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterTreeNode
extends DefaultMutableTreeNode
implements NamedTreeNode {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(JMeterTreeNode.class);
    private static final int TEST_PLAN_LEVEL = 1;
    private transient JMeterTreeModel treeModel;
    private boolean markedBySearch;
    private boolean childrenMarkedBySearch;

    public JMeterTreeNode() {
        this(null, null);
    }

    public JMeterTreeNode(TestElement userObj, JMeterTreeModel treeModel) {
        super(userObj);
        this.treeModel = treeModel;
    }

    public boolean isEnabled() {
        return this.getTestElement().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getTestElement().setEnabled(enabled);
        this.treeModel.nodeChanged(this);
    }

    public List<JMeterTreeNode> getPathToThreadGroup() {
        if (this.treeModel == null) {
            return new ArrayList<JMeterTreeNode>();
        }
        return Arrays.stream(this.treeModel.getPathToRoot(this)).map(node -> (JMeterTreeNode)node).filter(node -> node.getLevel() >= 1).collect(Collectors.toList());
    }

    public void setChildrenNodesHaveMatched(boolean tagged) {
        if (this.childrenMarkedBySearch == tagged) {
            return;
        }
        this.childrenMarkedBySearch = tagged;
        this.treeModel.nodeChanged(this);
    }

    public void setMarkedBySearch(boolean tagged) {
        if (this.markedBySearch == tagged) {
            return;
        }
        this.markedBySearch = tagged;
        List<JMeterTreeNode> nodesToParent = this.getPathToThreadGroup();
        for (JMeterTreeNode jMeterTreeNode : nodesToParent) {
            if (jMeterTreeNode == this) continue;
            jMeterTreeNode.setChildrenNodesHaveMatched(true);
        }
        this.treeModel.nodeChanged(this);
    }

    public boolean isMarkedBySearch() {
        return this.markedBySearch;
    }

    public boolean isChildrenMarkedBySearch() {
        return this.childrenMarkedBySearch;
    }

    public ImageIcon getIcon() {
        return this.getIcon(true);
    }

    public ImageIcon getIcon(boolean enabled) {
        TestElement testElement = this.getTestElement();
        try {
            if (testElement instanceof TestBean) {
                Class<?> testClass = testElement.getClass();
                try {
                    Image img = Introspector.getBeanInfo(testClass).getIcon(1);
                    if (img == null) {
                        Object clazz = Introspector.getBeanInfo(testClass).getBeanDescriptor().getValue("TestElement.gui_class");
                        if (clazz == null) {
                            log.warn("getIcon(): Can't obtain GUI class from {}", testClass);
                            return null;
                        }
                        return GUIFactory.getIcon(Class.forName((String)clazz), enabled);
                    }
                    return new ImageIcon(img);
                }
                catch (IntrospectionException e1) {
                    log.error("Can't obtain icon for class {}", (Object)testElement, (Object)e1);
                    throw new JMeterError((Throwable)e1);
                }
            }
            return GUIFactory.getIcon(Class.forName(testElement.getPropertyAsString("TestElement.gui_class")), enabled);
        }
        catch (ClassNotFoundException e) {
            log.warn("Can't get icon for class {}", (Object)testElement, (Object)e);
            return null;
        }
    }

    public Collection<String> getMenuCategories() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).getMenuCategories();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public JPopupMenu createPopupMenu() {
        try {
            return GuiPackage.getInstance().getGui(this.getTestElement()).createPopupMenu();
        }
        catch (Exception e) {
            log.error("Can't get popup menu for gui", (Throwable)e);
            return null;
        }
    }

    public TestElement getTestElement() {
        return (TestElement)this.getUserObject();
    }

    public String getStaticLabel() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getStaticLabel();
    }

    public String getDocAnchor() {
        return GuiPackage.getInstance().getGui((TestElement)this.getUserObject()).getDocAnchor();
    }

    @Override
    public void setName(String name) {
        ((TestElement)this.getUserObject()).setName(name);
    }

    @Override
    public String getName() {
        return ((TestElement)this.getUserObject()).getName();
    }

    @Override
    public void nameChanged() {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(this);
        }
    }
}

