/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.MenuElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractActionWithNoRunningTest;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restart
extends AbstractActionWithNoRunningTest
implements MenuCreator {
    private static final Logger log = LoggerFactory.getLogger(Restart.class);
    private static final String RESTART = "restart";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        try {
            GuiPackage guiPackage = GuiPackage.getInstance();
            ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
            if (guiPackage.isDirty()) {
                int chosenOption = JOptionPane.showConfirmDialog(guiPackage.getMainFrame(), JMeterUtils.getResString("cancel_exit_to_save"), JMeterUtils.getResString("save?"), 1, 3);
                if (chosenOption == 1) {
                    Restart.restartApplication(null);
                } else if (chosenOption == 0) {
                    ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
                    if (!guiPackage.isDirty()) {
                        Restart.restartApplication(null);
                    }
                }
            } else {
                Restart.restartApplication(null);
            }
        }
        catch (Exception ex) {
            log.error("Error trying to restart: {}", (Object)ex.getMessage(), (Object)ex);
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("restart_error") + ":\n" + ex.getLocalizedMessage(), JMeterUtils.getResString("error_title"), 0);
        }
    }

    public static void restartApplication(Runnable runBeforeRestart) {
        String javaCommand = System.getProperty(SUN_JAVA_COMMAND);
        if (StringUtils.isEmpty((CharSequence)javaCommand)) {
            JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("restart_error") + ":\n This command is only supported on Open JDK or Oracle JDK", JMeterUtils.getResString("error_title"), 0);
            return;
        }
        String java = System.getProperty("java.home") + "/bin/java";
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuilder vmArgsOneLine = new StringBuilder();
        for (String arg : vmArguments) {
            if (arg.contains("-agentlib")) continue;
            vmArgsOneLine.append(arg);
            vmArgsOneLine.append(" ");
        }
        final StringBuilder cmd = new StringBuilder(java + " " + vmArgsOneLine);
        String[] mainCommand = javaCommand.split(" ");
        if (mainCommand[0].endsWith(".jar")) {
            cmd.append("-jar " + new File(mainCommand[0]).getPath());
        } else {
            cmd.append("-cp \"" + System.getProperty("java.class.path") + "\" " + mainCommand[0]);
        }
        for (int i = 1; i < mainCommand.length; ++i) {
            cmd.append(" ");
            cmd.append(mainCommand[i]);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(cmd.toString());
                }
                catch (IOException e) {
                    log.error("Error calling restart command {}", (Object)cmd.toString(), (Object)e);
                }
            }
        });
        if (runBeforeRestart != null) {
            runBeforeRestart.run();
        }
        System.exit(0);
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.FILE) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString(RESTART), 0);
            menuItemIC.setName(RESTART);
            menuItemIC.setActionCommand(RESTART);
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener(ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    @Override
    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    @Override
    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    @Override
    public void localeChanged() {
    }

    static {
        commands.add(RESTART);
    }
}

