/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.thinktime.ThinkTimeCreator;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddThinkTimeBetweenEachStep
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(AddThinkTimeBetweenEachStep.class);
    private static final Set<String> commands = new HashSet<String>();
    private static final String DEFAULT_IMPLEMENTATION = JMeterUtils.getPropDefault("think_time_creator.impl", "org.apache.jmeter.thinktime.DefaultThinkTimeCreator");

    @Override
    public void doAction(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
        if (!(currentNode.getUserObject() instanceof Controller) && !(currentNode.getUserObject() instanceof ThreadGroup)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.addThinkTimeToChildren(guiPackage, currentNode);
        }
        catch (Exception err) {
            Toolkit.getDefaultToolkit().beep();
            log.error("Failed to add think times", (Throwable)err);
            JMeterUtils.reportErrorToUser("Failed to add think times", err);
        }
    }

    private void addThinkTimeToChildren(GuiPackage guiPackage, JMeterTreeNode parentNode) throws IllegalUserActionException {
        guiPackage.updateCurrentNode();
        try {
            for (int index = 0; index != parentNode.getChildCount(); ++index) {
                boolean insertThinkTime;
                JMeterTreeNode childNode = (JMeterTreeNode)parentNode.getChildAt(index);
                Object userObject = childNode.getUserObject();
                boolean bl = insertThinkTime = childNode.isEnabled() && (userObject instanceof Sampler || userObject instanceof Controller);
                if (!insertThinkTime) continue;
                JMeterTreeNode[] nodes = this.createThinkTime(guiPackage, parentNode);
                if (nodes.length != 2) {
                    throw new IllegalArgumentException("Invalid Think Time, expected 2 nodes, got:" + nodes.length);
                }
                this.addNodesToTreeHierachically(guiPackage, parentNode, nodes, ++index);
            }
        }
        catch (Exception ex) {
            throw new IllegalUserActionException("Cannot add think times", ex);
        }
    }

    private void addNodesToTreeHierachically(GuiPackage guiPackage, JMeterTreeNode parentNode, JMeterTreeNode[] childNodes, int index) {
        guiPackage.getTreeModel().insertNodeInto(childNodes[0], parentNode, index);
        guiPackage.getTreeModel().insertNodeInto(childNodes[1], childNodes[0], 0);
    }

    private JMeterTreeNode[] createThinkTime(GuiPackage guiPackage, JMeterTreeNode parentNode) throws Exception {
        Class<?> clazz = Class.forName(DEFAULT_IMPLEMENTATION);
        ThinkTimeCreator thinkTimeCreator = (ThinkTimeCreator)clazz.newInstance();
        return thinkTimeCreator.createThinkTime(guiPackage, parentNode);
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("Add Think Time between each step");
    }
}

