/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements Command {
    private static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    private static final ActionOnFile actionOnFile = ActionOnFile.valueOf(JMeterUtils.getPropDefault("resultcollector.action_if_file_exists", ActionOnFile.ASK.name()));

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
    }

    protected void popupShouldSave(ActionEvent e) {
        log.debug("popupShouldSave");
        if (GuiPackage.getInstance().getTestPlanFile() == null) {
            if (JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("should_save"), JMeterUtils.getResString("warning"), 0, 3) == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
            }
        } else if (GuiPackage.getInstance().shouldSaveBeforeRun()) {
            ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
        }
    }

    protected boolean popupCheckExistingFileListener(HashTree tree) {
        SearchByClass resultListeners = new SearchByClass(ResultCollector.class);
        tree.traverse((HashTreeTraverser)resultListeners);
        for (ResultCollector rc : resultListeners.getSearchResults()) {
            File f = new File(rc.getFilename());
            if (!f.exists()) continue;
            block0 : switch (actionOnFile) {
                case APPEND: {
                    break;
                }
                case DELETE: {
                    if (f.delete()) break;
                    log.error("Could not delete existing file {}", (Object)f.getAbsolutePath());
                    return false;
                }
                default: {
                    Object[] option = new String[]{JMeterUtils.getResString("concat_result"), JMeterUtils.getResString("dont_start"), JMeterUtils.getResString("replace_file")};
                    String question = MessageFormat.format(JMeterUtils.getResString("ask_existing_file"), rc.getFilename());
                    int response = JOptionPane.showOptionDialog(GuiPackage.getInstance().getMainFrame(), question, JMeterUtils.getResString("warning"), 1, 2, null, option, option[0]);
                    switch (response) {
                        case 2: {
                            if (f.delete()) break block0;
                            log.error("Could not delete existing file {}", (Object)f.getAbsolutePath());
                            return false;
                        }
                        case 0: {
                            break block0;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private static enum ActionOnFile {
        APPEND,
        DELETE,
        ASK;

    }
}

