/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRunner {
    private static final String HOST_NOT_FOUND_MESSAGE = "Host not found in list of active engines: {}";
    private static final Logger log = LoggerFactory.getLogger(DistributedRunner.class);
    public static final String RETRIES_NUMBER = "client.tries";
    public static final String RETRIES_DELAY = "client.retries_delay";
    public static final String CONTINUE_ON_FAIL = "client.continue_on_fail";
    private final Properties remoteProps;
    private final boolean continueOnFail;
    private final int retriesDelay;
    private final int retriesNumber;
    private PrintStream stdout = new PrintStream(new SilentOutputStream());
    private PrintStream stderr = new PrintStream(new SilentOutputStream());
    private final Map<String, JMeterEngine> engines = new HashMap<String, JMeterEngine>();

    public DistributedRunner() {
        this(new Properties());
    }

    public DistributedRunner(Properties props) {
        this.remoteProps = props;
        this.retriesNumber = JMeterUtils.getPropDefault(RETRIES_NUMBER, 1);
        this.continueOnFail = JMeterUtils.getPropDefault(CONTINUE_ON_FAIL, false);
        this.retriesDelay = JMeterUtils.getPropDefault(RETRIES_DELAY, 5000);
    }

    public void init(List<String> addresses, HashTree tree) {
        LinkedList<String> addrs = new LinkedList<String>(addresses);
        for (int tryNo = 0; tryNo < this.retriesNumber; ++tryNo) {
            if (tryNo > 0) {
                this.println("Following remote engines will retry configuring: " + addrs + ", pausing before retry for " + this.retriesDelay + "ms");
                try {
                    Thread.sleep(this.retriesDelay);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted while initializing remote engines:" + addrs, e);
                }
            }
            int idx = 0;
            while (idx < addrs.size()) {
                String address = (String)addrs.get(idx);
                this.println("Configuring remote engine: " + address);
                JMeterEngine engine = this.getClientEngine(address.trim(), tree);
                if (engine != null) {
                    this.engines.put(address, engine);
                    addrs.remove(address);
                    continue;
                }
                this.println("Failed to configure " + address);
                ++idx;
            }
            if (addrs.isEmpty()) break;
        }
        if (!addrs.isEmpty()) {
            String msg = "Following remote engines could not be configured:" + addrs;
            if (!this.continueOnFail || this.engines.size() == 0) {
                this.stop();
                throw new RuntimeException(msg);
            }
            this.println(msg);
            this.println("Continuing without failed engines...");
        }
    }

    public void start(List<String> addresses) {
        this.println("Starting remote engines");
        long now = System.currentTimeMillis();
        this.println("Starting the test @ " + new Date(now) + " (" + now + ")");
        for (String address : addresses) {
            try {
                if (this.engines.containsKey(address)) {
                    this.engines.get(address).runTest();
                    continue;
                }
                log.warn(HOST_NOT_FOUND_MESSAGE, (Object)address);
            }
            catch (IllegalStateException | JMeterEngineException e) {
                JMeterUtils.reportErrorToUser(e.getMessage(), JMeterUtils.getResString("remote_error_starting"));
            }
        }
        this.println("Remote engines have been started");
    }

    public void start() {
        LinkedList<String> addresses = new LinkedList<String>();
        addresses.addAll(this.engines.keySet());
        this.start(addresses);
    }

    public void stop(List<String> addresses) {
        this.println("Stopping remote engines");
        for (String address : addresses) {
            try {
                if (this.engines.containsKey(address)) {
                    this.engines.get(address).stopTest(true);
                    continue;
                }
                log.warn(HOST_NOT_FOUND_MESSAGE, (Object)address);
            }
            catch (RuntimeException e) {
                this.errln("Failed to stop test on " + address, e);
            }
        }
        this.println("Remote engines have been stopped");
    }

    public void stop() {
        LinkedList<String> addresses = new LinkedList<String>();
        addresses.addAll(this.engines.keySet());
        this.stop(addresses);
    }

    public void shutdown(List<String> addresses) {
        this.println("Shutting down remote engines");
        for (String address : addresses) {
            try {
                if (this.engines.containsKey(address)) {
                    this.engines.get(address).stopTest(false);
                    continue;
                }
                log.warn(HOST_NOT_FOUND_MESSAGE, (Object)address);
            }
            catch (RuntimeException e) {
                this.errln("Failed to shutdown test on " + address, e);
            }
        }
        this.println("Remote engines have been shut down");
    }

    public void exit(List<String> addresses) {
        this.println("Exiting remote engines");
        for (String address : addresses) {
            try {
                if (this.engines.containsKey(address)) {
                    this.engines.get(address).exit();
                    continue;
                }
                log.warn(HOST_NOT_FOUND_MESSAGE, (Object)address);
            }
            catch (RuntimeException e) {
                this.errln("Failed to exit on " + address, e);
            }
        }
        this.println("Remote engines have been exited");
    }

    private JMeterEngine getClientEngine(String address, HashTree testTree) {
        try {
            JMeterEngine engine = this.createEngine(address);
            engine.configure(testTree);
            if (!this.remoteProps.isEmpty()) {
                engine.setProperties(this.remoteProps);
            }
            return engine;
        }
        catch (Exception ex) {
            log.error("Failed to create engine at {}", (Object)address, (Object)ex);
            JMeterUtils.reportErrorToUser(ex.getMessage(), JMeterUtils.getResString("remote_error_init") + ": " + address);
            return null;
        }
    }

    protected JMeterEngine createEngine(String address) throws RemoteException, NotBoundException {
        return new ClientJMeterEngine(address);
    }

    private void println(String s) {
        log.info(s);
        this.stdout.println(s);
    }

    private void errln(String s, Exception e) {
        log.error(s, (Throwable)e);
        this.stderr.println(s + ": ");
        e.printStackTrace(this.stderr);
    }

    public void setStdout(PrintStream stdout) {
        this.stdout = stdout;
    }

    public void setStdErr(PrintStream stdErr) {
        this.stderr = stdErr;
    }

    public Collection<? extends JMeterEngine> getEngines() {
        return this.engines.values();
    }

    private static class SilentOutputStream
    extends OutputStream {
        private SilentOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

