/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.xml.utils.PrefixResolverDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PropertiesBasedPrefixResolver
extends PrefixResolverDefault {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedPrefixResolver.class);
    private static final String XPATH_NAMESPACE_CONFIG = "xpath.namespace.config";
    private static final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();

    public PropertiesBasedPrefixResolver(Node xpathExpressionContext) {
        super(xpathExpressionContext);
    }

    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        String namespace = NAMESPACE_MAP.get(prefix);
        if (namespace == null) {
            return super.getNamespaceForPrefix(prefix, namespaceContext);
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String pathToNamespaceConfig = JMeterUtils.getPropDefault(XPATH_NAMESPACE_CONFIG, "");
        if (!StringUtils.isEmpty((CharSequence)pathToNamespaceConfig)) {
            BufferedInputStream inputStream;
            block8: {
                Properties properties = new Properties();
                inputStream = null;
                try {
                    File pathToNamespaceConfigFile = JMeterUtils.findFile(pathToNamespaceConfig);
                    if (!pathToNamespaceConfigFile.exists()) {
                        log.error("Cannot find configured file:'{}' in property:'{}', file does not exist", (Object)pathToNamespaceConfig, (Object)XPATH_NAMESPACE_CONFIG);
                        break block8;
                    }
                    if (!pathToNamespaceConfigFile.canRead()) {
                        log.error("Cannot read configured file:'{}' in property:'{}'", (Object)pathToNamespaceConfig, (Object)XPATH_NAMESPACE_CONFIG);
                        break block8;
                    }
                    inputStream = new BufferedInputStream(new FileInputStream(pathToNamespaceConfigFile));
                    properties.load(inputStream);
                    properties.entrySet();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        NAMESPACE_MAP.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    log.info("Read following XPath namespace configuration {}", NAMESPACE_MAP);
                }
                catch (IOException e) {
                    try {
                        log.error("Error loading namespaces from file:'{}', message: {}", new Object[]{pathToNamespaceConfig, e.getMessage(), e});
                    }
                    catch (Throwable throwable) {
                        JOrphanUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    JOrphanUtils.closeQuietly((Closeable)inputStream);
                }
            }
            JOrphanUtils.closeQuietly(inputStream);
        }
    }
}

