/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;

public class ThreadGroupGui
extends AbstractThreadGroupGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private LoopControlPanel loopPanel;
    private static final String THREAD_NAME = "Thread Field";
    private static final String RAMP_NAME = "Ramp Up Field";
    private JTextField threadInput;
    private JTextField rampInput;
    private final boolean showDelayedStart;
    private JCheckBox delayedStart;
    private JCheckBox scheduler;
    private JTextField duration;
    private JTextField delay;

    public ThreadGroupGui() {
        this(true);
    }

    public ThreadGroupGui(boolean showDelayedStart) {
        this.showDelayedStart = showDelayedStart;
        this.init();
        this.initGui();
    }

    @Override
    public TestElement createTestElement() {
        ThreadGroup tg = new ThreadGroup();
        this.modifyTestElement(tg);
        return tg;
    }

    @Override
    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        if (tg instanceof AbstractThreadGroup) {
            ((AbstractThreadGroup)tg).setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
        tg.setProperty("ThreadGroup.num_threads", this.threadInput.getText());
        tg.setProperty("ThreadGroup.ramp_time", this.rampInput.getText());
        if (this.showDelayedStart) {
            tg.setProperty("ThreadGroup.delayedStart", this.delayedStart.isSelected(), false);
        }
        tg.setProperty(new BooleanProperty("ThreadGroup.scheduler", this.scheduler.isSelected()));
        tg.setProperty("ThreadGroup.duration", this.duration.getText());
        tg.setProperty("ThreadGroup.delay", this.delay.getText());
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        this.threadInput.setText(tg.getPropertyAsString("ThreadGroup.num_threads"));
        this.rampInput.setText(tg.getPropertyAsString("ThreadGroup.ramp_time"));
        this.loopPanel.configure((TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue());
        if (this.showDelayedStart) {
            this.delayedStart.setSelected(tg.getPropertyAsBoolean("ThreadGroup.delayedStart"));
        }
        this.scheduler.setSelected(tg.getPropertyAsBoolean("ThreadGroup.scheduler"));
        this.toggleSchedulerFields(this.scheduler.isSelected());
        this.duration.setText(tg.getPropertyAsString("ThreadGroup.duration"));
        this.delay.setText(tg.getPropertyAsString("ThreadGroup.delay"));
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getItem().equals(this.scheduler)) {
            this.toggleSchedulerFields(this.scheduler.isSelected());
        }
    }

    private void toggleSchedulerFields(boolean enable) {
        this.duration.setEnabled(enable);
        this.delay.setEnabled(enable);
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(1);
        this.loopPanel.configure(looper);
        return this.loopPanel;
    }

    private JPanel createDurationPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("duration"));
        panel.add((Component)label, "West");
        this.duration = new JTextField();
        panel.add((Component)this.duration, "Center");
        return panel;
    }

    private JPanel createDelayPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("delay"));
        panel.add((Component)label, "West");
        this.delay = new JTextField();
        panel.add((Component)this.delay, "Center");
        return panel;
    }

    @Override
    public String getLabelResource() {
        return "threadgroup";
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void initGui() {
        this.threadInput.setText("1");
        this.rampInput.setText("1");
        this.loopPanel.clearGui();
        if (this.showDelayedStart) {
            this.delayedStart.setSelected(false);
        }
        this.scheduler.setSelected(false);
        this.delay.setText("");
        this.duration.setText("");
    }

    private void init() {
        VerticalPanel threadPropsPanel = new VerticalPanel();
        threadPropsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("thread_properties")));
        JPanel threadPanel = new JPanel(new BorderLayout(5, 0));
        JLabel threadLabel = new JLabel(JMeterUtils.getResString("number_of_threads"));
        threadPanel.add((Component)threadLabel, "West");
        this.threadInput = new JTextField(5);
        this.threadInput.setName(THREAD_NAME);
        threadLabel.setLabelFor(this.threadInput);
        threadPanel.add((Component)this.threadInput, "Center");
        threadPropsPanel.add(threadPanel);
        JPanel rampPanel = new JPanel(new BorderLayout(5, 0));
        JLabel rampLabel = new JLabel(JMeterUtils.getResString("ramp_up"));
        rampPanel.add((Component)rampLabel, "West");
        this.rampInput = new JTextField(5);
        this.rampInput.setName(RAMP_NAME);
        rampLabel.setLabelFor(this.rampInput);
        rampPanel.add((Component)this.rampInput, "Center");
        threadPropsPanel.add(rampPanel);
        threadPropsPanel.add(this.createControllerPanel());
        if (this.showDelayedStart) {
            this.delayedStart = new JCheckBox(JMeterUtils.getResString("delayed_start"));
            threadPropsPanel.add(this.delayedStart);
        }
        this.scheduler = new JCheckBox(JMeterUtils.getResString("scheduler"));
        this.scheduler.addItemListener(this);
        threadPropsPanel.add(this.scheduler);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("scheduler_configuration")));
        mainPanel.add(this.createDurationPanel());
        mainPanel.add(this.createDelayPanel());
        this.toggleSchedulerFields(false);
        VerticalPanel intgrationPanel = new VerticalPanel();
        intgrationPanel.add(threadPropsPanel);
        intgrationPanel.add(mainPanel);
        this.add((Component)intgrationPanel, "Center");
    }
}

