/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.action.template.Template;
import org.apache.jmeter.gui.action.template.TemplateManager;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledChoice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTemplatesDialog
extends JDialog
implements ChangeListener,
ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private static final int MINIMAL_BOX_WIDTH = 500;
    private static final int MINIMAL_BOX_HEIGHT = 300;
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private static final Logger log = LoggerFactory.getLogger(SelectTemplatesDialog.class);
    private final JLabeledChoice templateList = new JLabeledChoice(JMeterUtils.getResString("template_choose"), false);
    private final HtmlPane helpDoc = new HtmlPane();
    private final JButton reloadTemplateButton = new JButton(JMeterUtils.getResString("template_reload"));
    private final JButton applyTemplateButton = new JButton();
    private final JButton cancelButton = new JButton(JMeterUtils.getResString("cancel"));
    private final JScrollPane scroller = new JScrollPane(this.helpDoc);

    public SelectTemplatesDialog() {
        super((Frame)null, JMeterUtils.getResString("template_title"), true);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTemplatesDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -3661361497864527363L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTemplatesDialog.this.checkDirtyAndLoad(actionEvent);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void checkDirtyAndLoad(ActionEvent actionEvent) throws HeadlessException {
        String selectedTemplate = this.templateList.getText();
        Template template = TemplateManager.getInstance().getTemplateByName(selectedTemplate);
        if (template == null) {
            return;
        }
        boolean isTestPlan = template.isTestPlan();
        if (isTestPlan) {
            ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "check_dirty"));
            GuiPackage guiPackage = GuiPackage.getInstance();
            if (guiPackage.isDirty()) {
                int response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("cancel_new_from_template"), JMeterUtils.getResString("template_load?"), 1, 3);
                if (response == 0) {
                    ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "save"));
                }
                if (response == -1 || response == 2) {
                    return;
                }
            }
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "stop_thread"));
        File parent = template.getParent();
        File fileToCopy = parent != null ? new File(parent, template.getFileName()) : new File(JMeterUtils.getJMeterHome(), template.getFileName());
        Load.loadProjectFile(actionEvent, fileToCopy, !isTestPlan, false);
        this.setVisible(false);
    }

    private void init() {
        this.templateList.setValues(TemplateManager.getInstance().getTemplateNames());
        this.templateList.addChangeListener((ChangeListener)this);
        this.reloadTemplateButton.addActionListener(this);
        this.reloadTemplateButton.setFont(FONT_SMALL);
        this.getContentPane().setLayout(new BorderLayout(10, 0));
        JPanel templateBar = new JPanel(new BorderLayout());
        templateBar.add((Component)this.templateList, "Center");
        JPanel reloadBtnBar = new JPanel();
        reloadBtnBar.add(this.reloadTemplateButton);
        templateBar.add((Component)reloadBtnBar, "East");
        this.getContentPane().add((Component)templateBar, "North");
        this.helpDoc.setContentType("text/html");
        this.helpDoc.setEditable(false);
        this.helpDoc.addHyperlinkListener(this);
        this.getContentPane().add((Component)this.scroller, "Center");
        this.applyTemplateButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel actionBtnBar = new JPanel(new FlowLayout());
        actionBtnBar.add(this.applyTemplateButton);
        actionBtnBar.add(this.cancelButton);
        this.getContentPane().add((Component)actionBtnBar, "South");
        this.pack();
        this.setMinimumSize(new Dimension(500, 300));
        ComponentUtil.centerComponentInWindow((Component)this, (int)50);
        this.populateTemplatePage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.applyTemplateButton) {
            this.checkDirtyAndLoad(e);
        } else if (source == this.reloadTemplateButton) {
            this.templateList.setValues(TemplateManager.getInstance().reset().getTemplateNames());
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.populateTemplatePage();
    }

    private void populateTemplatePage() {
        String selectedTemplate = this.templateList.getText();
        Template template = TemplateManager.getInstance().getTemplateByName(selectedTemplate);
        this.helpDoc.setText(template.getDescription());
        this.applyTemplateButton.setText(template.isTestPlan() ? JMeterUtils.getResString("template_create_from") : JMeterUtils.getResString("template_merge_from"));
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(e.getURL().toURI());
            }
            catch (Exception ex) {
                log.error("Error opening URL in browser: {}", (Object)e.getURL());
            }
        }
    }
}

