/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.format.ZonedDateTimeFormatter;
import org.exparity.hamcrest.date.core.wrapper.ZonedDateTimeWrapper;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class ZonedDateTimeMatchers {
    public static Matcher<ZonedDateTime> after(ZonedDateTime date) {
        return new IsAfter<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsAfter<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> before(ZonedDateTime date) {
        return new IsBefore<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsBefore<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> sameDay(ZonedDateTime date) {
        return new IsSameDay<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> isDay(int year, Month month, int dayOfMonth, ZoneId tz) {
        return new IsSameDay<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> sameInstant(ZonedDateTime date) {
        return new IsSame<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSame<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> sameOrBefore(ZonedDateTime date) {
        return new IsSameOrBefore<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    @Factory
    public static Matcher<ZonedDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSameOrBefore<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, day, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> sameOrAfter(ZonedDateTime date) {
        return new IsSameOrAfter<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    @Factory
    public static Matcher<ZonedDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSameOrAfter<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, day, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> sameMonthOfYear(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isMonth(date.getMonth());
    }

    public static Matcher<ZonedDateTime> sameDayOfMonth(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isDayOfMonth(date.getDayOfMonth());
    }

    public static Matcher<ZonedDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<ZonedDateTime>(dayOfMonth, t -> t);
    }

    public static Matcher<ZonedDateTime> sameYear(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isYear(date.getYear());
    }

    public static Matcher<ZonedDateTime> isYear(int year) {
        return new IsYear<ZonedDateTime>(year, t -> t);
    }

    public static Matcher<ZonedDateTime> within(long period, ChronoUnit unit, ZonedDateTime date) {
        return new IsWithin<ZonedDateTime>(period, unit, new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsWithin<ZonedDateTime>(period, unit, new ZonedDateTimeWrapper(year, month, dayofMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> isYesterday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(-1L));
    }

    public static Matcher<ZonedDateTime> isToday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now());
    }

    public static Matcher<ZonedDateTime> isTomorrow() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(1L));
    }

    public static Matcher<ZonedDateTime> sameDayOfWeek(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static Matcher<ZonedDateTime> isDayOfWeek(DayOfWeek ... dayOfWeek) {
        return new IsDayOfWeek<ZonedDateTime>(Arrays.asList(dayOfWeek), t -> t);
    }

    public static Matcher<ZonedDateTime> isMonday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static Matcher<ZonedDateTime> isTuesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static Matcher<ZonedDateTime> isWednesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static Matcher<ZonedDateTime> isThursday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static Matcher<ZonedDateTime> isFriday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static Matcher<ZonedDateTime> isSaturday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static Matcher<ZonedDateTime> isSunday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static Matcher<ZonedDateTime> isWeekday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static Matcher<ZonedDateTime> isWeekend() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static Matcher<ZonedDateTime> isFirstDayOfMonth() {
        return new IsMinimum<ZonedDateTime>(ChronoField.DAY_OF_MONTH, t -> t, new DatePartFormatter(), () -> "the date is the first day of the month");
    }

    public static Matcher<ZonedDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<ZonedDateTime>(field, t -> t, new DatePartFormatter());
    }

    public static Matcher<ZonedDateTime> isLastDayOfMonth() {
        return new IsMaximum<ZonedDateTime>(ChronoField.DAY_OF_MONTH, t -> t, new DatePartFormatter(), () -> "the date is the last day of the month");
    }

    public static Matcher<ZonedDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<ZonedDateTime>(field, t -> t, new DatePartFormatter());
    }

    public static Matcher<ZonedDateTime> isMonth(Month month) {
        return new IsMonth<ZonedDateTime>(month, t -> t);
    }

    public static Matcher<ZonedDateTime> isJanuary() {
        return ZonedDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static Matcher<ZonedDateTime> isFebruary() {
        return ZonedDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static Matcher<ZonedDateTime> isMarch() {
        return ZonedDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static Matcher<ZonedDateTime> isApril() {
        return ZonedDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static Matcher<ZonedDateTime> isMay() {
        return ZonedDateTimeMatchers.isMonth(Month.MAY);
    }

    public static Matcher<ZonedDateTime> isJune() {
        return ZonedDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static Matcher<ZonedDateTime> isJuly() {
        return ZonedDateTimeMatchers.isMonth(Month.JULY);
    }

    public static Matcher<ZonedDateTime> isAugust() {
        return ZonedDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static Matcher<ZonedDateTime> isSeptember() {
        return ZonedDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static Matcher<ZonedDateTime> isOctober() {
        return ZonedDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static Matcher<ZonedDateTime> isNovember() {
        return ZonedDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static Matcher<ZonedDateTime> isDecember() {
        return ZonedDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static Matcher<ZonedDateTime> isLeapYear() {
        return new IsLeapYear<ZonedDateTime>(t -> t, new ZonedDateTimeFormatter());
    }

    public static Matcher<ZonedDateTime> isHour(int hour) {
        return new IsHour<ZonedDateTime>(hour, t -> t);
    }

    public static Matcher<ZonedDateTime> sameHourOfDay(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isHour(date.getHour());
    }

    public static Matcher<ZonedDateTime> isMinute(int minute) {
        return new IsMinute<ZonedDateTime>(minute, t -> t);
    }

    public static Matcher<ZonedDateTime> sameMinuteOfHour(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isMinute(date.getMinute());
    }

    public static Matcher<ZonedDateTime> isSecond(int Second) {
        return new IsSecond<ZonedDateTime>(Second, t -> t);
    }

    public static Matcher<ZonedDateTime> sameSecondOfMinute(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isSecond(date.getSecond());
    }
}

