/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.atlas.io;

import org.apache.jena.atlas.lib.Closeable ;


/** Simple abstraction of a string/character output stream */

public interface AWriter extends Closeable, AutoCloseable
{
    public AWriter write(char ch) ;
    public AWriter write(char[] cbuf) ;
    public AWriter write(String string) ;

    public AWriter print(char ch) ;
    public AWriter print(char[] cbuf) ;
    public AWriter print(String string) ;
    public AWriter printf(String fmt, Object ...arg) ;
    public AWriter println(String object) ;
    public AWriter println() ;

    public AWriter flush() ;
    @Override
    public void close() ;
}

