/* TurtleParser.java */
/* Generated By:JavaCC: Do not edit this line. TurtleParser.java */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.ttl.turtle.parser;

import org.apache.jena.ttl.turtle.*;
import org.apache.jena.graph.* ;

public class TurtleParser extends TurtleParserBase implements TurtleParserConstants {

// --- Entry point
  final public 
void parse() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PREFIX:
      case BASE:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR:
      case LPAREN:
      case NIL:
      case LBRACE:
      case LBRACKET:
      case ANON:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      Statement();
    }
    jj_consume_token(0);
}

  final public void Statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:
    case BASE:{
      Directive();
      break;
      }
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR:
    case LPAREN:
    case NIL:
    case LBRACE:
    case LBRACKET:
    case ANON:{
      TriplesSameSubject();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(DOT);
}

  final public void Directive() throws ParseException {Token t ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      jj_consume_token(PREFIX);
      t = jj_consume_token(PNAME_NS);
      iri = IRI_REF();
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
      setPrefix(t.beginLine, t.beginColumn, s, iri) ;
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      iri = IRI_REF();
setBase(iri, t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// ---- TRIPLES
  final public 
void TriplesSameSubject() throws ParseException {Node s ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR:
    case NIL:
    case LBRACE:
    case ANON:{
      s = VarOrTerm();
      PropertyListNotEmpty(s);
      break;
      }
    case LPAREN:
    case LBRACKET:{
      // Any of the triple generating syntax elements
        s = TriplesNode();
      PropertyList(s);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void PropertyList(Node s) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KW_A:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case EQ:
    case ARROW:{
      PropertyListNotEmpty(s);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
}

// Non-recursive for Turtle long PropertyList tests
  final public void PropertyListNotEmpty(Node s) throws ParseException {Node p ;
    p = Verb();
    ObjectList(s, p);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_2;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KW_A:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case EQ:
      case ARROW:{
        p = Verb();
        ObjectList(s, p);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        ;
      }
    }
}

// Non-recursive for Turtle long PropertyList tests
  final public void ObjectList(Node s, Node p) throws ParseException {Node o ;
    Object(s, p);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      Object(s, p);
    }
}

  final public void Object(Node s, Node p) throws ParseException {Node o ;
    o = GraphNode();
Triple t = Triple.create(s,p,o) ;
    emitTriple(token.beginLine, token.beginColumn, t) ;
}

  final public Node Verb() throws ParseException {Node p ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = IRIref();
p = createNode(iri) ;
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
p = nRDFtype ;
      break;
      }
    case EQ:{
      jj_consume_token(EQ);
p = nOwlSameAs ;
        if ( strictTurtle )
          throwParseException("= (owl:sameAs) not legal in Turtle",
                          token.beginLine, token.beginColumn ) ;
      break;
      }
    case ARROW:{
      jj_consume_token(ARROW);
p = nLogImplies ;
        if ( strictTurtle )
          throwParseException("=> (log:implies) not legal in Turtle",
                          token.beginLine, token.beginColumn ) ;
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
}

// -------- Triple expansions

// Anything that can stand in a node slot and which is
// a number of triples
  final public 
Node TriplesNode() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      n = Collection();
{if ("" != null) return n ;}
      break;
      }
    case LBRACKET:{
      n = BlankNodePropertyList();
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Node BlankNodePropertyList() throws ParseException {
    jj_consume_token(LBRACKET);
Node n = createBNode() ;
    PropertyListNotEmpty(n);
    jj_consume_token(RBRACKET);
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
}

// ------- RDF collections

// Code not as SPARQL/ARQ because of output ordering.
  final public Node Collection() throws ParseException {Node listHead = nRDFnil ; Node lastCell = null ; Node n ;
    jj_consume_token(LPAREN);
    label_4:
    while (true) {
Node cell = createBNode() ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        emitTriple(token.beginLine, token.beginColumn,
                   Triple.create(lastCell, nRDFrest,  cell)) ;
      n = GraphNode();
emitTriple(token.beginLine, token.beginColumn,
                 Triple.create(cell, nRDFfirst,  n)) ;
      lastCell = cell ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR:
      case LPAREN:
      case NIL:
      case LBRACE:
      case LBRACKET:
      case ANON:{
        ;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_4;
      }
    }
    jj_consume_token(RPAREN);
if ( lastCell != null )
       emitTriple(token.beginLine, token.beginColumn,
                  Triple.create(lastCell, nRDFrest,  nRDFnil)) ;
     {if ("" != null) return listHead ;}
    throw new Error("Missing return statement in function");
}

// -------- Nodes in a graph pattern or template
  final public 
Node GraphNode() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR:
    case NIL:
    case LBRACE:
    case ANON:{
      n = VarOrTerm();
{if ("" != null) return n ;}
      break;
      }
    case LPAREN:
    case LBRACKET:{
      n = TriplesNode();
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Node VarOrTerm() throws ParseException {Node n = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR:{
      n = Var();
      break;
      }
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case NIL:
    case ANON:{
      n = GraphTerm();
      break;
      }
    case LBRACE:{
      n = Formula();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
}

  final public Node Formula() throws ParseException {Token t ;
    t = jj_consume_token(LBRACE);
startFormula(t.beginLine, t.beginColumn) ;
    TriplesSameSubject();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR:
      case LPAREN:
      case NIL:
      case LBRACE:
      case LBRACKET:
      case ANON:{
        TriplesSameSubject();
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    }
    t = jj_consume_token(RBRACE);
endFormula(t.beginLine, t.beginColumn) ;
{if ("" != null) return null ;}
    throw new Error("Missing return statement in function");
}

  final public Node Var() throws ParseException {Token t ;
    t = jj_consume_token(VAR);
{if ("" != null) return createVariable(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
}

  final public Node GraphTerm() throws ParseException {Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = IRIref();
{if ("" != null) return createNode(iri) ;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      n = RDFLiteral();
{if ("" != null) return n ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      // Cleaner sign handling in Turtle.
        n = NumericLiteral();
{if ("" != null) return n ;}
      break;
      }
    case TRUE:
    case FALSE:{
      n = BooleanLiteral();
{if ("" != null) return n ;}
      break;
      }
    case BLANK_NODE_LABEL:
    case ANON:{
      n = BlankNode();
{if ("" != null) return n ;}
      break;
      }
    case NIL:{
      jj_consume_token(NIL);
{if ("" != null) return nRDFnil ;}
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// ---- Basic terms
  final public 
Node NumericLiteral() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:{
      t = jj_consume_token(INTEGER);
{if ("" != null) return createLiteralInteger(t.image) ;}
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
{if ("" != null) return createLiteralDecimal(t.image) ;}
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
{if ("" != null) return createLiteralDouble(t.image) ;}
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Node RDFLiteral() throws ParseException {Token t ; String lex = null ;
    lex = String();
String lang = null ; String dt = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:
    case BASE:
    case LANGTAG:
    case DATATYPE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PREFIX:
      case BASE:
      case LANGTAG:{
        lang = Langtag();
        break;
        }
      case DATATYPE:{
        jj_consume_token(DATATYPE);
        dt = IRIref();
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
{if ("" != null) return createLiteral(lex, lang, dt) ;}
    throw new Error("Missing return statement in function");
}

  final public String Langtag() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGTAG:{
      t = jj_consume_token(LANGTAG);
      break;
      }
    case PREFIX:
    case BASE:{
      t = AnyDirective();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String lang = stripChars(t.image, 1) ; {if ("" != null) return lang ;}
    throw new Error("Missing return statement in function");
}

  final public Token AnyDirective() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      t = jj_consume_token(PREFIX);
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t ;}
    throw new Error("Missing return statement in function");
}

  final public Node BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return XSD_TRUE ;}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return XSD_FALSE ;}
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String String() throws ParseException {Token t ;  String lex ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG1:{
      t = jj_consume_token(STRING_LITERAL_LONG1);
lex = stripQuotes3(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG2:{
      t = jj_consume_token(STRING_LITERAL_LONG2);
lex = stripQuotes3(t.image) ;
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
lex = unescapeStr(lex,  t.beginLine, t.beginColumn) ;
      {if ("" != null) return lex ;}
    throw new Error("Missing return statement in function");
}

  final public String IRIref() throws ParseException {String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:{
      iri = IRI_REF();
{if ("" != null) return iri ;}
      break;
      }
    case PNAME_NS:
    case PNAME_LN:{
      iri = PrefixedName();
{if ("" != null) return iri ;}
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String PrefixedName() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PNAME_LN:{
      t = jj_consume_token(PNAME_LN);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case PNAME_NS:{
      t = jj_consume_token(PNAME_NS);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Node BlankNode() throws ParseException {Token t = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLANK_NODE_LABEL:{
      t = jj_consume_token(BLANK_NODE_LABEL);
{if ("" != null) return createBNode(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case ANON:{
      jj_consume_token(ANON);
{if ("" != null) return createBNode() ;}
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String IRI_REF() throws ParseException {Token t ;
    t = jj_consume_token(IRIref);
{if ("" != null) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
}

  /** Generated Token Manager. */
  public TurtleParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[27];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0xde1fc000,0xde1fc000,0xc000,0xde1f0000,0xc0002000,0x0,0xc0002000,0x0,0xc0002000,0x0,0xde1f0000,0xde1f0000,0xde1f0000,0x0,0xde1f0000,0xde1f0000,0x1c0000,0xc000,0xc000,0xc000,0xc000,0x30000,0x1e000000,0xc0000000,0x80000000,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x4000000,0x2b47,0x2b47,0x0,0x2b47,0x60001,0x4000,0x60001,0x8000,0x60001,0x840,0x2b47,0x2b47,0x2307,0x10000,0x2b47,0x2103,0x0,0x8000008,0x8000008,0x8,0x0,0x0,0x0,0x1,0x1,0x2002,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}

  /** Constructor with InputStream. */
  public TurtleParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TurtleParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new TurtleParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public TurtleParser(java.io.Reader stream) {
	 jj_input_stream = new JavaCharStream(stream, 1, 1);
	 token_source = new TurtleParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new JavaCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new TurtleParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public TurtleParser(TurtleParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(TurtleParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 27; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[68];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 27; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 68; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
