/* ShExJavacc.java */
/* Generated By:JavaCC: Do not edit this line. ShExJavacc.java */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.shex.parser.javacc;

import static org.apache.jena.shex.sys.SysShex.*;
import org.apache.jena.shex.parser.*;
import org.apache.jena.shex.expressions.*;
import org.apache.jena.graph.*;
import static org.apache.jena.riot.lang.extra.LangParserLib.*;
import java.util.*;

public class ShExJavacc extends ParserShExC implements ShExJavaccConstants {

  final public void UnitShapes() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    shexDoc();
    jj_consume_token(0);
  }

  final public void shexDoc() throws ParseException {
startShexDoc();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:
      case IMPORT:
      case PREFIX:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      directive();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case START:
    case CODE_BLOCK:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case START:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{
        notStartAction();
        break;
        }
      case CODE_BLOCK:{
        startActions();
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BASE:
        case IMPORT:
        case PREFIX:
        case START:
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case BLANK_NODE_LABEL:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        statement();
      }
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
finishShexDoc();
  }

// ----
  final public 
void directive() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:{
      baseDecl();
      break;
      }
    case PREFIX:{
      prefixDecl();
      break;
      }
    case IMPORT:{
      importDecl();
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void baseDecl() throws ParseException {String iri ;
    jj_consume_token(BASE);
    iri = IRIREF();
setBase(iri, token.beginLine, token.beginColumn) ;
  }

  final public void prefixDecl() throws ParseException {Token t ; String iri ;
    jj_consume_token(PREFIX);
    t = jj_consume_token(PNAME_NS);
    iri = IRIREF();
setPrefix(t.image, iri, t.beginLine, t.beginColumn) ;
  }

  final public void importDecl() throws ParseException {Token t ; String iri ;
    t = jj_consume_token(IMPORT);
    iri = iri();
imports(iri, token.beginLine, token.beginColumn) ;
  }

// ----
  final public 
void notStartAction() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case START:{
      start();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      shapeExprDecl();
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void start() throws ParseException {
startStartClause();
    jj_consume_token(START);
    jj_consume_token(EQUALS);
    inlineShapeExpression();
finishStartClause();
  }

  final public void startActions() throws ParseException {
    label_3:
    while (true) {
      codeDecl();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CODE_BLOCK:{
        ;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
    }
  }

  final public void statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:
    case IMPORT:
    case PREFIX:{
      directive();
      break;
      }
    case START:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      notStartAction();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// ----
  final public 
void shapeExprDecl() throws ParseException {Node n;
startShapeExprDecl();
    n = shapeExprLabel();
shapeExprDecl(n, token.beginLine, token.beginColumn);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LITERAL:
    case IRI:
    case BNODE:
    case NONLITERAL:
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:
    case TOTALDIGITS:
    case FRACTIONDIGITS:
    case CLOSED:
    case EXTRA:
    case AT:
    case DOT:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case ATPNAME_NS:
    case ATPNAME_LN:
    case REGEXP:{
      shapeExpression();
      break;
      }
    case EXTERNAL:{
      jj_consume_token(EXTERNAL);
shapeExternal();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishShapeExprDecl();
  }

// From: shapeExprDecl
// Recursion: () in shapeAtom, at shapeRef, and inlineShapeAtom()
  final public void shapeExpression() throws ParseException {int idx;
idx = startShapeExpression();
    shapeOr();
finishShapeExpression(idx);
  }

  final public void shapeOr() throws ParseException {int idx;
idx = startShapeOr();
    shapeAnd();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      jj_consume_token(OR);
      shapeAnd();
    }
finishShapeOr(idx);
  }

  final public void shapeAnd() throws ParseException {int idx;
idx = startShapeAnd();
    shapeNot();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_5;
      }
      jj_consume_token(AND);
      shapeNot();
    }
finishShapeAnd(idx);
  }

  final public void shapeNot() throws ParseException {int idx; boolean negate = false;
idx = startShapeNot();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
negate = true;
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    shapeAtom();
finishShapeNot(idx,negate);
  }

  final public void shapeAtom() throws ParseException {int idx;
idx = startShapeAtom();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRI:
    case BNODE:
    case NONLITERAL:
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:
    case REGEXP:{
      nonLitNodeConstraint();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLOSED:
      case EXTRA:
      case AT:
      case LBRACE:
      case ATPNAME_NS:
      case ATPNAME_LN:{
        shapeOrRef();
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      break;
      }
    case LITERAL:
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:
    case TOTALDIGITS:
    case FRACTIONDIGITS:
    case LBRACKET:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      litNodeConstraint();
      break;
      }
    case CLOSED:
    case EXTRA:
    case AT:
    case LBRACE:
    case ATPNAME_NS:
    case ATPNAME_LN:{
      shapeOrRef();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRI:
      case BNODE:
      case NONLITERAL:
      case LENGTH:
      case MINLENGTH:
      case MAXLENGTH:
      case REGEXP:{
        nonLitNodeConstraint();
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      shapeExpression();
      jj_consume_token(RPAREN);
      break;
      }
    case DOT:{
      jj_consume_token(DOT);
shapeAtomDOT();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishShapeAtom(idx);
  }

// void shapeAtomNoRef() : {}
// {
//     nonLitNodeConstraint() (shapeOrRef())?
//   | litNodeConstraint()
//   | shapeDefinition() (nonLitNodeConstraint())?
//   | <LPAREN> shapeExpression() <RPAREN>
//   | <DOT>
// }

// Inline versions of same.

// From start()
// Recursion: in tripleConstraint
  final public void inlineShapeExpression() throws ParseException {int idx;
idx = startInlineShapeExpression();
    inlineShapeOr();
finishInlineShapeExpression(idx);
  }

  final public void inlineShapeOr() throws ParseException {int idx;
idx = startInlineShapeOr();
    inlineShapeAnd();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
      jj_consume_token(OR);
      inlineShapeAnd();
    }
finishInlineShapeOr(idx);
  }

  final public void inlineShapeAnd() throws ParseException {int idx;
idx = startInlineShapeAnd();
    inlineShapeNot();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_7;
      }
      jj_consume_token(AND);
      inlineShapeNot();
    }
finishInlineShapeAnd(idx);
  }

  final public void inlineShapeNot() throws ParseException {int idx; boolean negate = false;
idx = startInlineShapeNot();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
negate = true;
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    inlineShapeAtom();
finishInlineShapeNot(idx, negate);
  }

  final public void inlineShapeAtom() throws ParseException {int idx;
idx = startInlineShapeAtom();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRI:
    case BNODE:
    case NONLITERAL:
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:
    case REGEXP:{
      nonLitNodeConstraint();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLOSED:
      case EXTRA:
      case AT:
      case LBRACE:
      case ATPNAME_NS:
      case ATPNAME_LN:{
        inlineShapeOrRef();
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      break;
      }
    case LITERAL:
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:
    case TOTALDIGITS:
    case FRACTIONDIGITS:
    case LBRACKET:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      litNodeConstraint();
      break;
      }
    case CLOSED:
    case EXTRA:
    case AT:
    case LBRACE:
    case ATPNAME_NS:
    case ATPNAME_LN:{
      inlineShapeOrRef();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRI:
      case BNODE:
      case NONLITERAL:
      case LENGTH:
      case MINLENGTH:
      case MAXLENGTH:
      case REGEXP:{
        nonLitNodeConstraint();
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      shapeExpression();
      jj_consume_token(RPAREN);
      break;
      }
    case DOT:{
      jj_consume_token(DOT);
shapeAtomDOT();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishInlineShapeAtom(idx);
  }

  final public void shapeOrRef() throws ParseException {int idx;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLOSED:
    case EXTRA:
    case LBRACE:{
      shapeDefinition();
      break;
      }
    case AT:
    case ATPNAME_NS:
    case ATPNAME_LN:{
      shapeRef();
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void inlineShapeOrRef() throws ParseException {int idx;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLOSED:
    case EXTRA:
    case LBRACE:{
      inlineShapeDefinition();
      break;
      }
    case AT:
    case ATPNAME_NS:
    case ATPNAME_LN:{
      shapeRef();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void shapeRef() throws ParseException {Token t ; Node ref;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATPNAME_LN:{
      t = jj_consume_token(ATPNAME_LN);
ref = resolve_AT_PName(t.image, t.beginLine, t.beginColumn) ;
      break;
      }
    case ATPNAME_NS:{
      t = jj_consume_token(ATPNAME_NS);
ref = resolve_AT_PName(t.image, t.beginLine, t.beginColumn) ;
      break;
      }
    case AT:{
      jj_consume_token(AT);
      ref = shapeExprLabel();
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
shapeReference(ref);
  }

  final public void litNodeConstraint() throws ParseException {String str; Token t; int idx;
idx = startLiteralNodeConstraint(token.beginLine, token.beginColumn);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LITERAL:{
      t = jj_consume_token(LITERAL);
cNodeKind(t.image, t.beginLine, t.beginColumn);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LENGTH:
        case MINLENGTH:
        case MAXLENGTH:
        case MININCLUSIVE:
        case MINEXCLUSIVE:
        case MAXINCLUSIVE:
        case MAXEXCLUSIVE:
        case TOTALDIGITS:
        case FRACTIONDIGITS:
        case REGEXP:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_8;
        }
        xsFacet();
      }
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      str = datatype();
cDatatype(str, token.beginLine, token.beginColumn);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LENGTH:
        case MINLENGTH:
        case MAXLENGTH:
        case MININCLUSIVE:
        case MINEXCLUSIVE:
        case MAXINCLUSIVE:
        case MAXEXCLUSIVE:
        case TOTALDIGITS:
        case FRACTIONDIGITS:
        case REGEXP:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_9;
        }
        xsFacet();
      }
      break;
      }
    case LBRACKET:{
      valueSet();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LENGTH:
        case MINLENGTH:
        case MAXLENGTH:
        case MININCLUSIVE:
        case MINEXCLUSIVE:
        case MAXINCLUSIVE:
        case MAXEXCLUSIVE:
        case TOTALDIGITS:
        case FRACTIONDIGITS:
        case REGEXP:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_10;
        }
        xsFacet();
      }
      break;
      }
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:
    case TOTALDIGITS:
    case FRACTIONDIGITS:{
      label_11:
      while (true) {
        numericFacet();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MININCLUSIVE:
        case MINEXCLUSIVE:
        case MAXINCLUSIVE:
        case MAXEXCLUSIVE:
        case TOTALDIGITS:
        case FRACTIONDIGITS:{
          ;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          break label_11;
        }
      }
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishLiteralNodeConstraint(idx, token.beginLine, token.beginColumn);
  }

// Check precedence
  final public 
void nonLitNodeConstraint() throws ParseException {int idx;
idx = startNonLiteralNodeConstraint(token.beginLine, token.beginColumn);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRI:
    case BNODE:
    case NONLITERAL:{
      nonLiteralKind();
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LENGTH:
        case MINLENGTH:
        case MAXLENGTH:
        case REGEXP:{
          ;
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          break label_12;
        }
        stringFacet();
      }
      break;
      }
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:
    case REGEXP:{
      label_13:
      while (true) {
        stringFacet();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LENGTH:
        case MINLENGTH:
        case MAXLENGTH:
        case REGEXP:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_13;
        }
      }
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishNonLiteralNodeConstraint(idx, token.beginLine, token.beginColumn);
  }

  final public void nonLiteralKind() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRI:{
      t = jj_consume_token(IRI);
      break;
      }
    case BNODE:{
      t = jj_consume_token(BNODE);
      break;
      }
    case NONLITERAL:{
      t = jj_consume_token(NONLITERAL);
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
cNodeKind(t.image, t.beginLine, t.beginColumn);
  }

  final public void xsFacet() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:
    case REGEXP:{
      stringFacet();
      break;
      }
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:
    case TOTALDIGITS:
    case FRACTIONDIGITS:{
      numericFacet();
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void stringFacet() throws ParseException {String str; Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LENGTH:
    case MINLENGTH:
    case MAXLENGTH:{
      str = stringLength();
      t = jj_consume_token(INTEGER);
int len = integer(t.image, t.beginLine, t.beginColumn);
      stringFacetLength(str, len);
      break;
      }
    case REGEXP:{
      t = jj_consume_token(REGEXP);
stringFacetRegex(t.image, t.beginLine, t.beginColumn);
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String stringLength() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LENGTH:{
      jj_consume_token(LENGTH);
      break;
      }
    case MINLENGTH:{
      jj_consume_token(MINLENGTH);
      break;
      }
    case MAXLENGTH:{
      jj_consume_token(MAXLENGTH);
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public void numericFacet() throws ParseException {String range; Token t; Node numLit; String lenStr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MININCLUSIVE:
    case MINEXCLUSIVE:
    case MAXINCLUSIVE:
    case MAXEXCLUSIVE:{
      range = numericRange();
      numLit = numericLiteral();
numericFacetRange(range, numLit, token.beginLine, token.beginColumn);
      break;
      }
    case TOTALDIGITS:
    case FRACTIONDIGITS:{
      lenStr = numericLength();
      t = jj_consume_token(INTEGER);
int num = integer(t.image, t.beginLine, t.beginColumn);
       numericFacetLength(lenStr, num, token.beginLine, token.beginColumn);
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String numericRange() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MININCLUSIVE:{
      t = jj_consume_token(MININCLUSIVE);
      break;
      }
    case MINEXCLUSIVE:{
      t = jj_consume_token(MINEXCLUSIVE);
      break;
      }
    case MAXINCLUSIVE:{
      t = jj_consume_token(MAXINCLUSIVE);
      break;
      }
    case MAXEXCLUSIVE:{
      t = jj_consume_token(MAXEXCLUSIVE);
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String numericLength() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TOTALDIGITS:{
      t = jj_consume_token(TOTALDIGITS);
      break;
      }
    case FRACTIONDIGITS:{
      t = jj_consume_token(FRACTIONDIGITS);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t.image;}
    throw new Error("Missing return statement in function");
  }

// "{ ... }"
  final public void shapeDefinition() throws ParseException {boolean closed = false ;
  TripleExpression tripleExpr = null;
  List<Node> extras = new ArrayList<Node>();
startShapeDefinition();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLOSED:
      case EXTRA:{
        ;
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTRA:{
        extraPropertySet(extras);
        break;
        }
      case CLOSED:{
        jj_consume_token(CLOSED);
closed = true;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RDF_TYPE:
    case CARAT:
    case LPAREN:
    case DOLLAR:
    case AMP:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      tripleExpr = tripleExpression();
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_15;
      }
      annotation();
    }
    semanticActions();
finishShapeDefinition(tripleExpr, extras, closed);
  }

  final public void inlineShapeDefinition() throws ParseException {boolean closed = false ;
  TripleExpression tripleExpr = null;
  List<Node> extras = new ArrayList<Node>();
startShapeDefinition();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLOSED:
      case EXTRA:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTRA:{
        extraPropertySet(extras);
        break;
        }
      case CLOSED:{
        jj_consume_token(CLOSED);
closed = true;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RDF_TYPE:
    case CARAT:
    case LPAREN:
    case DOLLAR:
    case AMP:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      tripleExpr = tripleExpression();
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
finishShapeDefinition(tripleExpr, extras, closed);
  }

  final public void extraPropertySet(List<Node> extras) throws ParseException {Node p;
    jj_consume_token(EXTRA);
    label_17:
    while (true) {
      p = predicate();
extras.add(p);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RDF_TYPE:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        ;
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_17;
      }
    }
  }

// Original:
// void tripleExpression() : {}
// {
//     oneOfTripleExpr()
// }
// 
// void oneOfTripleExpr() : {}
// {
//  	(LOOKAHEAD(2)
//       groupTripleExpr()
//     | multiElementOneOf()
//     )
// }
// 
// void multiElementOneOf() : {}
// {
//    	groupTripleExpr() (<VBAR> groupTripleExpr())+
// }
// 
// void groupTripleExpr() : {}
// {
//     ( LOOKAHEAD(2)
//    	  singleElementGroup()
//     | multiElementGroup()
//     )
// }
// 
// void singleElementGroup() : {}
// {
//   	unaryTripleExpr() (<SEMI_COLON>)?
// }
// 
// void multiElementGroup() : {}
// {
//   	unaryTripleExpr()
//      (LOOKAHEAD(2) <SEMI_COLON> unaryTripleExpr())+
//      (<SEMI_COLON>)?
// }

// ---- Improvement for LL(1)
  final public TripleExpression tripleExpression() throws ParseException {int idx;
idx = startTripleExpression();
    tripleExpressionClause();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_18;
      }
      jj_consume_token(VBAR);
      tripleExpressionClause();
    }
{if ("" != null) return finishTripleExpression(idx);}
    throw new Error("Missing return statement in function");
  }

  final public void tripleExpressionClause() throws ParseException {int idx;
idx = startTripleExpressionClause();
    tripleExpressionClause_1();
finishTripleExpressionClause(idx);
  }

// // Can end in single ";"
// void tripleExpressionClause_0() : {}
// {
//     unaryTripleExpr()
// // Allows ";;;"
//     (<SEMI_COLON> ( unaryTripleExpr() )?)*
// }

// Iterative, but needs LOOKAHEAD(2)
  final public void tripleExpressionClause_1() throws ParseException {
    unaryTripleExpr();
    label_19:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_19;
      }
      jj_consume_token(SEMI_COLON);
      unaryTripleExpr();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMI_COLON:{
      jj_consume_token(SEMI_COLON);
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
  }

// // Recursive
// void tripleExpressionClause_2() : { }
// {
//     unaryTripleExpr() (<SEMI_COLON> (tripleExpressionClause() )? )?
// }

// ----
  final public 
void unaryTripleExpr() throws ParseException {Node n = null;
startUnaryTripleExpr();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RDF_TYPE:
    case CARAT:
    case LPAREN:
    case DOLLAR:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOLLAR:{
        jj_consume_token(DOLLAR);
        n = tripleExprLabel();
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RDF_TYPE:
      case CARAT:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        tripleConstraint(n);
        break;
        }
      case LPAREN:{
        bracketedTripleExpr(n);
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case AMP:{
      include();
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishUnaryTripleExpr();
  }

  final public void bracketedTripleExpr(Node label) throws ParseException {TripleExpression tripleExpr = null; Cardinality cardinality = null;
startBracketedTripleExpr();
    jj_consume_token(LPAREN);
    tripleExpr = tripleExpression();
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REPEAT_RANGE:
    case PLUS:
    case QMARK:
    case STAR:{
      cardinality = cardinality();
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:{
        ;
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        break label_20;
      }
      annotation();
    }
    semanticActions();
finishBracketedTripleExpr(label, tripleExpr, cardinality);
  }

  final public void tripleConstraint(Node label) throws ParseException {Node p; int idx; boolean reverse = false; Cardinality cardinality = null;
idx = startTripleConstraint();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CARAT:{
      reverse = senseFlags();
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    p = predicate();
    inlineShapeExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case REPEAT_RANGE:
    case PLUS:
    case QMARK:
    case STAR:{
      cardinality = cardinality();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 1:{
        ;
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        break label_21;
      }
      annotation();
    }
    semanticActions();
finishTripleConstraint(label, idx, p, reverse, cardinality);
  }

  final public Cardinality cardinality() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STAR:{
      jj_consume_token(STAR);
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
      break;
      }
    case QMARK:{
      jj_consume_token(QMARK);
      break;
      }
    case REPEAT_RANGE:{
      jj_consume_token(REPEAT_RANGE);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return cardinalityRange(token.image, token.beginLine, token.beginColumn);}
    throw new Error("Missing return statement in function");
  }

  final public boolean senseFlags() throws ParseException {
    jj_consume_token(CARAT);
{if ("" != null) return true;}
    throw new Error("Missing return statement in function");
  }

  final public void valueSet() throws ParseException {
startValueSet();
    jj_consume_token(LBRACKET);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case AT:
      case DOT:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LANG_STRING_LITERAL1:
      case LANG_STRING_LITERAL2:
      case LANG_STRING_LITERAL_LONG1:
      case LANG_STRING_LITERAL_LONG2:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case LANGTAG:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_22;
      }
      valueSetValue();
    }
    jj_consume_token(RBRACKET);
finishValueSet();
  }

// in https://github.com/shexSpec/grammar/blob/master/ShExDoc.g4
// valueSetValue   : iriRange
// 				| literalRange
// 				| languageRange
// 				| '.' (iriExclusion+ | literalExclusion+ | languageExclusion+)
// 				;

// void valueSetValue() : {}
// {
//     iriRange() | literalRange() | languageRange() | (LOOKAHEAD(2) exclusion())+
// }
// 
// void exclusion() : {}
// {
//   	<MINUS>
//     (
//         iri() | literal() | <LANGTAG>
//     ) (<TILDE>)?
// }
  final public 
void valueSetValue() throws ParseException {
startValueSetValue();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iriRange();
      break;
      }
    case TRUE:
    case FALSE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      literalRange();
      break;
      }
    case AT:
    case LANGTAG:{
      languageRange();
      break;
      }
    case DOT:{
      jj_consume_token(DOT);
startValueSetValueDot();
      label_23:
      while (true) {
        valueExclusion();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:{
          ;
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          break label_23;
        }
      }
finishValueSetValueDot();
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishValueSetValue();
  }

  final public void valueExclusion() throws ParseException {String iriStr = null; String lang = null; Node lit = null; boolean isStem = false;
    jj_consume_token(MINUS);
startValueExclusion();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iriStr = iri();
      break;
      }
    case TRUE:
    case FALSE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      lit = literal();
      break;
      }
    case LANGTAG:{
      jj_consume_token(LANGTAG);
lang = token.image;
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TILDE:{
      jj_consume_token(TILDE);
isStem = true ;
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
finishValueExclusion(iriStr, lang, lit, isStem);
  }

// void iriRange() : {}
// {
//    iri() (<TILDE> ( iriExclusion())*)?
// }
// 
// void iriExclusion() : {}
// {
//     <MINUS> iri() (<TILDE>)?
// }
  final public 
void iriRange() throws ParseException {String iriStr; boolean seenTilde = false; boolean haveSet = false;
startIriRange();
    iriStr = iri();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TILDE:{
      jj_consume_token(TILDE);
seenTilde = true;
valueSetIriRange(iriStr, seenTilde); haveSet = true;
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_24;
        }
        jj_consume_token(MINUS);
iriStr = null; seenTilde = false;
        iriStr = iri();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TILDE:{
          jj_consume_token(TILDE);
seenTilde = true;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          ;
        }
exclusionIriRange(iriStr, seenTilde);
      }
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      ;
    }
if ( ! haveSet ) { valueSetIriRange(iriStr, false); }
      finishIriRange();
  }

// void literalRange() : {}
// {
//     literal() (<TILDE> ( literalExclusion() )* )?
// }
// 
// void literalExclusion() : {}
// {
//     <MINUS> literal() (<TILDE>)?
// }
  final public 
void literalRange() throws ParseException {Node lit; boolean seenTilde = false; boolean haveSet = false;
startLiteralRange();
    lit = literal();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TILDE:{
      jj_consume_token(TILDE);
seenTilde = true;
valueSetLiteralRange(lit, seenTilde); haveSet = true;
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_25;
        }
        jj_consume_token(MINUS);
lit = null; seenTilde = false;
        lit = literal();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TILDE:{
          jj_consume_token(TILDE);
seenTilde = true;
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          ;
        }
exclusionLiteralRange(lit, seenTilde);
      }
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
if ( ! haveSet ) { valueSetLiteralRange(lit, false); }
      finishLiteralRange();
  }

// void languageRange() : {}
// {
//     (
//     <LANGTAG> (<TILDE> ( languageExclusion() )* )?
//     |
//     <AT> <TILDE> ( languageExclusion() )*
//     )
// }
// 
// void languageExclusion() : {}
// {
//     <MINUS> <LANGTAG> (<TILDE>)?
// }

// Better as original?
  final public void languageRange() throws ParseException {
startLanguageRange();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGTAG:{
      langRangeLANGTAG();
      break;
      }
    case AT:{
      langRangeAT();
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
finishLanguageRange();
  }

  final public void langRangeLANGTAG() throws ParseException {String lang = null; boolean seenTilde = false; boolean haveSet = false;
    jj_consume_token(LANGTAG);
lang = token.image;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TILDE:{
      jj_consume_token(TILDE);
seenTilde = true;
valueSetLanguageRange(lang, seenTilde); haveSet = true;
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:{
          ;
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_26;
        }
        jj_consume_token(MINUS);
lang = null; seenTilde = false;
        jj_consume_token(LANGTAG);
lang = token.image;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TILDE:{
          jj_consume_token(TILDE);
seenTilde = true;
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          ;
        }
exclusionLanguageRange(lang, seenTilde);
      }
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
if ( ! haveSet ) valueSetLanguageRange(lang, false);
  }

  final public void langRangeAT() throws ParseException {boolean haveSet = false; String lang = null; boolean seenTilde = false;
    jj_consume_token(AT);
    jj_consume_token(TILDE);
valueSetLanguageRange("@", true);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        break label_27;
      }
      jj_consume_token(MINUS);
      jj_consume_token(LANGTAG);
lang = token.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TILDE:{
        jj_consume_token(TILDE);
seenTilde = true;
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        ;
      }
exclusionLanguageRange(lang, seenTilde);
    }
  }

  final public void include() throws ParseException {Node n = null;
    jj_consume_token(AMP);
    n = tripleExprLabel();
ampTripleExprLabel(n);
  }

  final public void annotation() throws ParseException {
    jj_consume_token(1);
    predicate();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri();
      break;
      }
    case TRUE:
    case FALSE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      literal();
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void semanticActions() throws ParseException {
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CODE_BLOCK:{
        ;
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_28;
      }
      codeDecl();
    }
  }

  final public void codeDecl() throws ParseException {
    jj_consume_token(CODE_BLOCK);
  }

  final public Node literal() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:{
      n = rdfLiteral();
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      n = numericLiteral();
      break;
      }
    case TRUE:
    case FALSE:{
      n = booleanLiteral();
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

  final public Node predicate() throws ParseException {String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      s = iri();
{if ("" != null) return createURI(s, token.beginLine, token.beginColumn);}
      break;
      }
    case RDF_TYPE:{
      jj_consume_token(RDF_TYPE);
{if ("" != null) return nRDFtype;}
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node shapeExprLabel() throws ParseException {Node n ;
    //iri() | blankNode()
        n = _label();
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node tripleExprLabel() throws ParseException {Node n;
    //iri() | blankNode()
        n = _label();
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node _label() throws ParseException {String n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      n = iri();
{if ("" != null) return createURI(n, token.beginLine, token.beginColumn);}
      break;
      }
    case BLANK_NODE_LABEL:{
      n = blankNode();
{if ("" != null) return createBNode(n, token.beginLine, token.beginColumn);}
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// ------------------------- Terms
  final public 
Node booleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return XSD_TRUE;}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return XSD_FALSE;}
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node numericLiteral() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:{
      t = jj_consume_token(INTEGER);
{if ("" != null) return createLiteralInteger(t.image, token.beginLine, token.beginColumn) ;}
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
{if ("" != null) return createLiteralDecimal(t.image, token.beginLine, token.beginColumn) ;}
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
{if ("" != null) return createLiteralDouble(t.image, token.beginLine, token.beginColumn) ;}
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node rdfLiteral() throws ParseException {Node n; Token t; String lex; String dt = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:{
      n = langString();
{if ("" != null) return n;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      lex = string();
t = token;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 2:{
        jj_consume_token(2);
        dt = datatype();
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        ;
      }
{if ("" != null) return createLiteral(lex, null, dt, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String datatype() throws ParseException {String s;
    s = iri();
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {Token t ; String lex ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG1:{
      t = jj_consume_token(STRING_LITERAL_LONG1);
lex = stripQuotes3(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG2:{
      t = jj_consume_token(STRING_LITERAL_LONG2);
lex = stripQuotes3(t.image) ;
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return unescapeStr(lex,  t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node langString() throws ParseException {Token t; Node n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANG_STRING_LITERAL1:{
      t = jj_consume_token(LANG_STRING_LITERAL1);
{if ("" != null) return langStringLiteral(1, t.image, t.beginLine, t.beginColumn);}
      break;
      }
    case LANG_STRING_LITERAL2:{
      t = jj_consume_token(LANG_STRING_LITERAL2);
{if ("" != null) return langStringLiteral(1, t.image, t.beginLine, t.beginColumn);}
      break;
      }
    case LANG_STRING_LITERAL_LONG2:{
      t = jj_consume_token(LANG_STRING_LITERAL_LONG2);
{if ("" != null) return langStringLiteral(3, t.image, t.beginLine, t.beginColumn);}
      break;
      }
    case LANG_STRING_LITERAL_LONG1:{
      t = jj_consume_token(LANG_STRING_LITERAL_LONG1);
{if ("" != null) return langStringLiteral(3, t.image, t.beginLine, t.beginColumn);}
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String iri() throws ParseException {String iri = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:{
      iri = IRIREF();
{if ("" != null) return iri ;}
      break;
      }
    case PNAME_NS:
    case PNAME_LN:{
      iri = prefixedName();
{if ("" != null) return iri ;}
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String blankNode() throws ParseException {
    jj_consume_token(BLANK_NODE_LABEL);
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public String prefixedName() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PNAME_LN:{
      t = jj_consume_token(PNAME_LN);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case PNAME_NS:{
      t = jj_consume_token(PNAME_NS);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String IRIREF() throws ParseException {Token t ;
    t = jj_consume_token(IRIref);
{if ("" != null) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

// ---- Shape Map
  final public 
void UnitShapeMap() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    shexMapDoc();
    jj_consume_token(0);
  }

  final public void shexMapDoc() throws ParseException {
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:
      case IMPORT:
      case PREFIX:{
        ;
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        break label_29;
      }
      directive();
    }
    shapeMap();
  }

  final public void shapeMap() throws ParseException {
    shapeAssociation();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case LBRACE:
      case COMMA:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LANG_STRING_LITERAL1:
      case LANG_STRING_LITERAL2:
      case LANG_STRING_LITERAL_LONG1:
      case LANG_STRING_LITERAL_LONG2:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case BLANK_NODE_LABEL:{
        ;
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        ;
      }
      shapeAssociation();
    }
  }

  final public void shapeAssociation() throws ParseException {Node n = null ; Triple t = null ; Node label;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:
    case FALSE:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case BLANK_NODE_LABEL:{
      n = objectTerm();
      break;
      }
    case LBRACE:{
      t = triplePattern();
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label = shapeSpec();
association(n, t, label);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      ;
    }
  }

// void nodeSelector() : { Node n; Triple t; }
// {
//   ( n = objectTerm() { shapeAssociation(n); }
//   | t = triplePattern() { shapeAssociation(t); }
//   )
// }
  final public 
Node subjectTerm() throws ParseException {String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      s = iri();
{if ("" != null) return createURI(s, token.beginLine, token.beginColumn);}
      break;
      }
    case BLANK_NODE_LABEL:{
      s = blankNode();
{if ("" != null) return createBNode(s, token.beginLine, token.beginColumn);}
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node objectTerm() throws ParseException {Node n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      n = subjectTerm();
      break;
      }
    case TRUE:
    case FALSE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LANG_STRING_LITERAL1:
    case LANG_STRING_LITERAL2:
    case LANG_STRING_LITERAL_LONG1:
    case LANG_STRING_LITERAL_LONG2:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      n = literal();
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Triple triplePattern() throws ParseException {Node s = null; Node p = null ; Node o = null ; Token tok;
    tok = jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FOCUS:{
      jj_consume_token(FOCUS);
s = focusNode;
      p = predicate();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LANG_STRING_LITERAL1:
      case LANG_STRING_LITERAL2:
      case LANG_STRING_LITERAL_LONG1:
      case LANG_STRING_LITERAL_LONG2:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case BLANK_NODE_LABEL:{
        o = objectTerm();
        break;
        }
      case USCORE:{
        jj_consume_token(USCORE);
o = Node.ANY;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case USCORE:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{
        s = subjectTerm();
        break;
        }
      case USCORE:{
        jj_consume_token(USCORE);
s = Node.ANY;
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      p = predicate();
      jj_consume_token(FOCUS);
o = focusNode;
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
{if ("" != null) return createTriple(s, p, o, tok.beginLine, tok.beginColumn);}
    throw new Error("Missing return statement in function");
  }

  final public Node shapeSpec() throws ParseException {String x;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AT:{
      jj_consume_token(AT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        x = iri();
{if ("" != null) return createURI(x, token.beginLine, token.beginColumn);}
        break;
        }
      case START:{
        jj_consume_token(START);
{if ("" != null) return startNode;}
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ATSTART:{
      jj_consume_token(ATSTART);
{if ("" != null) return startNode;}
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(IRIref)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(AMP)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(PNAME_NS)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_scan_token(RDF_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_scan_token(PNAME_LN)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_scan_token(DOLLAR)) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) return true;
    }
    return false;
  }

  private boolean jj_3R_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_scan_token(CARAT)) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    }
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SEMI_COLON)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ShExJavaccTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[102];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x1000,0x1c000,0x80000,0x9c000,0x80000,0x1c000,0x80000,0x0,0x9c000,0xfe500000,0x800000,0x1000000,0x400000,0x0,0xfc000000,0xfe000000,0x800000,0x1000000,0x400000,0x0,0xfc000000,0xfe000000,0x0,0x0,0x0,0xe0000000,0xe0000000,0xe0000000,0x0,0x2000000,0xe0000000,0xe0000000,0xfc000000,0x1c000000,0xe0000000,0xe0000000,0xe0000000,0x0,0x0,0x0,0x0,0x0,0x2000,0x2,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x2000,0x2000,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x1000,0x1c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x80000,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x100,0x0,0x150500ff,0x0,0x0,0x0,0x40100c0,0x0,0x150500ff,0x0,0x0,0x0,0x40100c0,0x0,0x150500ff,0x40100c0,0x40100c0,0x10000,0x3f,0x3f,0x3f,0x3f,0x1000003f,0x0,0x0,0x0,0x0,0x3f,0x0,0x0,0x3f,0xf,0x30,0xc0,0xc0,0x1020000,0x0,0xc0,0xc0,0x1020000,0x0,0x8000,0x0,0x0,0x1020000,0x1020000,0x502200,0x0,0x20000,0x502200,0x0,0x502200,0x50c00,0x4000,0x50c00,0xc00,0x0,0x4000,0x0,0x0,0x4000,0x0,0x0,0x10000,0x4000,0x0,0x0,0x4000,0x0,0xc00,0x100,0xc00,0x0,0x0,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84000c00,0x80000000,0x4000c00,0x40000,0x0,0xc00,0xc00,0x0,0x0,0x0,0x10000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x200001c0,0x200001c0,0x200001c0,0x0,0x200001c0,0x0,0x200001c0,0x100007c0,0x0,0x0,0x0,0x600,0x10000000,0x100007c0,0x0,0x0,0x0,0x600,0x10000000,0x100007c0,0x600,0x600,0x600,0x10000000,0x10000000,0x10000000,0x0,0x1c0,0x10000000,0x10000000,0x10000000,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1d4,0x0,0x0,0x0,0x1d4,0x1c0,0x0,0x2,0x4,0x1c0,0x1d4,0x0,0x0,0x0,0x0,0x0,0x0,0x477f81c0,0x0,0x477f81c0,0x477f81c0,0x8,0x0,0x8,0x8,0x0,0x8,0x8,0x40000000,0x0,0x8,0x8,0x0,0x8,0x77f81c0,0x0,0x77f8000,0x1c0,0x200001c0,0x0,0x7000000,0x0,0x7f8000,0x78000,0x780000,0x1c0,0x180,0x0,0x0,0x277f81c0,0x0,0x277f81c0,0x0,0x200001c0,0x277f81c0,0x277f81c1,0x200001c1,0x200001c1,0x1c0,0x800,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ShExJavacc(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ShExJavacc(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ShExJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ShExJavacc(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ShExJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ShExJavacc(ShExJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ShExJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 102; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[107];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 102; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 107; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

 }
