/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.fuseki.mgt;

import static org.apache.jena.riot.WebContent.charsetUTF8 ;
import static org.apache.jena.riot.WebContent.contentTypeJSON ;

import java.io.IOException ;

import javax.servlet.ServletOutputStream ;
import javax.servlet.http.HttpServletRequest ;
import javax.servlet.http.HttpServletResponse ;

import org.apache.jena.atlas.json.JSON ;
import org.apache.jena.atlas.json.JsonBuilder ;
import org.apache.jena.atlas.json.JsonValue ;
import org.apache.jena.fuseki.Fuseki ;
import org.apache.jena.fuseki.server.DataAccessPointRegistry ;
import org.apache.jena.fuseki.servlets.HttpAction ;
import org.apache.jena.fuseki.servlets.ServletOps ;

/** Description of datasets for a server */ 
public class ActionServerStatus extends ActionCtl
{
    public ActionServerStatus() { super() ; }
    
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        doCommon(req, resp) ;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        doCommon(req, resp) ;
    }

    @Override
    protected void perform(HttpAction action) {
        try {
            description(action) ;
            ServletOps.success(action) ;
        } catch (IOException e) {
            ServletOps.errorOccurred(e) ;
        }
    }
    
    private void description(HttpAction action) throws IOException {
        ServletOutputStream out = action.response.getOutputStream() ;
        action.response.setContentType(contentTypeJSON);
        action.response.setCharacterEncoding(charsetUTF8) ;
        
        JsonBuilder builder = new JsonBuilder() ; 
        builder.startObject() ;
        describeServer(builder, action.request.getLocalPort()) ;
        describeDatasets(builder, action.getDataAccessPointRegistry()) ;
        builder.finishObject() ;
        
        JsonValue v = builder.build() ;
        JSON.write(out, v) ;
        out.println() ; 
        out.flush() ;
    }

    private void describeServer(JsonBuilder builder, int requestPort) {
        String versionStr = Fuseki.VERSION ;
        String builtDateStr = Fuseki.BUILD_DATE ;
        if ( versionStr == null || versionStr.startsWith("${") )
            versionStr = "Development" ;
        if ( builtDateStr == null || builtDateStr.startsWith("${") )
            builtDateStr = "Unknown" ;

//        builder
//            .key(JsonConst.server)
//            .startObject()
//            .key(JsonConst.port).value(port)
//            .finishObject() ;
//        builder
//            .key(JsonConst.admin)
//            .startObject()
//            .key(JsonConst.port).value(requestPort)
//            .finishObject() ;

        builder
            .key(JsonConst.version).value(versionStr)
            .key(JsonConst.built).value(builtDateStr)
            .key(JsonConst.startDT).value(Fuseki.serverStartedAt())
            .key(JsonConst.uptime).value(Fuseki.serverUptimeSeconds())
            ;
            
    }

    private void describeDatasets(JsonBuilder builder, DataAccessPointRegistry registry) {
        builder.key(JsonConst.datasets) ;
        JsonDescription.arrayDatasets(builder, registry);
    }

}

