/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.atlas.data;

import java.io.File ;

import org.apache.jena.atlas.data.AbstractDataBag ;

/**
 * This class exists so that we can examine the internals of a DataBag during testing (which we can do here since it is in the same package).
 */
public class DataBagExaminer
{
    public static int countTemporaryFiles(AbstractDataBag<?> bag)
    {
        int count = 0;
        for (File tempFile : bag.getSpillFiles())
        {
            if (tempFile.exists())
            {
                count++;
            }
        }
        return count;
    }
}
