/* ARQParser.java */
/* Generated By:JavaCC: Do not edit this line. ARQParser.java */
package org.apache.jena.sparql.lang.arq ;
import org.apache.jena.graph.* ;
import org.apache.jena.query.* ;
import org.apache.jena.sparql.core.Var ;
import org.apache.jena.sparql.syntax.* ;
import org.apache.jena.sparql.expr.* ;
import org.apache.jena.sparql.path.* ;
import org.apache.jena.sparql.expr.aggregate.* ;
import org.apache.jena.sparql.expr.aggregate.lib.* ;
import org.apache.jena.update.* ;
import org.apache.jena.sparql.modify.request.* ;
import org.apache.jena.sparql.core.Quad ;

@SuppressWarnings("all")
public class ARQParser extends ARQParserBase implements ARQParserConstants {

  final public void QueryUnit() throws ParseException {
    ByteOrderMark();
startQuery() ;
    Query();
    jj_consume_token(0);
finishQuery() ;
  }

  final public void Query() throws ParseException {
    Prologue();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SELECT:{
      SelectQuery();
      break;
      }
    case CONSTRUCT:{
      ConstructQuery();
      break;
      }
    case DESCRIBE:{
      DescribeQuery();
      break;
      }
    case ASK:{
      AskQuery();
      break;
      }
    case JSON:{
      JsonQuery();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    ValuesClause();
  }

  final public void UpdateUnit() throws ParseException {
    ByteOrderMark();
startUpdateRequest() ;
    Update();
    jj_consume_token(0);
finishUpdateRequest() ;
  }

  final public void ByteOrderMark() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
  }

  final public void Prologue() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:
      case PREFIX:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:{
        BaseDecl();
        break;
        }
      case PREFIX:{
        PrefixDecl();
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void BaseDecl() throws ParseException {String iri ;
    jj_consume_token(BASE);
    iri = IRIREF();
getPrologue().setBaseURI(iri) ;
  }

  final public void PrefixDecl() throws ParseException {Token t ; String iri ;
    jj_consume_token(PREFIX);
    t = jj_consume_token(PNAME_NS);
    iri = IRIREF();
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
        getPrologue().setPrefix(s, iri) ;
  }

  final public void SelectQuery() throws ParseException {
    SelectClause();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FROM:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      DatasetClause();
    }
    WhereClause();
    SolutionModifier();
  }

  final public void SubSelect() throws ParseException {
    SelectClause();
    WhereClause();
    SolutionModifier();
    ValuesClause();
  }

  final public void SelectClause() throws ParseException {Var v ; Expr expr ; Node n ;
    jj_consume_token(SELECT);
getQuery().setQuerySelectType() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DISTINCT:
    case REDUCED:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
getQuery().setDistinct(true);
        break;
        }
      case REDUCED:{
        jj_consume_token(REDUCED);
getQuery().setReduced(true);
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      ;
    }
setAllowAggregatesInExpressions(true) ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:{
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case VAR1:
        case VAR2:{
          v = Var();
getQuery().addResultVar(v) ;
          break;
          }
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case EXISTS:
        case NOT:
        case AGG:
        case COUNT:
        case MIN:
        case MAX:
        case SUM:
        case AVG:
        case MEDIAN:
        case MODE:
        case STDEV:
        case STDEV_SAMP:
        case STDEV_POP:
        case VARIANCE:
        case VAR_SAMP:
        case VAR_POP:
        case SAMPLE:
        case GROUP_CONCAT:
        case BOUND:
        case COALESCE:
        case IF:
        case BNODE:
        case IRI:
        case URI:
        case CALL:
        case STR:
        case STRLANG:
        case STRDT:
        case DTYPE:
        case LANG:
        case LANGMATCHES:
        case IS_URI:
        case IS_IRI:
        case IS_BLANK:
        case IS_LITERAL:
        case IS_NUMERIC:
        case REGEX:
        case SAME_TERM:
        case RAND:
        case ABS:
        case CEIL:
        case FLOOR:
        case ROUND:
        case CONCAT:
        case SUBSTR:
        case STRLEN:
        case REPLACE:
        case UCASE:
        case LCASE:
        case ENCODE_FOR_URI:
        case CONTAINS:
        case STRSTARTS:
        case STRENDS:
        case STRBEFORE:
        case STRAFTER:
        case YEAR:
        case MONTH:
        case DAY:
        case HOURS:
        case MINUTES:
        case SECONDS:
        case TIMEZONE:
        case TZ:
        case NOW:
        case UUID:
        case STRUUID:
        case VERSION:
        case MD5:
        case SHA1:
        case SHA256:
        case SHA384:
        case SHA512:
        case TRUE:
        case FALSE:
        case INTEGER:
        case DECIMAL:
        case DOUBLE:
        case INTEGER_POSITIVE:
        case DECIMAL_POSITIVE:
        case DOUBLE_POSITIVE:
        case INTEGER_NEGATIVE:
        case DECIMAL_NEGATIVE:
        case DOUBLE_NEGATIVE:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case STRING_LITERAL_LONG1:
        case STRING_LITERAL_LONG2:{
          if (jj_2_1(2)) {
            expr = BuiltInCall();
getQuery().addResultVar((Var)null, expr) ;
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case IRIref:
            case PNAME_NS:
            case PNAME_LN:{
              expr = FunctionCall();
getQuery().addResultVar((Var)null, expr) ;
              break;
              }
            case STRING_LITERAL1:
            case STRING_LITERAL2:
            case STRING_LITERAL_LONG1:
            case STRING_LITERAL_LONG2:{
              n = RDFLiteral();
getQuery().addResultVar((Var)null, NodeValue.makeNode(n)) ;
              break;
              }
            case INTEGER:
            case DECIMAL:
            case DOUBLE:
            case INTEGER_POSITIVE:
            case DECIMAL_POSITIVE:
            case DOUBLE_POSITIVE:
            case INTEGER_NEGATIVE:
            case DECIMAL_NEGATIVE:
            case DOUBLE_NEGATIVE:{
              n = NumericLiteral();
getQuery().addResultVar((Var)null, NodeValue.makeNode(n)) ;
              break;
              }
            case TRUE:
            case FALSE:{
              n = BooleanLiteral();
getQuery().addResultVar((Var)null, NodeValue.makeNode(n)) ;
              break;
              }
            default:
              jj_la1[7] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case LPAREN:{
v = null ;
          jj_consume_token(LPAREN);
          expr = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AS:{
            jj_consume_token(AS);
            v = Var();
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
getQuery().addResultVar(v, expr) ;
getQuery().setQueryResultStar(false) ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case VAR1:
        case VAR2:
        case EXISTS:
        case NOT:
        case AGG:
        case COUNT:
        case MIN:
        case MAX:
        case SUM:
        case AVG:
        case MEDIAN:
        case MODE:
        case STDEV:
        case STDEV_SAMP:
        case STDEV_POP:
        case VARIANCE:
        case VAR_SAMP:
        case VAR_POP:
        case SAMPLE:
        case GROUP_CONCAT:
        case BOUND:
        case COALESCE:
        case IF:
        case BNODE:
        case IRI:
        case URI:
        case CALL:
        case STR:
        case STRLANG:
        case STRDT:
        case DTYPE:
        case LANG:
        case LANGMATCHES:
        case IS_URI:
        case IS_IRI:
        case IS_BLANK:
        case IS_LITERAL:
        case IS_NUMERIC:
        case REGEX:
        case SAME_TERM:
        case RAND:
        case ABS:
        case CEIL:
        case FLOOR:
        case ROUND:
        case CONCAT:
        case SUBSTR:
        case STRLEN:
        case REPLACE:
        case UCASE:
        case LCASE:
        case ENCODE_FOR_URI:
        case CONTAINS:
        case STRSTARTS:
        case STRENDS:
        case STRBEFORE:
        case STRAFTER:
        case YEAR:
        case MONTH:
        case DAY:
        case HOURS:
        case MINUTES:
        case SECONDS:
        case TIMEZONE:
        case TZ:
        case NOW:
        case UUID:
        case STRUUID:
        case VERSION:
        case MD5:
        case SHA1:
        case SHA256:
        case SHA384:
        case SHA512:
        case TRUE:
        case FALSE:
        case INTEGER:
        case DECIMAL:
        case DOUBLE:
        case INTEGER_POSITIVE:
        case DECIMAL_POSITIVE:
        case DOUBLE_POSITIVE:
        case INTEGER_NEGATIVE:
        case DECIMAL_NEGATIVE:
        case DOUBLE_NEGATIVE:
        case STRING_LITERAL1:
        case STRING_LITERAL2:
        case STRING_LITERAL_LONG1:
        case STRING_LITERAL_LONG2:
        case LPAREN:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_3;
        }
      }
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
getQuery().setQueryResultStar(true) ;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
setAllowAggregatesInExpressions(false) ;
  }

  final public void ConstructQuery() throws ParseException {Template t ;
                          QuadAcc acc = new QuadAcc() ;
    jj_consume_token(CONSTRUCT);
getQuery().setQueryConstructType() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      t = ConstructTemplate();
getQuery().setConstructTemplate(t) ;
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FROM:{
          ;
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_4;
        }
        DatasetClause();
      }
      WhereClause();
      SolutionModifier();
      break;
      }
    case FROM:
    case WHERE:{
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FROM:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_5;
        }
        DatasetClause();
      }
      jj_consume_token(WHERE);
      jj_consume_token(LBRACE);
      ConstructQuads(acc);
      jj_consume_token(RBRACE);
      SolutionModifier();
t = new Template(acc) ;
      getQuery().setConstructTemplate(t) ;
   ElementGroup elg = createQueryPattern(t);
      getQuery().setQueryPattern(elg) ;
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DescribeQuery() throws ParseException {Node n ;
    jj_consume_token(DESCRIBE);
getQuery().setQueryDescribeType() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:{
      label_6:
      while (true) {
        n = VarOrIri();
getQuery().addDescribeNode(n) ;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case VAR1:
        case VAR2:{
          ;
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_6;
        }
      }
getQuery().setQueryResultStar(false) ;
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
getQuery().setQueryResultStar(true) ;
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FROM:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_7;
      }
      DatasetClause();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WHERE:
    case LBRACE:{
      WhereClause();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    SolutionModifier();
  }

  final public void AskQuery() throws ParseException {
    jj_consume_token(ASK);
getQuery().setQueryAskType() ;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FROM:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      DatasetClause();
    }
    WhereClause();
    SolutionModifier();
  }

  final public void JsonQuery() throws ParseException {
    JsonClause();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FROM:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_9;
      }
      DatasetClause();
    }
    WhereClause();
    SolutionModifier();
  }

  final public void JsonClause() throws ParseException {
    jj_consume_token(JSON);
getQuery().setQueryJsonType() ;
    jj_consume_token(LBRACE);
    JsonObjectMember();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      JsonObjectMember();
    }
    jj_consume_token(RBRACE);
  }

  final public void JsonObjectMember() throws ParseException {Node o ; String s ; Token t;
    s = String();
    t = jj_consume_token(PNAME_NS);
if ( ! t.image.equals(":") )
      throwParseException("Prefix name expression not legal at this point : "+t.image, t.beginLine, t.beginColumn) ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR1:
    case VAR2:{
      o = Var();
getQuery().addResultVar((Var)o) ; getQuery().addJsonMapping(s, o) ;
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      o = RDFLiteral();
getQuery().addResultVar(s, NodeValue.makeNode(o)) ; getQuery().addJsonMapping(s, o) ;
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:{
      o = NumericLiteral();
getQuery().addResultVar(s, NodeValue.makeNode(o)) ; getQuery().addJsonMapping(s, o) ;
      break;
      }
    case TRUE:
    case FALSE:{
      o = BooleanLiteral();
getQuery().addResultVar(s, NodeValue.makeNode(o)) ; getQuery().addJsonMapping(s, o) ;
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DatasetClause() throws ParseException {
    jj_consume_token(FROM);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      DefaultGraphClause();
      break;
      }
    case NAMED:{
      NamedGraphClause();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DefaultGraphClause() throws ParseException {String iri ;
    iri = SourceSelector();
getQuery().addGraphURI(iri) ;
  }

  final public void NamedGraphClause() throws ParseException {String iri ;
    jj_consume_token(NAMED);
    iri = SourceSelector();
getQuery().addNamedGraphURI(iri) ;
  }

  final public String SourceSelector() throws ParseException {String iri ;
    iri = iri();
{if ("" != null) return iri ;}
    throw new Error("Missing return statement in function");
  }

  final public void WhereClause() throws ParseException {Element el ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
startWherePattern() ;
    el = GroupGraphPattern();
getQuery().setQueryPattern(el) ;
finishWherePattern() ;
  }

  final public void SolutionModifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GROUP:{
      GroupClause();
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HAVING:{
      HavingClause();
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ORDER:{
      OrderClause();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LIMIT:
    case OFFSET:{
      LimitOffsetClauses();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
  }

  final public void GroupClause() throws ParseException {
    jj_consume_token(GROUP);
    jj_consume_token(BY);
    label_11:
    while (true) {
      GroupCondition();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case EXISTS:
      case NOT:
      case AGG:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case MEDIAN:
      case MODE:
      case STDEV:
      case STDEV_SAMP:
      case STDEV_POP:
      case VARIANCE:
      case VAR_SAMP:
      case VAR_POP:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case CALL:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case IS_NUMERIC:
      case REGEX:
      case SAME_TERM:
      case RAND:
      case ABS:
      case CEIL:
      case FLOOR:
      case ROUND:
      case CONCAT:
      case SUBSTR:
      case STRLEN:
      case REPLACE:
      case UCASE:
      case LCASE:
      case ENCODE_FOR_URI:
      case CONTAINS:
      case STRSTARTS:
      case STRENDS:
      case STRBEFORE:
      case STRAFTER:
      case YEAR:
      case MONTH:
      case DAY:
      case HOURS:
      case MINUTES:
      case SECONDS:
      case TIMEZONE:
      case TZ:
      case NOW:
      case UUID:
      case STRUUID:
      case VERSION:
      case MD5:
      case SHA1:
      case SHA256:
      case SHA384:
      case SHA512:
      case LPAREN:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_11;
      }
    }
  }

  final public void GroupCondition() throws ParseException {Var v = null ; Expr expr = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:{
      expr = BuiltInCall();
getQuery().addGroupBy((Var)null, expr) ;
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      expr = FunctionCall();
getQuery().addGroupBy((Var)null, expr) ;
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      expr = Expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        v = Var();
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
getQuery().addGroupBy(v ,expr) ;
      break;
      }
    case VAR1:
    case VAR2:{
      v = Var();
getQuery().addGroupBy(v) ;
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void HavingClause() throws ParseException {
setAllowAggregatesInExpressions(true) ;
    jj_consume_token(HAVING);
    label_12:
    while (true) {
      HavingCondition();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case EXISTS:
      case NOT:
      case AGG:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case MEDIAN:
      case MODE:
      case STDEV:
      case STDEV_SAMP:
      case STDEV_POP:
      case VARIANCE:
      case VAR_SAMP:
      case VAR_POP:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case CALL:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case IS_NUMERIC:
      case REGEX:
      case SAME_TERM:
      case RAND:
      case ABS:
      case CEIL:
      case FLOOR:
      case ROUND:
      case CONCAT:
      case SUBSTR:
      case STRLEN:
      case REPLACE:
      case UCASE:
      case LCASE:
      case ENCODE_FOR_URI:
      case CONTAINS:
      case STRSTARTS:
      case STRENDS:
      case STRBEFORE:
      case STRAFTER:
      case YEAR:
      case MONTH:
      case DAY:
      case HOURS:
      case MINUTES:
      case SECONDS:
      case TIMEZONE:
      case TZ:
      case NOW:
      case UUID:
      case STRUUID:
      case VERSION:
      case MD5:
      case SHA1:
      case SHA256:
      case SHA384:
      case SHA512:
      case LPAREN:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_12;
      }
    }
setAllowAggregatesInExpressions(false) ;
  }

  final public void HavingCondition() throws ParseException {Expr c ;
    c = Constraint();
getQuery().addHavingCondition(c) ;
  }

  final public void OrderClause() throws ParseException {
setAllowAggregatesInExpressions(true) ;
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    label_13:
    while (true) {
      OrderCondition();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case ASC:
      case DESC:
      case EXISTS:
      case NOT:
      case AGG:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case MEDIAN:
      case MODE:
      case STDEV:
      case STDEV_SAMP:
      case STDEV_POP:
      case VARIANCE:
      case VAR_SAMP:
      case VAR_POP:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case CALL:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case IS_NUMERIC:
      case REGEX:
      case SAME_TERM:
      case RAND:
      case ABS:
      case CEIL:
      case FLOOR:
      case ROUND:
      case CONCAT:
      case SUBSTR:
      case STRLEN:
      case REPLACE:
      case UCASE:
      case LCASE:
      case ENCODE_FOR_URI:
      case CONTAINS:
      case STRSTARTS:
      case STRENDS:
      case STRBEFORE:
      case STRAFTER:
      case YEAR:
      case MONTH:
      case DAY:
      case HOURS:
      case MINUTES:
      case SECONDS:
      case TIMEZONE:
      case TZ:
      case NOW:
      case UUID:
      case STRUUID:
      case VERSION:
      case MD5:
      case SHA1:
      case SHA256:
      case SHA384:
      case SHA512:
      case LPAREN:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_13;
      }
    }
setAllowAggregatesInExpressions(false) ;
  }

  final public void OrderCondition() throws ParseException {int direction = 0 ; Expr expr = null ; Node v = null ;
direction = Query.ORDER_DEFAULT ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASC:
    case DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASC:{
        jj_consume_token(ASC);
direction = Query.ORDER_ASCENDING ;
        break;
        }
      case DESC:{
        jj_consume_token(DESC);
direction = Query.ORDER_DESCENDING ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = BrackettedExpression();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:
    case LPAREN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case EXISTS:
      case NOT:
      case AGG:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case MEDIAN:
      case MODE:
      case STDEV:
      case STDEV_SAMP:
      case STDEV_POP:
      case VARIANCE:
      case VAR_SAMP:
      case VAR_POP:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case CALL:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case IS_NUMERIC:
      case REGEX:
      case SAME_TERM:
      case RAND:
      case ABS:
      case CEIL:
      case FLOOR:
      case ROUND:
      case CONCAT:
      case SUBSTR:
      case STRLEN:
      case REPLACE:
      case UCASE:
      case LCASE:
      case ENCODE_FOR_URI:
      case CONTAINS:
      case STRSTARTS:
      case STRENDS:
      case STRBEFORE:
      case STRAFTER:
      case YEAR:
      case MONTH:
      case DAY:
      case HOURS:
      case MINUTES:
      case SECONDS:
      case TIMEZONE:
      case TZ:
      case NOW:
      case UUID:
      case STRUUID:
      case VERSION:
      case MD5:
      case SHA1:
      case SHA256:
      case SHA384:
      case SHA512:
      case LPAREN:{
        expr = Constraint();
        break;
        }
      case VAR1:
      case VAR2:{
        v = Var();
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( v == null )
          getQuery().addOrderBy(expr, direction) ;
      else
          getQuery().addOrderBy(v, direction) ;
  }

  final public void LimitOffsetClauses() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LIMIT:{
      LimitClause();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OFFSET:{
        OffsetClause();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      break;
      }
    case OFFSET:{
      OffsetClause();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LIMIT:{
        LimitClause();
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void LimitClause() throws ParseException {Token t ;
    jj_consume_token(LIMIT);
    t = jj_consume_token(INTEGER);
getQuery().setLimit(integerValue(t.image)) ;
  }

  final public void OffsetClause() throws ParseException {Token t ;
    jj_consume_token(OFFSET);
    t = jj_consume_token(INTEGER);
getQuery().setOffset(integerValue(t.image)) ;
  }

  final public void ValuesClause() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VALUES:{
      t = jj_consume_token(VALUES);
startValuesClause(t.beginLine, t.beginColumn) ;
      DataBlock();
finishValuesClause(t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
  }

  final public void Update() throws ParseException {
    Prologue();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INSERT:
    case DELETE:
    case INSERT_DATA:
    case DELETE_DATA:
    case DELETE_WHERE:
    case LOAD:
    case CLEAR:
    case CREATE:
    case ADD:
    case MOVE:
    case COPY:
    case DROP:
    case WITH:{
      Update1();
      label_14:
      while (true) {
        if (jj_2_2(2147483647)) {
          ;
        } else {
          break label_14;
        }
        jj_consume_token(SEMICOLON);
        Prologue();
        Update1();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        Prologue();
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
  }

  final public void Update1() throws ParseException {Update up = null ;
startUpdateOperation() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LOAD:{
      up = Load();
      break;
      }
    case CLEAR:{
      up = Clear();
      break;
      }
    case DROP:{
      up = Drop();
      break;
      }
    case ADD:{
      up = Add();
      break;
      }
    case MOVE:{
      up = Move();
      break;
      }
    case COPY:{
      up = Copy();
      break;
      }
    case CREATE:{
      up = Create();
      break;
      }
    case DELETE_WHERE:{
      up = DeleteWhere();
      break;
      }
    case INSERT:
    case DELETE:
    case WITH:{
      up = Modify();
      break;
      }
    case INSERT_DATA:{
      InsertData();
      break;
      }
    case DELETE_DATA:{
      DeleteData();
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (null != up) emitUpdate(up) ;
    finishUpdateOperation() ;
  }

  final public Update Load() throws ParseException {String url ; Node dest = null ; boolean silent = false ;
    jj_consume_token(LOAD);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent = true ;
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    url = iri();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTO:{
      jj_consume_token(INTO);
      dest = GraphRef();
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
{if ("" != null) return new UpdateLoad(url, dest, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Clear() throws ParseException {boolean silent = false ; Target target ;
    jj_consume_token(CLEAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent = true ;
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    target = GraphRefAll();
{if ("" != null) return new UpdateClear(target, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Drop() throws ParseException {boolean silent = false ; Target target ;
    jj_consume_token(DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent = true ;
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    target = GraphRefAll();
{if ("" != null) return new UpdateDrop(target, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Create() throws ParseException {Node iri ; boolean silent = false ;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent=true ;
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    iri = GraphRef();
{if ("" != null) return new UpdateCreate(iri, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Add() throws ParseException {Target src ; Target dest ; boolean silent = false ;
    jj_consume_token(ADD);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent=true ;
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    src = GraphOrDefault();
    jj_consume_token(TO);
    dest = GraphOrDefault();
{if ("" != null) return new UpdateAdd(src, dest, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Move() throws ParseException {Target src ; Target dest ; boolean silent = false ;
    jj_consume_token(MOVE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent=true ;
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    src = GraphOrDefault();
    jj_consume_token(TO);
    dest = GraphOrDefault();
{if ("" != null) return new UpdateMove(src, dest, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Copy() throws ParseException {Target src ; Target dest ; boolean silent = false ;
    jj_consume_token(COPY);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent=true ;
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    src = GraphOrDefault();
    jj_consume_token(TO);
    dest = GraphOrDefault();
{if ("" != null) return new UpdateCopy(src, dest, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public void InsertData() throws ParseException {QuadDataAccSink qd = createInsertDataSink() ; Token t ;
    t = jj_consume_token(INSERT_DATA);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
startDataInsert(qd, beginLine, beginColumn) ;
    QuadData(qd);
finishDataInsert(qd, beginLine, beginColumn) ;
    qd.close() ;
  }

  final public void DeleteData() throws ParseException {QuadDataAccSink qd = createDeleteDataSink() ; Token t ;
    t = jj_consume_token(DELETE_DATA);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
startDataDelete(qd, beginLine, beginColumn) ;
    QuadData(qd);
finishDataDelete(qd, beginLine, beginColumn) ;
    qd.close() ;
  }

  final public Update DeleteWhere() throws ParseException {QuadAcc qp = new QuadAcc() ; Token t ;
    t = jj_consume_token(DELETE_WHERE);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
startDeleteTemplate(qp, beginLine, beginColumn) ;
    QuadPattern(qp);
finishDeleteTemplate(qp, beginLine, beginColumn) ;
{if ("" != null) return new UpdateDeleteWhere(qp) ;}
    throw new Error("Missing return statement in function");
  }

  final public Update Modify() throws ParseException {Element el ; String iri = null ;
                    UpdateModify up = new UpdateModify() ;
startModifyUpdate() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      iri = iri();
Node n = createNode(iri) ; up.setWithIRI(n) ;
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DELETE:{
      DeleteClause(up);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INSERT:{
        InsertClause(up);
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      break;
      }
    case INSERT:{
      InsertClause(up);
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case USING:{
        ;
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        break label_15;
      }
      UsingClause(up);
    }
    jj_consume_token(WHERE);
startWherePattern() ;
    el = GroupGraphPattern();
up.setElement(el) ;
finishWherePattern() ;
finishModifyUpdate() ;
{if ("" != null) return up ;}
    throw new Error("Missing return statement in function");
  }

  final public void DeleteClause(UpdateModify up) throws ParseException {QuadAcc qp = up.getDeleteAcc() ; Token t ;
    t = jj_consume_token(DELETE);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
startDeleteTemplate(qp, beginLine, beginColumn) ;
    QuadPattern(qp);
finishDeleteTemplate(qp, beginLine, beginColumn) ;
up.setHasDeleteClause(true) ;
  }

  final public void InsertClause(UpdateModify up) throws ParseException {QuadAcc qp = up.getInsertAcc() ; Token t ;
    t = jj_consume_token(INSERT);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
startInsertTemplate(qp, beginLine, beginColumn) ;
    QuadPattern(qp);
finishInsertTemplate(qp, beginLine, beginColumn) ;
up.setHasInsertClause(true) ;
  }

  final public void UsingClause(UpdateWithUsing update) throws ParseException {String iri ; Node n ;
    jj_consume_token(USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
n = createNode(iri) ; update.addUsing(n) ;
      break;
      }
    case NAMED:{
      jj_consume_token(NAMED);
      iri = iri();
n = createNode(iri) ; update.addUsingNamed(n) ;
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Target GraphOrDefault() throws ParseException {String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DFT:{
      jj_consume_token(DFT);
{if ("" != null) return Target.DEFAULT ;}
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case GRAPH:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GRAPH:{
        jj_consume_token(GRAPH);
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      iri = iri();
{if ("" != null) return Target.create(createNode(iri)) ;}
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node GraphRef() throws ParseException {String iri ;
    jj_consume_token(GRAPH);
    iri = iri();
{if ("" != null) return createNode(iri) ;}
    throw new Error("Missing return statement in function");
  }

  final public Target GraphRefAll() throws ParseException {Node iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GRAPH:{
      iri = GraphRef();
{if ("" != null) return Target.create(iri) ;}
      break;
      }
    case DFT:{
      jj_consume_token(DFT);
{if ("" != null) return Target.DEFAULT ;}
      break;
      }
    case NAMED:{
      jj_consume_token(NAMED);
{if ("" != null) return Target.NAMED ;}
      break;
      }
    case ALL:{
      jj_consume_token(ALL);
{if ("" != null) return Target.ALL ;}
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void QuadPattern(QuadAcc acc) throws ParseException {
    jj_consume_token(LBRACE);
    Quads(acc);
    jj_consume_token(RBRACE);
  }

  final public void QuadData(QuadDataAccSink acc) throws ParseException {
    jj_consume_token(LBRACE);
    Quads(acc);
    jj_consume_token(RBRACE);
  }

  final public void Quads(QuadAccSink acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
    case LT2:{
      TriplesTemplate(acc);
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GRAPH:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_16;
      }
      QuadsNotTriples(acc);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
        TriplesTemplate(acc);
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        ;
      }
    }
  }

  final public void QuadsNotTriples(QuadAccSink acc) throws ParseException {Node gn ; Node prev = acc.getGraph() ;
    jj_consume_token(GRAPH);
    gn = VarOrBlankNodeOrIri();
setAccGraph(acc, gn) ;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
    case LT2:{
      TriplesTemplate(acc);
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
setAccGraph(acc, prev) ;
  }

  final public void ConstructQuads(QuadAcc acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
    case LT2:{
      TriplesTemplate(acc);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GRAPH:
      case LBRACE:{
        ;
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        break label_17;
      }
      ConstructQuadsNotTriples(acc);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
        TriplesTemplate(acc);
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
    }
  }

  final public void ConstructQuadsNotTriples(QuadAccSink acc) throws ParseException {Node gn = Quad.defaultGraphNodeGenerated ;
       Node prev = acc.getGraph() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GRAPH:{
      jj_consume_token(GRAPH);
      gn = VarOrBlankNodeOrIri();
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
setAccGraph(acc, gn) ;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
    case LT2:{
      TriplesTemplate(acc);
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
setAccGraph(acc, prev) ;
  }

  final public void TriplesTemplate(TripleCollector acc) throws ParseException {
    TriplesSameSubject(acc);
    label_18:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_18;
      }
      jj_consume_token(DOT);
      TriplesSameSubject(acc);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      ;
    }
  }

  final public Element GroupGraphPattern() throws ParseException {Element el = null ; Token t ;
    t = jj_consume_token(LBRACE);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SELECT:{
startSubSelect(beginLine, beginColumn) ;
      SubSelect();
Query q = endSubSelect(beginLine, beginColumn) ;
      el = new ElementSubQuery(q) ;
      break;
      }
    default:
      jj_la1[72] = jj_gen;
      el = GroupGraphPatternSub();
    }
    jj_consume_token(RBRACE);
{if ("" != null) return el ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GroupGraphPatternSub() throws ParseException {Element el = null ;
ElementGroup elg = new ElementGroup() ;
startGroup(elg) ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:
    case NIL:
    case LBRACKET:
    case ANON:
    case LT2:{
startTriplesBlock() ;
      el = TriplesBlock(null);
endTriplesBlock() ;
      elg.addElement(el) ;
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VALUES:
      case GRAPH:
      case OPTIONAL:
      case MINUS_P:
      case BIND:
      case SERVICE:
      case LET:
      case FIND:
      case EXISTS:
      case NOT:
      case FILTER:
      case LBRACE:{
        ;
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        break label_19;
      }
      el = GraphPatternNotTriples();
elg.addElement(el) ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
startTriplesBlock() ;
        el = TriplesBlock(null);
endTriplesBlock() ;
        elg.addElement(el) ;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
    }
endGroup(elg) ;
{if ("" != null) return elg ;}
    throw new Error("Missing return statement in function");
  }

  final public Element TriplesBlock(ElementPathBlock acc) throws ParseException {
if ( acc == null )
        acc = new ElementPathBlock() ;
    TriplesSameSubjectPath(acc);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
        TriplesBlock(acc);
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      ;
    }
{if ("" != null) return acc ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GraphPatternNotTriples() throws ParseException {Element el = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      el = GroupOrUnionGraphPattern();
      break;
      }
    case OPTIONAL:{
      el = OptionalGraphPattern();
      break;
      }
    case MINUS_P:{
      el = MinusGraphPattern();
      break;
      }
    case GRAPH:{
      el = GraphGraphPattern();
      break;
      }
    case SERVICE:{
      el = ServiceGraphPattern();
      break;
      }
    case FILTER:{
      el = Filter();
      break;
      }
    case BIND:{
      el = Bind();
      break;
      }
    case VALUES:{
      el = InlineData();
      break;
      }
    case FIND:{
      el = Find();
      break;
      }
    case LET:{
      el = Assignment();
      break;
      }
    case EXISTS:{
      el = ExistsElt();
      break;
      }
    case NOT:{
      el = NotExistsElt();
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return el ;}
    throw new Error("Missing return statement in function");
  }

  final public Element OptionalGraphPattern() throws ParseException {Element el ;
    jj_consume_token(OPTIONAL);
    el = GroupGraphPattern();
{if ("" != null) return new ElementOptional(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GraphGraphPattern() throws ParseException {Element el ; Node n ;
    jj_consume_token(GRAPH);
    n = VarOrIri();
    el = GroupGraphPattern();
{if ("" != null) return new ElementNamedGraph(n, el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element ServiceGraphPattern() throws ParseException {Element el ; Node n ; boolean silent = false ;
    jj_consume_token(SERVICE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SILENT:{
      jj_consume_token(SILENT);
silent=true;
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    n = VarOrIri();
    el = GroupGraphPattern();
{if ("" != null) return new ElementService(n, el, silent) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element Bind() throws ParseException {Var v ; Expr expr ;
    jj_consume_token(BIND);
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(AS);
    v = Var();
    jj_consume_token(RPAREN);
{if ("" != null) return new ElementBind(v, expr) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element Find() throws ParseException {Var v ; Node n;
    jj_consume_token(FIND);
    jj_consume_token(LPAREN);
    n = TripleTerm();
    jj_consume_token(AS);
    v = Var();
    jj_consume_token(RPAREN);
{if ("" != null) return new ElementFind(v, n) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element InlineData() throws ParseException {ElementData el ; Token t ;
    t = jj_consume_token(VALUES);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
el = new ElementData() ;
    startInlineData(el.getVars(), el.getRows(), beginLine, beginColumn) ;
    DataBlock();
finishInlineData(beginLine, beginColumn) ;
    {if ("" != null) return el ;}
    throw new Error("Missing return statement in function");
  }

  final public void DataBlock() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR1:
    case VAR2:{
      InlineDataOneVar();
      break;
      }
    case LPAREN:
    case NIL:{
      InlineDataFull();
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void InlineDataOneVar() throws ParseException {Var v ; Node n ; Token t ; ; int beginLine; int beginColumn;
    v = Var();
emitDataBlockVariable(v) ;
    t = jj_consume_token(LBRACE);
beginLine = t.beginLine; beginColumn = t.beginColumn; t = null;
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case UNDEF:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LT2:{
        ;
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        break label_20;
      }
      n = DataBlockValue();
startDataBlockValueRow(beginLine, beginColumn) ;
      emitDataBlockValue(n, beginLine, beginColumn) ;
      finishDataBlockValueRow(beginLine, beginColumn) ;
    }
    t = jj_consume_token(RBRACE);
  }

  final public void InlineDataFull() throws ParseException {Var v ; Node n ; Token t ; int beginLine; int beginColumn;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NIL:{
      jj_consume_token(NIL);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case VAR1:
        case VAR2:{
          ;
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          break label_21;
        }
        v = Var();
emitDataBlockVariable(v) ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:
      case NIL:{
        ;
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        t = jj_consume_token(LPAREN);
beginLine = t.beginLine; beginColumn = t.beginColumn; t = null;
startDataBlockValueRow(beginLine, beginColumn) ;
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IRIref:
          case PNAME_NS:
          case PNAME_LN:
          case UNDEF:
          case TRUE:
          case FALSE:
          case INTEGER:
          case DECIMAL:
          case DOUBLE:
          case INTEGER_POSITIVE:
          case DECIMAL_POSITIVE:
          case DOUBLE_POSITIVE:
          case INTEGER_NEGATIVE:
          case DECIMAL_NEGATIVE:
          case DOUBLE_NEGATIVE:
          case STRING_LITERAL1:
          case STRING_LITERAL2:
          case STRING_LITERAL_LONG1:
          case STRING_LITERAL_LONG2:
          case LT2:{
            ;
            break;
            }
          default:
            jj_la1[86] = jj_gen;
            break label_23;
          }
          n = DataBlockValue();
emitDataBlockValue(n, beginLine, beginColumn) ;
        }
        t = jj_consume_token(RPAREN);
beginLine = t.beginLine; beginColumn = t.beginColumn; t = null;
finishDataBlockValueRow(beginLine, beginColumn) ;
        break;
        }
      case NIL:{
        t = jj_consume_token(NIL);
beginLine = t.beginLine; beginColumn = t.beginColumn; t = null;
startDataBlockValueRow(beginLine, beginColumn) ;
finishDataBlockValueRow(beginLine, beginColumn) ;
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
  }

  final public Node DataBlockValue() throws ParseException {Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
{if ("" != null) return createNode(iri) ;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      n = RDFLiteral();
{if ("" != null) return n ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:{
      n = NumericLiteral();
{if ("" != null) return n ;}
      break;
      }
    case TRUE:
    case FALSE:{
      n = BooleanLiteral();
{if ("" != null) return n ;}
      break;
      }
    case LT2:{
      n = TripleTerm();
{if ("" != null) return n ;}
      break;
      }
    case UNDEF:{
      jj_consume_token(UNDEF);
{if ("" != null) return null ;}
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Element Assignment() throws ParseException {Var v ; Expr expr ;
    jj_consume_token(LET);
    jj_consume_token(LPAREN);
    v = Var();
    jj_consume_token(ASSIGN);
    expr = Expression();
    jj_consume_token(RPAREN);
{if ("" != null) return new ElementAssign(v, expr) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element ExistsElt() throws ParseException {Element el ;
    jj_consume_token(EXISTS);
    el = GroupGraphPattern();
{if ("" != null) return new ElementExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element NotExistsElt() throws ParseException {Element el ;
    jj_consume_token(NOT);
    jj_consume_token(EXISTS);
    el = GroupGraphPattern();
{if ("" != null) return new ElementNotExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element MinusGraphPattern() throws ParseException {Element el ;
    jj_consume_token(MINUS_P);
    el = GroupGraphPattern();
{if ("" != null) return new ElementMinus(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Element GroupOrUnionGraphPattern() throws ParseException {Element el = null ; ElementUnion el2 = null ;
    el = GroupGraphPattern();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case UNION:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_24;
      }
      jj_consume_token(UNION);
if ( el2 == null )
      {
        el2 = new ElementUnion() ;
        el2.addElement(el) ;
      }
      el = GroupGraphPattern();
el2.addElement(el) ;
    }
{if ("" != null) return (el2==null)? el : el2 ;}
    throw new Error("Missing return statement in function");
  }

  final public Element Filter() throws ParseException {Expr c ;
    jj_consume_token(FILTER);
    c = Constraint();
{if ("" != null) return new ElementFilter(c) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr Constraint() throws ParseException {Expr c ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      c = BrackettedExpression();
      break;
      }
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:{
      c = BuiltInCall();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      c = FunctionCall();
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return c ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr FunctionCall() throws ParseException {String fname ; Args a ;
    fname = iri();
    a = ArgList();
if ( AggregateRegistry.isRegistered(fname) ) {
         if ( ! getAllowAggregatesInExpressions() )
            throwParseException("Aggregate expression not legal at this point : "+fname, -1, -1) ;
         Aggregator agg = AggregatorFactory.createCustom(fname, a) ;
         Expr exprAgg = getQuery().allocAggregate(agg) ;
         {if ("" != null) return exprAgg ;}
     }
     {if ("" != null) return new E_Function(fname, a) ;}
    throw new Error("Missing return statement in function");
  }

  final public Args ArgList() throws ParseException {Expr expr ; Args args = new Args() ; Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NIL:{
      jj_consume_token(NIL);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        t = jj_consume_token(DISTINCT);
args.distinct = true ;
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
if ( ! getAllowAggregatesInExpressions() )
              throwParseException("Aggregate expression not legal at this point",
                                 beginLine, beginColumn) ;
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        ;
      }
      expr = Expression();
args.add(expr) ;
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_25;
        }
        jj_consume_token(COMMA);
        expr = Expression();
args.add(expr) ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return args ;}
    throw new Error("Missing return statement in function");
  }

  final public ExprList ExpressionList() throws ParseException {Expr expr = null ; ExprList exprList = new ExprList() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NIL:{
      jj_consume_token(NIL);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      expr = Expression();
exprList.add(expr) ;
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        expr = Expression();
exprList.add(expr) ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return exprList ;}
    throw new Error("Missing return statement in function");
  }

  final public Template ConstructTemplate() throws ParseException {QuadAcc acc = new QuadAcc() ;
                                 Template t = new Template (acc);
setInConstructTemplate(true) ;
    jj_consume_token(LBRACE);
    ConstructQuads(acc);
    jj_consume_token(RBRACE);
setInConstructTemplate(false) ;
      {if ("" != null) return t ;}
    throw new Error("Missing return statement in function");
  }

  final public void ConstructTriples(TripleCollector acc) throws ParseException {
    TriplesSameSubject(acc);
    label_27:
    while (true) {
      if (jj_2_4(2)) {
        ;
      } else {
        break label_27;
      }
      jj_consume_token(DOT);
      TriplesSameSubject(acc);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      ;
    }
  }

  final public void TriplesSameSubject(TripleCollector acc) throws ParseException {Node s ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
    case LT2:{
      s = VarOrTerm();
      PropertyListNotEmpty(s, acc);
      break;
      }
    case LPAREN:
    case LBRACKET:{
ElementPathBlock tempAcc = new ElementPathBlock() ;
      s = TriplesNode(tempAcc);
      PropertyList(s, tempAcc);
insert(acc, tempAcc) ;
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PropertyList(Node s, TripleCollector acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case KW_A:{
      PropertyListNotEmpty(s, acc);
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      ;
    }
  }

  final public void PropertyListNotEmpty(Node s, TripleCollector acc) throws ParseException {Node p = null ;
    p = Verb();
    ObjectList(s, p, null, acc);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        break label_28;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case KW_A:{
        p = Verb();
        ObjectList(s, p, null, acc);
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        ;
      }
    }
  }

  final public Node Verb() throws ParseException {Node p ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:{
      p = VarOrIri();
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
p = nRDFtype ;
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public void ObjectList(Node s, Node p, Path path, TripleCollector acc) throws ParseException {Node o ;
    Object(s, p, path, acc);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        break label_29;
      }
      jj_consume_token(COMMA);
      Object(s, p, path, acc);
    }
  }

  final public void Object(Node s, Node p, Path path, TripleCollector acc) throws ParseException {Node o ;
ElementPathBlock tempAcc = new ElementPathBlock() ; int mark = tempAcc.mark() ;
    o = GraphNode(tempAcc);
insert(tempAcc, mark, s, p, path, o) ; insert(acc, tempAcc) ;
  }

  final public void TriplesSameSubjectPath(TripleCollector acc) throws ParseException {Node s ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
    case LT2:{
      s = VarOrTerm();
      PropertyListPathNotEmpty(s, acc);
      break;
      }
    case LPAREN:
    case LBRACKET:{
ElementPathBlock tempAcc = new ElementPathBlock() ;
      s = TriplesNodePath(tempAcc);
      PropertyListPath(s, tempAcc);
insert(acc, tempAcc) ;
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PropertyListPath(Node s, TripleCollector acc) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case KW_A:
    case DISTINCT:
    case MULTI:
    case SHORTEST:
    case LPAREN:
    case BANG:
    case CARAT:{
      PropertyListPathNotEmpty(s, acc);
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
  }

  final public void PropertyListPathNotEmpty(Node s, TripleCollector acc) throws ParseException {Path path = null ; Node p = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
    case DISTINCT:
    case MULTI:
    case SHORTEST:
    case LPAREN:
    case BANG:
    case CARAT:{
      path = VerbPath();
      break;
      }
    case VAR1:
    case VAR2:{
      p = VerbSimple();
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    ObjectListPath(s, p, path, acc);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        break label_30;
      }
      jj_consume_token(SEMICOLON);
path = null ; p = null ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case KW_A:
      case DISTINCT:
      case MULTI:
      case SHORTEST:
      case LPAREN:
      case BANG:
      case CARAT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IRIref:
        case PNAME_NS:
        case PNAME_LN:
        case KW_A:
        case DISTINCT:
        case MULTI:
        case SHORTEST:
        case LPAREN:
        case BANG:
        case CARAT:{
          path = VerbPath();
          break;
          }
        case VAR1:
        case VAR2:{
          p = VerbSimple();
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ObjectListPath(s, p, path, acc);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        ;
      }
    }
  }

  final public Path VerbPath() throws ParseException {Node p ; Path path ;
    path = Path();
{if ("" != null) return path ;}
    throw new Error("Missing return statement in function");
  }

  final public Node VerbSimple() throws ParseException {Node p ;
    p = Var();
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public void ObjectListPath(Node s, Node p, Path path, TripleCollector acc) throws ParseException {Node o ;
    ObjectPath(s, p, path, acc);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      ObjectPath(s, p, path, acc);
    }
  }

  final public void ObjectPath(Node s, Node p, Path path, TripleCollector acc) throws ParseException {Node o ;
ElementPathBlock tempAcc = new ElementPathBlock() ; int mark = tempAcc.mark() ;
    o = GraphNodePath(tempAcc);
insert(tempAcc, mark, s, p, path, o) ; insert(acc, tempAcc) ;
  }

  final public Path PathUnit() throws ParseException {Path p ;
    ByteOrderMark();
    p = Path();
    jj_consume_token(0);
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path Path() throws ParseException {Path p ;
    p = PathAlternative();
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathAlternative() throws ParseException {Path p1 , p2 ;
    p1 = PathSequence();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        break label_32;
      }
      jj_consume_token(VBAR);
      p2 = PathSequence();
p1 = PathFactory.pathAlt(p1, p2) ;
    }
{if ("" != null) return p1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathSequence() throws ParseException {Path p1 , p2 ;
    p1 = PathEltOrInverse();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SLASH:
      case CARAT:{
        ;
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SLASH:{
        jj_consume_token(SLASH);
        p2 = PathEltOrInverse();
p1 = PathFactory.pathSeq(p1, p2) ;
        break;
        }
      case CARAT:{
        jj_consume_token(CARAT);
        p2 = PathElt();
p1 = PathFactory.pathSeq(p1, new P_Inverse(p2)) ;
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathElt() throws ParseException {String str ; Node n ; Path p ;
    p = PathPrimary();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:
    case PLUS:
    case STAR:
    case QMARK:{
      p = PathMod(p);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathEltOrInverse() throws ParseException {String str ; Node n ; Path p ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
    case DISTINCT:
    case MULTI:
    case SHORTEST:
    case LPAREN:
    case BANG:{
      p = PathElt();
      break;
      }
    case CARAT:{
      jj_consume_token(CARAT);
      p = PathElt();
p = PathFactory.pathInverse(p) ;
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathMod(Path p) throws ParseException {long i1 ; long i2 ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QMARK:{
      jj_consume_token(QMARK);
{if ("" != null) return PathFactory.pathZeroOrOne(p) ;}
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
{if ("" != null) return PathFactory.pathZeroOrMore1(p) ;}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return PathFactory.pathOneOrMore1(p) ;}
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
        jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathZeroOrMoreN(p) ;}
        break;
        }
      case PLUS:{
        jj_consume_token(PLUS);
        jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathOneOrMoreN(p) ;}
        break;
        }
      case INTEGER:{
        i1 = Integer();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case RBRACE:{
            jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathMod(p, i1, PathFactory.UNSET) ;}
            break;
            }
          case INTEGER:{
            i2 = Integer();
            jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathMod(p, i1, i2) ;}
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case RBRACE:{
          jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathFixedLength(p, i1) ;}
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case COMMA:{
        jj_consume_token(COMMA);
        i2 = Integer();
        jj_consume_token(RBRACE);
{if ("" != null) return PathFactory.pathMod(p, PathFactory.UNSET, i2) ;}
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Path PathPrimary() throws ParseException {String str ; Path p ; Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      str = iri();
n = createNode(str) ; p = PathFactory.pathLink(n) ;
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
p = PathFactory.pathLink(nRDFtype) ;
      break;
      }
    case BANG:{
      jj_consume_token(BANG);
      p = PathNegatedPropertySet();
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      p = Path();
      jj_consume_token(RPAREN);
      break;
      }
    case DISTINCT:{
      jj_consume_token(DISTINCT);
      jj_consume_token(LPAREN);
      p = Path();
p = PathFactory.pathDistinct(p) ;
      jj_consume_token(RPAREN);
      break;
      }
    case SHORTEST:{
      jj_consume_token(SHORTEST);
      jj_consume_token(LPAREN);
      p = Path();
p = PathFactory.pathShortest(p) ;
      jj_consume_token(RPAREN);
      break;
      }
    case MULTI:{
      jj_consume_token(MULTI);
      jj_consume_token(LPAREN);
      p = Path();
p = PathFactory.pathMulti(p) ;
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

  final public Path PathNegatedPropertySet() throws ParseException {P_Path0 p ; P_NegPropSet pNegSet ;
pNegSet = new P_NegPropSet() ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case KW_A:
    case CARAT:{
      p = PathOneInPropertySet();
pNegSet.add(p) ;
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case KW_A:
      case CARAT:{
        p = PathOneInPropertySet();
pNegSet.add(p) ;
        label_34:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case VBAR:{
            ;
            break;
            }
          default:
            jj_la1[120] = jj_gen;
            break label_34;
          }
          jj_consume_token(VBAR);
          p = PathOneInPropertySet();
pNegSet.add(p) ;
        }
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return pNegSet ;}
    throw new Error("Missing return statement in function");
  }

  final public P_Path0 PathOneInPropertySet() throws ParseException {String str ; Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      str = iri();
n = createNode(str) ; {if ("" != null) return new P_Link(n) ;}
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
{if ("" != null) return new P_Link(nRDFtype) ;}
      break;
      }
    case CARAT:{
      jj_consume_token(CARAT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        str = iri();
n = createNode(str) ; {if ("" != null) return new P_ReverseLink(n) ;}
        break;
        }
      case KW_A:{
        jj_consume_token(KW_A);
{if ("" != null) return new P_ReverseLink(nRDFtype) ;}
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public long Integer() throws ParseException {Token t ;
    t = jj_consume_token(INTEGER);
{if ("" != null) return integerValue(t.image) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node TriplesNode(TripleCollectorMark acc) throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      n = Collection(acc);
{if ("" != null) return n ;}
      break;
      }
    case LBRACKET:{
      n = BlankNodePropertyList(acc);
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[125] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNodePropertyList(TripleCollector acc) throws ParseException {Token t ;
    t = jj_consume_token(LBRACKET);
Node n = createBNode( t.beginLine, t.beginColumn) ;
    PropertyListNotEmpty(n, acc);
    jj_consume_token(RBRACKET);
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node TriplesNodePath(TripleCollectorMark acc) throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      n = CollectionPath(acc);
{if ("" != null) return n ;}
      break;
      }
    case LBRACKET:{
      n = BlankNodePropertyListPath(acc);
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNodePropertyListPath(TripleCollector acc) throws ParseException {Token t ;
    t = jj_consume_token(LBRACKET);
Node n = createBNode( t.beginLine, t.beginColumn) ;
    PropertyListPathNotEmpty(n, acc);
    jj_consume_token(RBRACKET);
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node Collection(TripleCollectorMark acc) throws ParseException {Node listHead = nRDFnil ; Node lastCell = null ; int mark ; Node n ; Token t ;
    t = jj_consume_token(LPAREN);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
    label_35:
    while (true) {
Node cell = createListNode( beginLine, beginColumn) ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        insert(acc, lastCell, nRDFrest, cell) ;
      mark = acc.mark() ;
      n = GraphNode(acc);
insert(acc, mark, cell, nRDFfirst, n) ;
      lastCell = cell ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
        ;
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_35;
      }
    }
    jj_consume_token(RPAREN);
if ( lastCell != null )
       insert(acc, lastCell, nRDFrest, nRDFnil) ;
     {if ("" != null) return listHead ;}
    throw new Error("Missing return statement in function");
  }

  final public Node CollectionPath(TripleCollectorMark acc) throws ParseException {Node listHead = nRDFnil ; Node lastCell = null ; int mark ; Node n ; Token t ;
    t = jj_consume_token(LPAREN);
int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null;
    label_36:
    while (true) {
Node cell = createListNode( beginLine, beginColumn) ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        insert(acc, lastCell, nRDFrest, cell) ;
      mark = acc.mark() ;
      n = GraphNodePath(acc);
insert(acc, mark, cell, nRDFfirst, n) ;
      lastCell = cell ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:
      case VAR1:
      case VAR2:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case LT2:{
        ;
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        break label_36;
      }
    }
    jj_consume_token(RPAREN);
if ( lastCell != null )
       insert(acc, lastCell, nRDFrest, nRDFnil) ;
     {if ("" != null) return listHead ;}
    throw new Error("Missing return statement in function");
  }

  final public Node GraphNode(TripleCollectorMark acc) throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
    case LT2:{
      n = VarOrTerm();
{if ("" != null) return n ;}
      break;
      }
    case LPAREN:
    case LBRACKET:{
      n = TriplesNode(acc);
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node GraphNodePath(TripleCollectorMark acc) throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case VAR1:
    case VAR2:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
    case LT2:{
      n = VarOrTerm();
{if ("" != null) return n ;}
      break;
      }
    case LPAREN:
    case LBRACKET:{
      n = TriplesNodePath(acc);
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node VarOrTerm() throws ParseException {Node n = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT2:{
      n = TripleTerm();
      break;
      }
    case VAR1:
    case VAR2:{
      n = Var();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:{
      n = GraphTerm();
      break;
      }
    default:
      jj_la1[131] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node TripleTerm() throws ParseException {Node n = null ; Token t ; Node s , p , o ;
    t = jj_consume_token(LT2);
    s = VarOrTerm();
    p = Verb();
    o = VarOrTerm();
n = createTripleTerm(s, p, o, t.beginLine, t.beginColumn);
    jj_consume_token(GT2);
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

  final public Node VarOrIri() throws ParseException {Node n = null ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR1:
    case VAR2:{
      n = Var();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
n = createNode(iri) ;
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node VarOrBlankNodeOrIri() throws ParseException {Node n = null ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR1:
    case VAR2:{
      n = Var();
      break;
      }
    case BLANK_NODE_LABEL:
    case ANON:{
      n = BlankNode();
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
n = createNode(iri) ;
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Var Var() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VAR1:{
      t = jj_consume_token(VAR1);
      break;
      }
    case VAR2:{
      t = jj_consume_token(VAR2);
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return createVariable(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node GraphTerm() throws ParseException {Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
{if ("" != null) return createNode(iri) ;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      n = RDFLiteral();
{if ("" != null) return n ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:{
      n = NumericLiteral();
{if ("" != null) return n ;}
      break;
      }
    case TRUE:
    case FALSE:{
      n = BooleanLiteral();
{if ("" != null) return n ;}
      break;
      }
    case BLANK_NODE_LABEL:
    case ANON:{
      n = BlankNode();
{if ("" != null) return n ;}
      break;
      }
    case NIL:{
      jj_consume_token(NIL);
{if ("" != null) return nRDFnil ;}
      break;
      }
    default:
      jj_la1[135] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr Expression() throws ParseException {Expr expr ;
    expr = ConditionalOrExpression();
{if ("" != null) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ConditionalOrExpression() throws ParseException {Expr expr1, expr2 ;
    expr1 = ConditionalAndExpression();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_OR:{
        ;
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        break label_37;
      }
      jj_consume_token(SC_OR);
      expr2 = ConditionalAndExpression();
expr1 = new E_LogicalOr(expr1, expr2) ;
    }
{if ("" != null) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ConditionalAndExpression() throws ParseException {Expr expr1, expr2 ;
    expr1 = ValueLogical();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_AND:{
        ;
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        break label_38;
      }
      jj_consume_token(SC_AND);
      expr2 = ValueLogical();
expr1 = new E_LogicalAnd(expr1, expr2) ;
    }
{if ("" != null) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ValueLogical() throws ParseException {Expr expr ;
    expr = RelationalExpression();
{if ("" != null) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr RelationalExpression() throws ParseException {Expr expr1, expr2 ; ExprList a ;
    expr1 = NumericExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case IN:
    case EQ:
    case NE:
    case GT:
    case LT:
    case LE:
    case GE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
        expr2 = NumericExpression();
expr1 = new E_Equals(expr1, expr2) ;
        break;
        }
      case NE:{
        jj_consume_token(NE);
        expr2 = NumericExpression();
expr1 = new E_NotEquals(expr1, expr2) ;
        break;
        }
      case LT:{
        jj_consume_token(LT);
        expr2 = NumericExpression();
expr1 = new E_LessThan(expr1, expr2) ;
        break;
        }
      case GT:{
        jj_consume_token(GT);
        expr2 = NumericExpression();
expr1 = new E_GreaterThan(expr1, expr2) ;
        break;
        }
      case LE:{
        jj_consume_token(LE);
        expr2 = NumericExpression();
expr1 = new E_LessThanOrEqual(expr1, expr2) ;
        break;
        }
      case GE:{
        jj_consume_token(GE);
        expr2 = NumericExpression();
expr1 = new E_GreaterThanOrEqual(expr1, expr2) ;
        break;
        }
      case IN:{
        jj_consume_token(IN);
        a = ExpressionList();
expr1 = new E_OneOf(expr1, a) ;
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        jj_consume_token(IN);
        a = ExpressionList();
expr1 = new E_NotOneOf(expr1, a) ;
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[139] = jj_gen;
      ;
    }
{if ("" != null) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr NumericExpression() throws ParseException {Expr expr ;
    expr = AdditiveExpression();
{if ("" != null) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr AdditiveExpression() throws ParseException {Expr expr1, expr2, expr3 ; boolean addition ; Node n ;
    expr1 = MultiplicativeExpression();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        break label_39;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
        expr2 = MultiplicativeExpression();
expr1 = new E_Add(expr1, expr2) ;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
        expr2 = MultiplicativeExpression();
expr1 = new E_Subtract(expr1, expr2) ;
        break;
        }
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case INTEGER_POSITIVE:
        case DECIMAL_POSITIVE:
        case DOUBLE_POSITIVE:{
          n = NumericLiteralPositive();
n = stripSign(n) ;
         expr2 = asExpr(n) ;
         addition = true ;
          break;
          }
        case INTEGER_NEGATIVE:
        case DECIMAL_NEGATIVE:
        case DOUBLE_NEGATIVE:{
          n = NumericLiteralNegative();
n = stripSign(n) ;
         expr2 = asExpr(n) ;
         addition = false ;
          break;
          }
        default:
          jj_la1[141] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_40:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case STAR:
          case SLASH:{
            ;
            break;
            }
          default:
            jj_la1[142] = jj_gen;
            break label_40;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case STAR:{
            jj_consume_token(STAR);
            expr3 = UnaryExpression();
expr2 = new E_Multiply(expr2, expr3) ;
            break;
            }
          case SLASH:{
            jj_consume_token(SLASH);
            expr3 = UnaryExpression();
expr2 = new E_Divide(expr2, expr3) ;
            break;
            }
          default:
            jj_la1[143] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
if ( addition )
         expr1 = new E_Add(expr1, expr2) ;
      else
         expr1 = new E_Subtract(expr1, expr2) ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr MultiplicativeExpression() throws ParseException {Expr expr1, expr2 ;
    expr1 = UnaryExpression();
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:
      case SLASH:{
        ;
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_41;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
        expr2 = UnaryExpression();
expr1 = new E_Multiply(expr1, expr2) ;
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
        expr2 = UnaryExpression();
expr1 = new E_Divide(expr1, expr2) ;
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expr1 ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr UnaryExpression() throws ParseException {Expr expr ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BANG:{
      jj_consume_token(BANG);
      expr = PrimaryExpression();
{if ("" != null) return new E_LogicalNot(expr) ;}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
      expr = PrimaryExpression();
{if ("" != null) return new E_UnaryPlus(expr) ;}
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      expr = PrimaryExpression();
{if ("" != null) return new E_UnaryMinus(expr) ;}
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:
    case VAR1:
    case VAR2:
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:
    case TRUE:
    case FALSE:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case LPAREN:{
      expr = PrimaryExpression();
{if ("" != null) return expr ;}
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr PrimaryExpression() throws ParseException {Expr expr ; Node gn ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      expr = BrackettedExpression();
{if ("" != null) return expr ;}
      break;
      }
    case EXISTS:
    case NOT:
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:
    case BOUND:
    case COALESCE:
    case IF:
    case BNODE:
    case IRI:
    case URI:
    case CALL:
    case STR:
    case STRLANG:
    case STRDT:
    case DTYPE:
    case LANG:
    case LANGMATCHES:
    case IS_URI:
    case IS_IRI:
    case IS_BLANK:
    case IS_LITERAL:
    case IS_NUMERIC:
    case REGEX:
    case SAME_TERM:
    case RAND:
    case ABS:
    case CEIL:
    case FLOOR:
    case ROUND:
    case CONCAT:
    case SUBSTR:
    case STRLEN:
    case REPLACE:
    case UCASE:
    case LCASE:
    case ENCODE_FOR_URI:
    case CONTAINS:
    case STRSTARTS:
    case STRENDS:
    case STRBEFORE:
    case STRAFTER:
    case YEAR:
    case MONTH:
    case DAY:
    case HOURS:
    case MINUTES:
    case SECONDS:
    case TIMEZONE:
    case TZ:
    case NOW:
    case UUID:
    case STRUUID:
    case VERSION:
    case MD5:
    case SHA1:
    case SHA256:
    case SHA384:
    case SHA512:{
      expr = BuiltInCall();
{if ("" != null) return expr ;}
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      expr = iriOrFunction();
{if ("" != null) return expr ;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      gn = RDFLiteral();
{if ("" != null) return asExpr(gn) ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:{
      gn = NumericLiteral();
{if ("" != null) return asExpr(gn) ;}
      break;
      }
    case TRUE:
    case FALSE:{
      gn = BooleanLiteral();
{if ("" != null) return asExpr(gn) ;}
      break;
      }
    case VAR1:
    case VAR2:{
      gn = Var();
{if ("" != null) return asExpr(gn) ;}
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr BrackettedExpression() throws ParseException {Expr expr ;
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(RPAREN);
{if ("" != null) return expr ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr BuiltInCall() throws ParseException {Expr expr ; Expr expr1 = null ; Expr expr2 = null ;
                       Node gn ; ExprList a ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AGG:
    case COUNT:
    case MIN:
    case MAX:
    case SUM:
    case AVG:
    case MEDIAN:
    case MODE:
    case STDEV:
    case STDEV_SAMP:
    case STDEV_POP:
    case VARIANCE:
    case VAR_SAMP:
    case VAR_POP:
    case SAMPLE:
    case GROUP_CONCAT:{
      expr = Aggregate();
{if ("" != null) return expr ;}
      break;
      }
    case STR:{
      jj_consume_token(STR);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Str(expr) ;}
      break;
      }
    case LANG:{
      jj_consume_token(LANG);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Lang(expr) ;}
      break;
      }
    case LANGMATCHES:{
      jj_consume_token(LANGMATCHES);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_LangMatches(expr1, expr2) ;}
      break;
      }
    case DTYPE:{
      jj_consume_token(DTYPE);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Datatype(expr) ;}
      break;
      }
    case BOUND:{
      jj_consume_token(BOUND);
      jj_consume_token(LPAREN);
      gn = Var();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Bound(new ExprVar(gn)) ;}
      break;
      }
    case IRI:{
      jj_consume_token(IRI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IRI(expr) ;}
      break;
      }
    case URI:{
      jj_consume_token(URI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_URI(expr) ;}
      break;
      }
    case BNODE:{
      jj_consume_token(BNODE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expr1 = Expression();
        jj_consume_token(RPAREN);
{if ("" != null) return new E_BNode(expr1) ;}
        break;
        }
      case NIL:{
        jj_consume_token(NIL);
{if ("" != null) return new E_BNode() ;}
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case RAND:{
      jj_consume_token(RAND);
      jj_consume_token(NIL);
{if ("" != null) return new E_Random() ;}
      break;
      }
    case ABS:{
      jj_consume_token(ABS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_NumAbs(expr1) ;}
      break;
      }
    case CEIL:{
      jj_consume_token(CEIL);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_NumCeiling(expr1) ;}
      break;
      }
    case FLOOR:{
      jj_consume_token(FLOOR);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_NumFloor(expr1) ;}
      break;
      }
    case ROUND:{
      jj_consume_token(ROUND);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_NumRound(expr1) ;}
      break;
      }
    case CONCAT:{
      jj_consume_token(CONCAT);
      a = ExpressionList();
{if ("" != null) return new E_StrConcat(a) ;}
      break;
      }
    case SUBSTR:{
      expr = SubstringExpression();
{if ("" != null) return expr ;}
      break;
      }
    case STRLEN:{
      jj_consume_token(STRLEN);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrLength(expr1) ;}
      break;
      }
    case REPLACE:{
      expr = StrReplaceExpression();
{if ("" != null) return expr ;}
      break;
      }
    case UCASE:{
      jj_consume_token(UCASE);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrUpperCase(expr1) ;}
      break;
      }
    case LCASE:{
      jj_consume_token(LCASE);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrLowerCase(expr1) ;}
      break;
      }
    case ENCODE_FOR_URI:{
      jj_consume_token(ENCODE_FOR_URI);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrEncodeForURI(expr1) ;}
      break;
      }
    case CONTAINS:{
      jj_consume_token(CONTAINS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrContains(expr1, expr2) ;}
      break;
      }
    case STRSTARTS:{
      jj_consume_token(STRSTARTS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrStartsWith(expr1, expr2) ;}
      break;
      }
    case STRENDS:{
      jj_consume_token(STRENDS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrEndsWith(expr1, expr2) ;}
      break;
      }
    case STRBEFORE:{
      jj_consume_token(STRBEFORE);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrBefore(expr1, expr2) ;}
      break;
      }
    case STRAFTER:{
      jj_consume_token(STRAFTER);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrAfter(expr1, expr2) ;}
      break;
      }
    case YEAR:{
      jj_consume_token(YEAR);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeYear(expr1) ;}
      break;
      }
    case MONTH:{
      jj_consume_token(MONTH);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeMonth(expr1) ;}
      break;
      }
    case DAY:{
      jj_consume_token(DAY);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeDay(expr1) ;}
      break;
      }
    case HOURS:{
      jj_consume_token(HOURS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeHours(expr1) ;}
      break;
      }
    case MINUTES:{
      jj_consume_token(MINUTES);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeMinutes(expr1) ;}
      break;
      }
    case SECONDS:{
      jj_consume_token(SECONDS);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeSeconds(expr1) ;}
      break;
      }
    case TIMEZONE:{
      jj_consume_token(TIMEZONE);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeTimezone(expr1) ;}
      break;
      }
    case TZ:{
      jj_consume_token(TZ);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_DateTimeTZ(expr1) ;}
      break;
      }
    case NOW:{
      jj_consume_token(NOW);
      jj_consume_token(NIL);
{if ("" != null) return new E_Now() ;}
      break;
      }
    case UUID:{
      jj_consume_token(UUID);
      jj_consume_token(NIL);
{if ("" != null) return new E_UUID() ;}
      break;
      }
    case STRUUID:{
      jj_consume_token(STRUUID);
      jj_consume_token(NIL);
{if ("" != null) return new E_StrUUID() ;}
      break;
      }
    case MD5:{
      jj_consume_token(MD5);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_MD5(expr1) ;}
      break;
      }
    case SHA1:{
      jj_consume_token(SHA1);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_SHA1(expr1) ;}
      break;
      }
    case SHA256:{
      jj_consume_token(SHA256);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_SHA256(expr1) ;}
      break;
      }
    case SHA384:{
      jj_consume_token(SHA384);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_SHA384(expr1) ;}
      break;
      }
    case SHA512:{
      jj_consume_token(SHA512);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_SHA512(expr1) ;}
      break;
      }
    case VERSION:{
      jj_consume_token(VERSION);
      jj_consume_token(NIL);
{if ("" != null) return new E_Version();}
      break;
      }
    case COALESCE:{
      jj_consume_token(COALESCE);
      a = ExpressionList();
{if ("" != null) return new E_Coalesce(a) ;}
      break;
      }
    case CALL:{
      jj_consume_token(CALL);
a = new ExprList() ;
      jj_consume_token(LPAREN);
      expr = Expression();
a.add(expr) ;
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[150] = jj_gen;
          break label_42;
        }
        jj_consume_token(COMMA);
        expr = Expression();
a.add(expr) ;
      }
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Call(a) ;}
      break;
      }
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(COMMA);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_Conditional(expr, expr1, expr2) ;}
      break;
      }
    case STRLANG:{
      jj_consume_token(STRLANG);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrLang(expr1, expr2) ;}
      break;
      }
    case STRDT:{
      jj_consume_token(STRDT);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_StrDatatype(expr1, expr2) ;}
      break;
      }
    case SAME_TERM:{
      jj_consume_token(SAME_TERM);
      jj_consume_token(LPAREN);
      expr1 = Expression();
      jj_consume_token(COMMA);
      expr2 = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_SameTerm(expr1, expr2) ;}
      break;
      }
    case IS_IRI:{
      jj_consume_token(IS_IRI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IsIRI(expr) ;}
      break;
      }
    case IS_URI:{
      jj_consume_token(IS_URI);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IsURI(expr) ;}
      break;
      }
    case IS_BLANK:{
      jj_consume_token(IS_BLANK);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IsBlank(expr) ;}
      break;
      }
    case IS_LITERAL:{
      jj_consume_token(IS_LITERAL);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IsLiteral(expr) ;}
      break;
      }
    case IS_NUMERIC:{
      jj_consume_token(IS_NUMERIC);
      jj_consume_token(LPAREN);
      expr = Expression();
      jj_consume_token(RPAREN);
{if ("" != null) return new E_IsNumeric(expr) ;}
      break;
      }
    case REGEX:{
      expr = RegexExpression();
{if ("" != null) return expr ;}
      break;
      }
    case EXISTS:{
      expr = ExistsFunc();
{if ("" != null) return expr ;}
      break;
      }
    case NOT:{
      expr = NotExistsFunc();
{if ("" != null) return expr ;}
      break;
      }
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expr RegexExpression() throws ParseException {Expr expr ; Expr patExpr = null ; Expr flagsExpr = null ;
    jj_consume_token(REGEX);
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(COMMA);
    patExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      flagsExpr = Expression();
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return new E_Regex(expr, patExpr, flagsExpr) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr SubstringExpression() throws ParseException {Expr expr1 ; Expr expr2 = null ; Expr expr3 = null ;
    jj_consume_token(SUBSTR);
    jj_consume_token(LPAREN);
    expr1 = Expression();
    jj_consume_token(COMMA);
    expr2 = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      expr3 = Expression();
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return new E_StrSubstring(expr1, expr2, expr3) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr StrReplaceExpression() throws ParseException {Expr expr1 ; Expr expr2 = null ; Expr expr3 = null ; Expr expr4 = null ;
    jj_consume_token(REPLACE);
    jj_consume_token(LPAREN);
    expr1 = Expression();
    jj_consume_token(COMMA);
    expr2 = Expression();
    jj_consume_token(COMMA);
    expr3 = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      expr4 = Expression();
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
{if ("" != null) return new E_StrReplace(expr1,expr2,expr3,expr4) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr ExistsFunc() throws ParseException {Element el ;
    jj_consume_token(EXISTS);
    el = GroupGraphPattern();
{if ("" != null) return createExprExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr NotExistsFunc() throws ParseException {Element el ;
    jj_consume_token(NOT);
    jj_consume_token(EXISTS);
    el = GroupGraphPattern();
{if ("" != null) return createExprNotExists(el) ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr Aggregate() throws ParseException {Aggregator agg = null ; String sep = null ;
                     Expr expr = null ; Expr expr2 = null ;
                     boolean distinct = false ;
                     ExprList ordered = new ExprList() ;
                     Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COUNT:{
      t = jj_consume_token(COUNT);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
        break;
        }
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:
      case VAR1:
      case VAR2:
      case EXISTS:
      case NOT:
      case AGG:
      case COUNT:
      case MIN:
      case MAX:
      case SUM:
      case AVG:
      case MEDIAN:
      case MODE:
      case STDEV:
      case STDEV_SAMP:
      case STDEV_POP:
      case VARIANCE:
      case VAR_SAMP:
      case VAR_POP:
      case SAMPLE:
      case GROUP_CONCAT:
      case BOUND:
      case COALESCE:
      case IF:
      case BNODE:
      case IRI:
      case URI:
      case CALL:
      case STR:
      case STRLANG:
      case STRDT:
      case DTYPE:
      case LANG:
      case LANGMATCHES:
      case IS_URI:
      case IS_IRI:
      case IS_BLANK:
      case IS_LITERAL:
      case IS_NUMERIC:
      case REGEX:
      case SAME_TERM:
      case RAND:
      case ABS:
      case CEIL:
      case FLOOR:
      case ROUND:
      case CONCAT:
      case SUBSTR:
      case STRLEN:
      case REPLACE:
      case UCASE:
      case LCASE:
      case ENCODE_FOR_URI:
      case CONTAINS:
      case STRSTARTS:
      case STRENDS:
      case STRBEFORE:
      case STRAFTER:
      case YEAR:
      case MONTH:
      case DAY:
      case HOURS:
      case MINUTES:
      case SECONDS:
      case TIMEZONE:
      case TZ:
      case NOW:
      case UUID:
      case STRUUID:
      case VERSION:
      case MD5:
      case SHA1:
      case SHA256:
      case SHA384:
      case SHA512:
      case TRUE:
      case FALSE:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case INTEGER_POSITIVE:
      case DECIMAL_POSITIVE:
      case DOUBLE_POSITIVE:
      case INTEGER_NEGATIVE:
      case DECIMAL_NEGATIVE:
      case DOUBLE_NEGATIVE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case BANG:
      case PLUS:
      case MINUS:{
        expr = Expression();
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
if ( expr == null ) { agg = AggregatorFactory.createCount(distinct) ; }
      if ( expr != null ) { agg = AggregatorFactory.createCountExpr(distinct, expr) ; }
      break;
      }
    case SUM:{
      t = jj_consume_token(SUM);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createSum(distinct, expr) ;
      break;
      }
    case MIN:{
      t = jj_consume_token(MIN);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createMin(distinct, expr) ;
      break;
      }
    case MAX:{
      t = jj_consume_token(MAX);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createMax(distinct, expr) ;
      break;
      }
    case AVG:{
      t = jj_consume_token(AVG);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createAvg(distinct, expr) ;
      break;
      }
    case MEDIAN:{
      t = jj_consume_token(MEDIAN);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createMedian(distinct, expr) ;
      break;
      }
    case MODE:{
      t = jj_consume_token(MODE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createMode(distinct, expr) ;
      break;
      }
    case SAMPLE:{
      t = jj_consume_token(SAMPLE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createSample(distinct, expr) ;
      break;
      }
    case GROUP_CONCAT:{
      t = jj_consume_token(GROUP_CONCAT);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        t = jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      expr = Expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        if (jj_2_5(2)) {
          jj_consume_token(SEMICOLON);
          jj_consume_token(SEPARATOR);
          jj_consume_token(EQ);
          sep = String();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            jj_consume_token(ORDER);
            jj_consume_token(BY);
            expr2 = Expression();
ordered.add(expr2) ;
            break;
            }
          default:
            jj_la1[165] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            jj_consume_token(ORDER);
            jj_consume_token(BY);
            expr2 = Expression();
ordered.add(expr2) ;
            break;
            }
          default:
            jj_la1[166] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createGroupConcat(distinct, expr, sep, ordered) ;
      break;
      }
    case STDEV:{
      t = jj_consume_token(STDEV);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.stdev, distinct, expr) ;
      break;
      }
    case STDEV_SAMP:{
      t = jj_consume_token(STDEV_SAMP);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.stdev_samp, distinct, expr) ;
      break;
      }
    case STDEV_POP:{
      t = jj_consume_token(STDEV_POP);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.stdev_pop, distinct, expr) ;
      break;
      }
    case VARIANCE:{
      t = jj_consume_token(VARIANCE);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.variance, distinct, expr) ;
      break;
      }
    case VAR_SAMP:{
      t = jj_consume_token(VAR_SAMP);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.var_samp, distinct, expr) ;
      break;
      }
    case VAR_POP:{
      t = jj_consume_token(VAR_POP);
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
distinct = true ;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        ;
      }
      expr = Expression();
      jj_consume_token(RPAREN);
agg = AggregatorFactory.createCustom(AggURI.var_pop, distinct, expr) ;
      break;
      }
    case AGG:{
      t = jj_consume_token(AGG);
String iri ;
      iri = iri();
Args a = new Args() ;
      a = ArgList();
agg = AggregatorFactory.createCustom(iri, a) ;
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if ( ! getAllowAggregatesInExpressions() )
           throwParseException("Aggregate expression not legal at this point",
                                t.beginLine, t.beginColumn) ;
Expr exprAgg = getQuery().allocAggregate(agg) ;
    {if ("" != null) return exprAgg ;}
    throw new Error("Missing return statement in function");
  }

  final public Expr iriOrFunction() throws ParseException {String iri ; Args a = null ;
    iri = iri();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:
    case NIL:{
      a = ArgList();
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      ;
    }
if ( a == null )
       {if ("" != null) return asExpr(createNode(iri)) ;}
    if ( AggregateRegistry.isRegistered(iri) ) {
         if ( ! getAllowAggregatesInExpressions() )
            throwParseException("Aggregate expression not legal at this point : "+iri, -1, -1) ;
         Aggregator agg = AggregatorFactory.createCustom(iri, a) ;
         Expr exprAgg = getQuery().allocAggregate(agg) ;
         {if ("" != null) return exprAgg ;}
      }
    {if ("" != null) return new E_Function(iri, a) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node RDFLiteral() throws ParseException {Token t ; String lex = null ;
    lex = String();
String lang = null ; String uri = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGTAG:
    case DATATYPE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LANGTAG:{
        t = jj_consume_token(LANGTAG);
lang = stripChars(t.image, 1) ;
        break;
        }
      case DATATYPE:{
        jj_consume_token(DATATYPE);
        uri = iri();
        break;
        }
      default:
        jj_la1[176] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
{if ("" != null) return createLiteral(lex, lang, uri) ;}
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteral() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      n = NumericLiteralUnsigned();
      break;
      }
    case INTEGER_POSITIVE:
    case DECIMAL_POSITIVE:
    case DOUBLE_POSITIVE:{
      n = NumericLiteralPositive();
      break;
      }
    case INTEGER_NEGATIVE:
    case DECIMAL_NEGATIVE:
    case DOUBLE_NEGATIVE:{
      n = NumericLiteralNegative();
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralUnsigned() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:{
      t = jj_consume_token(INTEGER);
{if ("" != null) return createLiteralInteger(t.image) ;}
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
{if ("" != null) return createLiteralDecimal(t.image) ;}
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
{if ("" != null) return createLiteralDouble(t.image) ;}
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralPositive() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_POSITIVE:{
      t = jj_consume_token(INTEGER_POSITIVE);
{if ("" != null) return createLiteralInteger(t.image) ;}
      break;
      }
    case DECIMAL_POSITIVE:{
      t = jj_consume_token(DECIMAL_POSITIVE);
{if ("" != null) return createLiteralDecimal(t.image) ;}
      break;
      }
    case DOUBLE_POSITIVE:{
      t = jj_consume_token(DOUBLE_POSITIVE);
{if ("" != null) return createLiteralDouble(t.image) ;}
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteralNegative() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_NEGATIVE:{
      t = jj_consume_token(INTEGER_NEGATIVE);
{if ("" != null) return createLiteralInteger(t.image) ;}
      break;
      }
    case DECIMAL_NEGATIVE:{
      t = jj_consume_token(DECIMAL_NEGATIVE);
{if ("" != null) return createLiteralDecimal(t.image) ;}
      break;
      }
    case DOUBLE_NEGATIVE:{
      t = jj_consume_token(DOUBLE_NEGATIVE);
{if ("" != null) return createLiteralDouble(t.image) ;}
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return XSD_TRUE ;}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return XSD_FALSE ;}
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String String() throws ParseException {Token t ; String lex ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG1:{
      t = jj_consume_token(STRING_LITERAL_LONG1);
lex = stripQuotes3(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG2:{
      t = jj_consume_token(STRING_LITERAL_LONG2);
lex = stripQuotes3(t.image) ;
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
lex = unescapeStr(lex, t.beginLine, t.beginColumn) ;
      {if ("" != null) return lex ;}
    throw new Error("Missing return statement in function");
  }

  final public String iri() throws ParseException {String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:{
      iri = IRIREF();
{if ("" != null) return iri ;}
      break;
      }
    case PNAME_NS:
    case PNAME_LN:{
      iri = PrefixedName();
{if ("" != null) return iri ;}
      break;
      }
    default:
      jj_la1[184] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String PrefixedName() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PNAME_LN:{
      t = jj_consume_token(PNAME_LN);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case PNAME_NS:{
      t = jj_consume_token(PNAME_NS);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNode() throws ParseException {Token t = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLANK_NODE_LABEL:{
      t = jj_consume_token(BLANK_NODE_LABEL);
{if ("" != null) return createBNode(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case ANON:{
      t = jj_consume_token(ANON);
{if ("" != null) return createBNode(t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String IRIREF() throws ParseException {Token t ;
    t = jj_consume_token(IRIref);
{if ("" != null) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_3R_128()
 {
    if (jj_scan_token(STDEV)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_scan_token(SEPARATOR)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_scan_token(GROUP_CONCAT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(SAMPLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(MODE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(MEDIAN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(AVG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(SUM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_44()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) return true;
    }
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_scan_token(REPLACE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(SUBSTR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_scan_token(REGEX)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_scan_token(IS_NUMERIC)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(IS_LITERAL)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(IS_BLANK)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_scan_token(IS_URI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(IS_IRI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(SAME_TERM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_scan_token(STRDT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_scan_token(STRLANG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(CALL)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(COALESCE)) return true;
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(VERSION)) return true;
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(SHA512)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(SHA384)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(SHA256)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(SHA1)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(MD5)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(STRUUID)) return true;
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(UUID)) return true;
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(NOW)) return true;
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(TZ)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(TIMEZONE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(SECONDS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(MINUTES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(HOURS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(DAY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(MONTH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(YEAR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(STRAFTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(STRBEFORE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(STRENDS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(STRSTARTS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_scan_token(CONTAINS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_scan_token(ENCODE_FOR_URI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(LCASE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(UCASE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_scan_token(STRLEN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_scan_token(ROUND)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(FLOOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(CEIL)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_scan_token(ABS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_scan_token(RAND)) return true;
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(BNODE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(URI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(IRI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(BOUND)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_scan_token(DTYPE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_scan_token(LANGMATCHES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(LANG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(STR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(IRIref)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(ANON)) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    }
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_scan_token(BLANK_NODE_LABEL)) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(PNAME_NS)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(PNAME_LN)) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    }
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(STRING_LITERAL_LONG2)) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_scan_token(STRING_LITERAL_LONG1)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(STRING_LITERAL2)) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_scan_token(STRING_LITERAL1)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(PREFIX)) return true;
    if (jj_scan_token(PNAME_NS)) return true;
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) return true;
    }
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_scan_token(BASE)) return true;
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_scan_token(DOUBLE_NEGATIVE)) return true;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_scan_token(DECIMAL_NEGATIVE)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_scan_token(INTEGER_NEGATIVE)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  private boolean jj_3R_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_103()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(DOUBLE_POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_scan_token(DECIMAL_POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(INTEGER_POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(DECIMAL)) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) return true;
    }
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(LT2)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(AGG)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(VAR_POP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(VAR_SAMP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(VARIANCE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(STDEV_POP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(STDEV_SAMP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ARQParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[187];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x1e400000,0x200,0x300000,0x300000,0x0,0x1800000,0x1800000,0x1c00,0x0,0xdc00,0xdc00,0xdc00,0x0,0x0,0x0,0xdc00,0xdc00,0x0,0x0,0x0,0x0,0x0,0xc000,0x1c00,0x0,0x0,0x0,0x80000000,0x60000000,0xdc00,0x0,0xdc00,0x1c00,0xdc00,0x0,0xdc00,0xdc00,0x40000000,0x20000000,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0x0,0x1c00,0x0,0xfc00,0x0,0x0,0xfc00,0xfc00,0xfc00,0x0,0x0,0xfc00,0x0,0xfc00,0x0,0x400000,0xfc00,0x0,0x0,0xfc00,0xfc00,0x0,0x0,0x0,0xc000,0x1c00,0xc000,0x0,0x0,0x1c00,0x0,0x1c00,0x0,0x1c00,0x800000,0x0,0x0,0x0,0x0,0x0,0xfc00,0x8dc00,0x0,0x8dc00,0x8dc00,0x0,0xfc00,0x88dc00,0x88dc00,0x0,0x88dc00,0x88dc00,0x0,0x0,0x0,0x0,0x0,0x881c00,0x0,0x0,0x0,0x0,0x881c00,0x0,0x81c00,0x81c00,0x81c00,0x81c00,0x0,0x0,0xfc00,0xfc00,0xfc00,0xfc00,0xfc00,0xdc00,0xfc00,0xc000,0x3c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdc00,0xdc00,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0xdc00,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x0,0x0,0x0,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x0,0x0,0x10000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0x1800,0x2000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x80000,0xff860000,0xff860000,0xff860000,0x40,0x40,0xc0,0x0,0x0,0x40,0x80,0x40,0x40,0x0,0x0,0x20,0x80,0x100000,0x200000,0x0,0x0,0xff860000,0x80000,0xff860000,0xff860000,0xff860018,0x18,0xff860000,0xff860018,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x200,0x200,0x220,0x0,0x200,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x7f602,0x0,0x0,0x0,0x0,0x7f602,0x0,0x0,0x4,0x0,0x0,0x0,0x4,0x0,0x4,0x800,0xff860000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff860000,0xff860000,0x0,0x0,0xff860000,0x0,0x0,0x0,0x0,0xff860000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff97b7f,0xfff97b7f,0xfff97b7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff97b7f,0x0,0xfff97b7f,0xfff97b7f,0xfff97b7f,0x0,0xfff97b7f,0xfff97b7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff97b7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x60000,0x0,0x60000,0x60000,0x0,0x0,0x0,0x0,0x0,0x60000,0x0,0x0,0x0,0x0,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfff97b7f,0xfff97b7f,0x0,0x0,0xfff97b7f,0x0,0x0,0x0,0x0,0xfff97b7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x7fffffff,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x7fffffff,0x7fffffff,0x7fffffff,0x0,0x7fffffff,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffffff,0x7fffffff,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x7fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000018,0x0,0xf800001f,0xf800001f,0xf800001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000018,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x7,0x7,0x7,0x0,0x7,0x7,0x0,0x0,0x0,0x0,0x0,0x109ffc0,0x109ffc0,0x40000,0x100000,0x40000,0x40000,0x40000,0x40000,0x40000,0x40000,0x1000000,0x40,0xc0,0x2000000,0x0,0x0,0x400000,0xc00000,0xf8000018,0x0,0x0,0xf8000018,0xf8000018,0xf8000018,0x0,0x0,0xf8000018,0x0,0xf8000018,0x0,0x0,0xf8000018,0x0,0x0,0xf8000018,0xf8000018,0x0,0x0,0x40000,0x0,0xf8000018,0x0,0x0,0x0,0xf8000018,0x0,0xf8000018,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000018,0x0,0x0,0x0,0x0,0x0,0xf8000018,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000018,0xf8000018,0xf8000018,0xf8000018,0xf8000018,0x0,0x0,0x0,0xf8000018,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0x0,0x0,0xc0000000,0x0,0x0,0xf800001f,0xf800001f,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0xf800001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x38000000,0xc0000000,0x0,0x18,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0f,0x0,0x1f0f,0x1f0f,0x1f0f,0x0,0x0,0x8000,0x0,0x0,0x0,0x8000,0x0,0x0,0x200000,0xf0f,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x1000,0x1000,0x1000,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400a5f0f,0x0,0x400000,0x400a5f0f,0x400a5f0f,0x400a5f0f,0x8000,0x400000,0x400a5f0f,0x0,0x400a5f0f,0x400000,0x0,0x400a5f0f,0x8000,0x400000,0x400a5f0f,0x400a5f0f,0x400000,0x8000,0x0,0x5000,0x40000f0f,0x0,0x5000,0x5000,0x40000f0f,0x5000,0x40000f0f,0x0,0x1000,0x0,0x200000,0x5000,0x200000,0x5000,0x400000,0x400a5f0f,0x0,0x100000,0x0,0x0,0x200000,0x400a5f0f,0x80001000,0x80001000,0x100000,0x80001000,0x80001000,0x200000,0x0,0x0,0x0,0x8000,0x80001000,0x10000,0x210000,0x200000,0x8000,0x80001000,0x0,0x0,0x1000,0x0,0x0,0x21000,0x21000,0x400a5f0f,0x400a5f0f,0x400a5f0f,0x400a5f0f,0x40084f0f,0x0,0x80000,0x0,0x84f0f,0x0,0x0,0x1f800000,0x1f800000,0xf,0xf,0x0,0x0,0xf,0x0,0x0,0x80001f0f,0x1f0f,0x5000,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x80001f0f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5000,0x0,0x0,0xf,0x0,0x1,0xe,0x0,0xf00,0x0,0x0,0x80000,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x1000,0x1000,0x0,0x800,0x1080,0x1080,0x8050,0x1000,0x0,0x0,0x50,0x8050,0x0,0x800,0x1000,0x1000,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x8,0x0,0x0,0x30,0x0,0xc0,0xc0,0x30,0xc0,0xc0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[5];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ARQParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ARQParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ARQParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ARQParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new ARQParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ARQParser(ARQParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ARQParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 187; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[219];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 187; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 219; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 5; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

 }
