/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.iri;

import junit.framework.TestSuite;

import org.apache.jena.iri.IRI ;
import org.xml.sax.Attributes;


public class TestMERelativize extends TestMoreExamples {
    static int count;
    public TestMERelativize(Attributes att, TestSuite suite) {
        super("relativize"+ (++count),att,suite);
    }

    @Override
    IRI computeIRI() {
        IRI base = ((TestMoreExamples)parent.testAt(0)).getIRI();
        IRI rel = ((TestMoreExamples)parent.testAt(2)).getIRI();
        return base.relativize(rel, TestCreator.RelativizeFlags);
    }
    
    @Override
    public void runTest() {
    	if (!"true".equals(att.get("same"))) {
    		super.runTest();
    	} else {
    		assertEquals(computeIRI(),
    				((TestMoreExamples)parent.testAt(1)).getIRI());
    	}
    	
    }
}
