/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.SSEWriteLib;
import org.apache.jena.sparql.sse.writers.WriterNode;

public class WriterTable {
    public static void output(IndentedWriter out, Table table, SerializationContext sCxt) {
        SSEWriteLib.start(out, "table", -1);
        WriterNode.outputVars(out, table.getVars(), sCxt);
        out.println();
        WriterTable.outputPlain(out, table, sCxt);
        SSEWriteLib.finish(out, "table");
    }

    public static void outputPlain(IndentedWriter out, Table table, SerializationContext sCxt) {
        QueryIterator qIter = table.iterator(null);
        while (qIter.hasNext()) {
            Binding b = qIter.nextBinding();
            WriterTable.output(out, b, sCxt);
            out.println();
        }
        qIter.close();
    }

    public static void output(IndentedWriter out, Binding binding, SerializationContext sCxt) {
        SSEWriteLib.start(out, "row", -2);
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = binding.get(v);
            out.print(" ");
            SSEWriteLib.start2(out);
            WriterNode.output(out, (Node)v, sCxt);
            out.print(" ");
            WriterNode.output(out, n, sCxt);
            SSEWriteLib.finish2(out);
        }
        SSEWriteLib.finish(out, "row");
    }
}

