/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.FinderUtil;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.StandardValidityReport;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.FBRuleReasoner;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RulePreprocessHook;
import org.apache.jena.reasoner.rulesys.impl.BBRuleContext;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngineIFactory;
import org.apache.jena.reasoner.rulesys.impl.LPBRuleEngine;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.reasoner.rulesys.impl.TempNodeCache;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveEngine;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.util.OneToManyMap;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.UniqueFilter;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBRuleInfGraph
extends BasicForwardRuleInfGraph
implements BackwardRuleInfGraphI {
    protected BBRuleContext context;
    protected Finder dataFind;
    protected LPBRuleEngine bEngine;
    protected List<Rule> rawRules;
    protected List<Rule> rules;
    public static boolean useRETE = true;
    protected boolean useTGCCaching = false;
    protected TransitiveEngine transitiveEngine;
    protected List<RulePreprocessHook> preprocessorHooks;
    protected TempNodeCache tempNodecache;
    protected Set<Node> hiddenNodes;
    protected HashMap<Node, List<RDFDatatype>> dtRange = null;
    protected boolean requestDatatypeRangeValidation = false;
    static Logger logger = LoggerFactory.getLogger(FBRuleInfGraph.class);

    public FBRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(reasoner, schema);
        this.constructorInit(schema);
    }

    public FBRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema) {
        super(reasoner, rules, schema);
        this.rawRules = rules;
        this.constructorInit(schema);
    }

    public FBRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema, Graph data) {
        super(reasoner, rules, schema, data);
        this.rawRules = rules;
        this.constructorInit(schema);
    }

    private void constructorInit(Graph schema) {
        this.initLP(schema);
        this.tempNodecache = new TempNodeCache(this);
        if (JenaParameters.enableFilteringOfHiddenInfNodes) {
            this.hiddenNodes = new HashSet<Node>();
            if (schema != null && schema instanceof FBRuleInfGraph) {
                this.hiddenNodes.addAll(((FBRuleInfGraph)schema).hiddenNodes);
            }
        }
    }

    @Override
    protected void instantiateRuleEngine(List<Rule> rules) {
        this.engine = FRuleEngineIFactory.getInstance().createFRuleEngineI(this, rules, useRETE);
    }

    private void initLP(Graph schema) {
        if (schema != null && schema instanceof FBRuleInfGraph) {
            LPRuleStore newStore = new LPRuleStore();
            newStore.addAll(((FBRuleInfGraph)schema).bEngine.getRuleStore());
            this.bEngine = new LPBRuleEngine(this, newStore);
        } else {
            this.bEngine = new LPBRuleEngine(this);
        }
    }

    public void setUseTGCCache() {
        this.useTGCCaching = true;
        this.resetTGCCache();
    }

    private void resetTGCCache() {
        this.transitiveEngine = this.schemaGraph != null ? new TransitiveEngine(((FBRuleInfGraph)this.schemaGraph).transitiveEngine) : new TransitiveEngine(new TransitiveGraphCache(ReasonerVocabulary.directSubClassOf.asNode(), RDFS.subClassOf.asNode()), new TransitiveGraphCache(ReasonerVocabulary.directSubPropertyOf.asNode(), RDFS.subPropertyOf.asNode()));
    }

    @Override
    public ExtendedIterator<Triple> findDataMatches(Node subject, Node predicate, Node object) {
        return this.dataFind.find(new TriplePattern(subject, predicate, object));
    }

    @Override
    public ExtendedIterator<Triple> findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    @Override
    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of builtin in rule " + String.valueOf(rule));
    }

    @Override
    public void addBRule(Rule brule) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding rule " + String.valueOf(brule));
        }
        this.bEngine.addRule(brule);
        this.bEngine.reset();
    }

    @Override
    public void deleteBRule(Rule brule) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting rule " + String.valueOf(brule));
        }
        this.bEngine.deleteRule(brule);
        this.bEngine.reset();
    }

    public void addBRules(List<Rule> rules) {
        for (Rule rule : rules) {
            this.bEngine.addRule(rule);
        }
        this.bEngine.reset();
    }

    public List<Rule> getBRules() {
        return this.bEngine.getAllRules();
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setTabled(Node predicate) {
        this.bEngine.tablePredicate(predicate);
        if (this.traceOn) {
            logger.info("LP TABLE " + String.valueOf(predicate));
        }
    }

    private Object getForwardRuleStore() {
        return this.engine.getRuleStore();
    }

    @Override
    public void addDeduction(Triple t) {
        this.getCurrentDeductionsGraph().add(t);
        if (this.useTGCCaching) {
            this.transitiveEngine.add(t);
        }
    }

    @Override
    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    public void addRuleDuringPrepare(Rule rule) {
        if (this.rules == this.rawRules) {
            this.rules = new ArrayList<Rule>(this.rawRules);
            this.instantiateRuleEngine(this.rules);
        }
        this.rules.add(rule);
    }

    public void addPreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new ArrayList<RulePreprocessHook>();
        }
        this.preprocessorHooks.add(hook);
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared()) {
            return;
        }
        this.setPreparedState(true);
        this.rules = this.rawRules;
        Graph data = null;
        if (this.fdata != null) {
            data = this.fdata.getGraph();
        }
        if (this.fdeductions != null) {
            Graph oldDeductions = this.fdeductions.getGraph();
            oldDeductions.clear();
        } else {
            this.fdeductions = new FGraph(this.createDeductionsGraph());
        }
        this.dataFind = data == null ? this.fdeductions : FinderUtil.cascade(this.fdeductions, this.fdata);
        Finder dataSource = this.fdata;
        if (this.useTGCCaching) {
            this.resetTGCCache();
            if (this.schemaGraph != null) {
                if (this.transitiveEngine.checkOccurance(TransitiveReasoner.subPropertyOf, data) || this.transitiveEngine.checkOccurance(TransitiveReasoner.subClassOf, data) || this.transitiveEngine.checkOccurance(RDFS.domain.asNode(), data) || this.transitiveEngine.checkOccurance(RDFS.range.asNode(), data)) {
                    this.transitiveEngine.insert(((FBRuleInfGraph)this.schemaGraph).fdata, this.fdata);
                }
            } else if (data != null) {
                this.transitiveEngine.insert(null, this.fdata);
            }
            for (Rule rule : this.rules) {
                if (rule.bodyLength() != 0) continue;
                for (int j = 0; j < rule.headLength(); ++j) {
                    ClauseEntry head = rule.getHeadElement(j);
                    if (!(head instanceof TriplePattern)) continue;
                    TriplePattern h = (TriplePattern)head;
                    this.transitiveEngine.add(h.asTriple());
                }
            }
            this.transitiveEngine.setCaching(true, true);
            this.dataFind = FinderUtil.cascade(this.dataFind, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
            dataSource = FinderUtil.cascade(dataSource, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
        }
        this.bEngine.deleteAllRules();
        if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
            Graph inserts = GraphMemFactory.createGraphMem();
            for (RulePreprocessHook hook : this.preprocessorHooks) {
                hook.run(this, this.dataFind, inserts);
            }
            if (inserts.size() > 0) {
                FGraph fGraph = new FGraph(inserts);
                dataSource = FinderUtil.cascade(this.fdata, fGraph);
                this.dataFind = FinderUtil.cascade(this.dataFind, fGraph);
            }
        }
        boolean rulesLoaded = false;
        if (this.schemaGraph != null) {
            Graph graph = ((InfGraph)this.schemaGraph).getRawGraph();
            if (graph != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, new FGraph(graph));
            }
            rulesLoaded = this.preloadDeductions(this.schemaGraph);
        }
        if (rulesLoaded) {
            this.engine.fastInit(dataSource);
        } else {
            this.addBRules(FBRuleInfGraph.extractPureBackwardRules(this.rules));
            this.engine.init(true, dataSource);
        }
        this.context = new BBRuleContext(this);
    }

    @Override
    public void rebind() {
        ++this.version;
        if (this.bEngine != null) {
            this.bEngine.reset();
        }
        this.setPreparedState(false);
    }

    public void rebindAll() {
        this.rawRules = ((FBRuleReasoner)this.reasoner).getRules();
        this.instantiateRuleEngine(this.rawRules);
        this.rebind();
    }

    @Override
    public void setTraceOn(boolean state) {
        super.setTraceOn(state);
        this.bEngine.setTraceOn(state);
    }

    @Override
    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.bEngine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    @Override
    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        this.requirePrepared();
        ExtendedIterator<Triple> result = this.bEngine.find(pattern).filterKeep(new UniqueFilter());
        if (continuation != null) {
            result = result.andThen(continuation.find(pattern));
        }
        if (this.filterFunctors) {
            return result.filterDrop(t -> this.accept(t));
        }
        return result;
    }

    public ExtendedIterator<Triple> findFull(TriplePattern pattern) {
        this.checkOpen();
        this.requirePrepared();
        return this.bEngine.find(pattern).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    @Override
    public synchronized void reset() {
        ++this.version;
        this.bEngine.reset();
        this.setPreparedState(false);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.fdata.getGraph().add(t);
        if (this.useTGCCaching && this.transitiveEngine.add(t)) {
            this.setPreparedState(false);
        }
        if (this.isPrepared()) {
            boolean needReset = false;
            if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
                if (this.preprocessorHooks.size() > 1) {
                    for (RulePreprocessHook preprocessorHook : this.preprocessorHooks) {
                        if (!preprocessorHook.needsRerun(this, t)) continue;
                        needReset = true;
                        break;
                    }
                } else {
                    needReset = this.preprocessorHooks.get(0).needsRerun(this, t);
                }
            }
            if (needReset) {
                this.setPreparedState(false);
            } else {
                this.engine.add(t);
            }
        }
        this.bEngine.reset();
    }

    @Override
    public void performDelete(Triple t) {
        ++this.version;
        this.fdata.getGraph().delete(t);
        if (this.useTGCCaching && this.transitiveEngine.delete(t)) {
            if (this.isPrepared()) {
                this.bEngine.deleteAllRules();
            }
            this.setPreparedState(false);
        }
        if (this.isPrepared()) {
            this.bEngine.deleteAllRules();
            this.setPreparedState(false);
        }
        this.bEngine.reset();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.bEngine.halt();
            this.bEngine = null;
            this.transitiveEngine = null;
            super.close();
        }
    }

    @Override
    public ValidityReport validate() {
        this.checkOpen();
        StandardValidityReport report = new StandardValidityReport();
        Triple validateOn = Triple.create(NodeFactory.createBlankNode(), ReasonerVocabulary.RB_VALIDATION.asNode(), Functor.makeFunctorNode("on", new Node[0]));
        this.requirePrepared();
        this.engine.add(validateOn);
        TriplePattern pattern = new TriplePattern(null, ReasonerVocabulary.RB_VALIDATION_REPORT.asNode(), null);
        Model forConversion = ModelFactory.createDefaultModel();
        ExtendedIterator<Triple> i = this.findFull(pattern);
        while (i.hasNext()) {
            Object rVal;
            Triple t = (Triple)i.next();
            Node rNode = t.getObject();
            if (!rNode.isLiteral() || !((rVal = rNode.getLiteralValue()) instanceof Functor)) continue;
            Functor rFunc = (Functor)rVal;
            StringBuilder description = new StringBuilder();
            String nature = rFunc.getName();
            String type = rFunc.getArgs()[0].toString();
            String text = rFunc.getArgs()[1].toString();
            description.append(text + "\n");
            description.append("Culprit = " + PrintUtil.print(t.getSubject()) + "\n");
            for (int j = 2; j < rFunc.getArgLength(); ++j) {
                description.append("Implicated node: " + PrintUtil.print(rFunc.getArgs()[j]) + "\n");
            }
            RDFNode culprit = forConversion.asRDFNode(t.getSubject());
            report.add(nature.equalsIgnoreCase("error"), type, description.toString(), culprit);
        }
        if (this.requestDatatypeRangeValidation) {
            this.performDatatypeRangeValidation(report);
        }
        return report;
    }

    public void setDatatypeRangeValidation(boolean on) {
        this.requestDatatypeRangeValidation = on;
    }

    protected void performDatatypeRangeValidation(StandardValidityReport report) {
        HashMap<Node, List<RDFDatatype>> dtRange = this.getDTRange();
        for (Node prop : dtRange.keySet()) {
            ExtendedIterator<Triple> i = this.find(null, prop, null);
            while (i.hasNext()) {
                Triple triple = (Triple)i.next();
                report.add(this.checkLiteral(prop, triple));
            }
        }
    }

    public ValidityReport.Report checkLiteral(Node prop, Triple triple) {
        Node value = triple.getObject();
        List<RDFDatatype> range = this.getDTRange().get(prop);
        if (range != null) {
            if (value.isBlank()) {
                return null;
            }
            if (!value.isLiteral()) {
                return new ValidityReport.Report(true, "dtRange", "Property " + String.valueOf(prop) + " has a typed range but was given a non literal value " + String.valueOf(value));
            }
            LiteralLabel ll = value.getLiteral();
            for (RDFDatatype dt : range) {
                if (dt.isValidLiteral(ll)) continue;
                return new ValidityReport.Report(true, "dtRange", "Property " + String.valueOf(prop) + " has a typed range " + String.valueOf(dt) + "that is not compatible with " + String.valueOf(value), triple);
            }
        }
        return null;
    }

    protected HashMap<Node, List<RDFDatatype>> getDTRange() {
        if (this.dtRange == null) {
            this.dtRange = new HashMap();
            ExtendedIterator<Triple> i = this.find(null, RDFS.range.asNode(), null);
            while (i.hasNext()) {
                RDFDatatype dt;
                Triple triple = (Triple)i.next();
                Node prop = triple.getSubject();
                Node rangeValue = triple.getObject();
                if (!rangeValue.isURI() || (dt = TypeMapper.getInstance().getTypeByName(rangeValue.getURI())) == null) continue;
                List<RDFDatatype> range = this.dtRange.get(prop);
                if (range == null) {
                    range = new ArrayList<RDFDatatype>();
                    this.dtRange.put(prop, range);
                }
                range.add(dt);
            }
        }
        return this.dtRange;
    }

    private static List<Rule> extractPureBackwardRules(List<Rule> rules) {
        ArrayList<Rule> bRules = new ArrayList<Rule>();
        for (Rule r : rules) {
            if (!r.isBackward() || r.bodyLength() <= 0) continue;
            bRules.add(r);
        }
        return bRules;
    }

    @Override
    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        FBRuleInfGraph preload = (FBRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator<Triple> i = preload.getDeductionsGraph().find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.addBRules(preload.getBRules());
            this.engine.setRuleStore(preload.getForwardRuleStore());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNode(Node n) {
        if (!JenaParameters.enableFilteringOfHiddenInfNodes) {
            return;
        }
        if (this.hiddenNodes == null) {
            this.hiddenNodes = new HashSet<Node>();
        }
        Set<Node> set = this.hiddenNodes;
        synchronized (set) {
            this.hiddenNodes.add(n);
        }
    }

    public void resetLPProfile(boolean enable) {
        this.bEngine.resetProfile(enable);
    }

    public void printLPProfile() {
        this.bEngine.printProfile();
    }

    public boolean accept(Object tin) {
        Triple t = (Triple)tin;
        if (t.getSubject().isLiteral()) {
            return true;
        }
        if (JenaParameters.enableFilteringOfHiddenInfNodes && this.hiddenNodes != null && (this.hiddenNodes.contains(t.getSubject()) || this.hiddenNodes.contains(t.getObject()) || this.hiddenNodes.contains(t.getPredicate()))) {
            return true;
        }
        return this.filterFunctors && Functor.isFunctor(t.getObject());
    }

    public static class RuleStore {
        protected List<Rule> rawRules;
        protected Object fRuleStore;
        protected List<Rule> bRules;

        public RuleStore(List<Rule> rawRules, Object fRuleStore, List<Rule> bRules) {
            this.rawRules = rawRules;
            this.fRuleStore = fRuleStore;
            this.bRules = bRules;
        }
    }
}

