/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.buffering;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.PrefixMappingBase;
import org.apache.jena.sparql.graph.PrefixMappingMem;
import org.apache.jena.system.buffering.BufferingCtl;

public class BufferingPrefixMapping
extends PrefixMappingBase
implements BufferingCtl {
    private static final boolean CHECK = false;
    private final PrefixMapping added = new PrefixMappingMem();
    private final Set<String> deleted = new HashSet<String>();
    private final PrefixMapping other;

    public BufferingPrefixMapping(PrefixMapping other) {
        this.other = other;
    }

    public PrefixMapping base() {
        return this.other;
    }

    @Override
    public void flush() {
        this.deleted.forEach(prefix -> this.other.removeNsPrefix(prefix));
        this.other.setNsPrefixes(this.added);
        this.deleted.clear();
        this.added.clearNsPrefixMap();
    }

    public PrefixMapping getAdded() {
        return this.added;
    }

    public Set<String> getDeleted() {
        return this.deleted;
    }

    @Override
    protected void add(String prefix, String uri) {
        this.added.setNsPrefix(prefix, uri);
    }

    @Override
    protected String prefixToUri(String prefix) {
        if (this.deleted.contains(prefix)) {
            return null;
        }
        String uri = this.added.getNsPrefixURI(prefix);
        if (uri != null) {
            return uri;
        }
        return this.other.getNsPrefixURI(prefix);
    }

    @Override
    protected String uriToPrefix(String uri) {
        String prefix1 = this.added.getNsURIPrefix(uri);
        if (prefix1 != null) {
            return prefix1;
        }
        String prefix2 = this.other.getNsURIPrefix(uri);
        if (prefix2 == null) {
            return null;
        }
        if (this.deleted.contains(prefix2)) {
            return null;
        }
        return prefix2;
    }

    @Override
    protected void remove(String prefix) {
        this.deleted.add(prefix);
        this.added.removeNsPrefix(prefix);
    }

    @Override
    public int numPrefixes() {
        return this.added.numPrefixes() - this.deleted.size() + this.other.numPrefixes();
    }

    @Override
    public boolean hasNoMappings() {
        return this.numPrefixes() == 0;
    }

    @Override
    protected void clear() {
        this.apply((prefix, iri) -> this.remove((String)prefix));
    }

    @Override
    protected boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    protected int size() {
        return this.numPrefixes();
    }

    @Override
    protected Map<String, String> asMap() {
        return this.asMapCopy();
    }

    @Override
    protected Map<String, String> asMapCopy() {
        Map map = this.other.getNsPrefixMap();
        this.deleted.forEach(prefix -> map.remove(prefix));
        map.putAll(this.added.getNsPrefixMap());
        return map;
    }

    @Override
    protected void apply(BiConsumer<String, String> action) {
        this.asMap().forEach(action);
    }
}

