/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

public interface IRI {
    public String str();

    public String toString();

    public int hashCode();

    public boolean equals(Object var1);

    default public boolean hasScheme() {
        return this.scheme() == null;
    }

    public String scheme();

    default public boolean hasAuthority() {
        return this.authority() != null;
    }

    public String authority();

    default public boolean hasUserInfo() {
        return this.userInfo() != null;
    }

    public String userInfo();

    default public boolean hasHost() {
        return this.host() != null;
    }

    public String host();

    default public boolean hasPort() {
        return this.port() != null;
    }

    public String port();

    default public boolean hasPath() {
        return this.path() != null;
    }

    public String path();

    public String[] pathSegments();

    default public boolean hasQuery() {
        return this.query() != null;
    }

    public String query();

    default public boolean hasFragment() {
        return this.fragment() != null;
    }

    public String fragment();

    default public boolean isAbsolute() {
        return this.hasScheme() && !this.hasFragment();
    }

    default public boolean isRelative() {
        return !this.hasScheme();
    }

    default public boolean isRootless() {
        return this.hasScheme() && !this.hasAuthority() && this.rootlessPath();
    }

    private boolean rootlessPath() {
        if (!this.hasPath()) {
            return false;
        }
        String path = this.path();
        return IRI.firstChar(path) != '/';
    }

    private static char firstChar(String str) {
        if (str.isEmpty()) {
            return '\uffff';
        }
        return str.charAt(0);
    }

    default public boolean isHierarchical() {
        return this.hasScheme() && this.hasAuthority() && this.hierarchicalPath();
    }

    private boolean hierarchicalPath() {
        if (!this.hasPath()) {
            return false;
        }
        String path = this.path();
        return IRI.firstChar(path) == '/';
    }

    public IRI normalize();
}

