/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.SerializationContext;

public abstract class ExprDigest
extends ExprFunction1 {
    private final String digestName;
    private final String printName;
    private MessageDigest digestCache;
    private final Cache<NodeValue, NodeValue> cache = CacheFactory.createOneSlotCache();

    public ExprDigest(Expr expr, String symbol, String printName, String digestName) {
        super(expr, symbol);
        this.digestName = digestName;
        this.printName = printName;
        try {
            this.digestCache = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new ARQInternalErrorException("Digest not provided in this Java system: " + digestName);
        }
    }

    private MessageDigest getDigest() {
        if (this.digestCache != null) {
            MessageDigest digest2 = null;
            try {
                digest2 = (MessageDigest)this.digestCache.clone();
                return digest2;
            }
            catch (CloneNotSupportedException ex) {
                this.digestCache = null;
            }
        }
        return this.createDigest();
    }

    private MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance(this.digestName);
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }

    @Override
    public NodeValue eval(NodeValue v) {
        return (NodeValue)this.cache.get((Object)v, x -> this.calculate((NodeValue)x));
    }

    private NodeValue calculate(NodeValue v) {
        Node n = v.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal: " + v);
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            throw new ExprEvalException("Can't make a digest of an RDF term with a language tag");
        }
        if (n.getLiteralDatatype() != null && !XSDDatatype.XSDstring.equals((Object)n.getLiteralDatatype())) {
            throw new ExprEvalException("Not a simple literal nor an XSD string");
        }
        try {
            MessageDigest digest = this.getDigest();
            String x = n.getLiteralLexicalForm();
            byte[] b = x.getBytes(StandardCharsets.UTF_8);
            byte[] d = digest.digest(b);
            String y = Bytes.asHexLC((byte[])d);
            NodeValue result = NodeValue.makeString(y);
            return result;
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return this.printName;
    }
}

