/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cdt;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeBase;
import org.apache.jena.cdt.ParserForCDTLiterals;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;

public class CompositeDatatypeMap
extends CompositeDatatypeBase<Map<CDTKey, CDTValue>> {
    public static final String uri = "http://w3id.org/awslabs/neptune/SPARQL-CDTs/Map";
    public static final CompositeDatatypeMap type = new CompositeDatatypeMap();

    protected CompositeDatatypeMap() {
    }

    public String getURI() {
        return uri;
    }

    public boolean isValidValue(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map m = (Map)value;
        for (Map.Entry e2 : m.entrySet()) {
            if (!(e2.getKey() instanceof CDTKey)) {
                return false;
            }
            if (e2.getValue() instanceof CDTValue) continue;
            return false;
        }
        return true;
    }

    public boolean isValidLiteral(LiteralLabel lit) {
        String dtURI = lit.getDatatypeURI();
        if (dtURI == null || !dtURI.equals(uri)) {
            return false;
        }
        String lang = lit.language();
        if (lang != null && !lang.isEmpty()) {
            return false;
        }
        String lex = lit.getLexicalForm();
        return this.isValid(lex);
    }

    public boolean isValid(String lexicalForm) {
        try {
            ParserForCDTLiterals.parseMapLiteral(lexicalForm);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Map<CDTKey, CDTValue> parse(String lexicalForm) throws DatatypeFormatException {
        try {
            return ParserForCDTLiterals.parseMapLiteral(lexicalForm);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)type, (Throwable)ex);
        }
    }

    public String unparse(Object value) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException();
        }
        Map map = (Map)value;
        return this.unparseValue(map);
    }

    @Override
    public String unparseValue(Map<CDTKey, CDTValue> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!map.isEmpty()) {
            Iterator<Map.Entry<CDTKey, CDTValue>> it = map.entrySet().iterator();
            Map.Entry<CDTKey, CDTValue> firstEntry = it.next();
            this.unparseMapEntry(firstEntry, sb);
            while (it.hasNext()) {
                sb.append(", ");
                Map.Entry<CDTKey, CDTValue> nextEntry = it.next();
                this.unparseMapEntry(nextEntry, sb);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    protected void unparseMapEntry(Map.Entry<CDTKey, CDTValue> entry, StringBuilder sb) {
        sb.append(entry.getKey().asLexicalForm());
        sb.append(" : ");
        sb.append(entry.getValue().asLexicalForm());
    }

    public int getHashCode(LiteralLabel lit) {
        return lit.hashCode();
    }

    public boolean isEqual(LiteralLabel lit1, LiteralLabel lit2) {
        if (!CompositeDatatypeMap.isMapLiteral(lit1) || !CompositeDatatypeMap.isMapLiteral(lit2)) {
            return false;
        }
        Map<CDTKey, CDTValue> map1 = CompositeDatatypeMap.getValue(lit1);
        Map<CDTKey, CDTValue> map2 = CompositeDatatypeMap.getValue(lit2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<CDTKey, CDTValue> entry1 : map1.entrySet()) {
            CDTValue v1 = entry1.getValue();
            CDTValue v2 = map2.get(entry1.getKey());
            if (v2 == null) {
                return false;
            }
            if (v1.isNull() || v2.isNull()) {
                if (v1.isNull() && v2.isNull()) continue;
                return false;
            }
            Node n1 = v1.asNode();
            Node n2 = v2.asNode();
            if ((n1.isBlank() || n2.isBlank()) && !n1.equals((Object)n2)) {
                throw new ExprEvalException("blank nodes in maps cannot be compared");
            }
            if (n1.sameValueAs((Object)n2)) continue;
            return false;
        }
        return true;
    }

    public static int compare(LiteralLabel value1, LiteralLabel value2, boolean sortOrderingCompare) throws ExprNotComparableException {
        Map<CDTKey, CDTValue> map2;
        Map<CDTKey, CDTValue> map1;
        if (!value1.isWellFormed() || !value2.isWellFormed()) {
            throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
        }
        try {
            map1 = CompositeDatatypeMap.getValue(value1);
            map2 = CompositeDatatypeMap.getValue(value2);
        }
        catch (Exception e2) {
            throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            if (!map1.isEmpty()) {
                return 1;
            }
            if (!map2.isEmpty()) {
                return -1;
            }
            if (sortOrderingCompare) {
                return CompositeDatatypeMap.compareByLexicalForms(value1, value2);
            }
            return 0;
        }
        CDTKeySorter keySorter = new CDTKeySorter();
        TreeSet<CDTKey> sortedKeys1 = new TreeSet<CDTKey>(keySorter);
        TreeSet<CDTKey> sortedKeys2 = new TreeSet<CDTKey>(keySorter);
        sortedKeys1.addAll(map1.keySet());
        sortedKeys2.addAll(map2.keySet());
        Iterator<CDTKey> it1 = sortedKeys1.iterator();
        Iterator<CDTKey> it2 = sortedKeys2.iterator();
        int n = Math.min(sortedKeys1.size(), sortedKeys2.size());
        for (int i = 0; i < n; ++i) {
            CDTKey k2;
            CDTKey k1 = it1.next();
            int kCmp = keySorter.compare(k1, k2 = it2.next());
            if (kCmp < 0) {
                return -1;
            }
            if (kCmp > 0) {
                return 1;
            }
            CDTValue v1 = map1.get(k1);
            CDTValue v2 = map2.get(k2);
            if (!v1.isNull() && !v2.isNull()) {
                NodeValue nv1 = NodeValue.makeNode(v1.asNode());
                NodeValue nv2 = NodeValue.makeNode(v2.asNode());
                try {
                    int c = sortOrderingCompare ? NodeValue.compareAlways(nv1, nv2) : NodeValue.compare(nv1, nv2);
                    if (c < 0) {
                        return -1;
                    }
                    if (c > 0) {
                        return 1;
                    }
                }
                catch (Exception c) {
                    // empty catch block
                }
                boolean sameValueTestResult = false;
                boolean sameValueTestFailed = false;
                try {
                    sameValueTestResult = NodeValue.sameValueAs(nv1, nv2);
                }
                catch (Exception e3) {
                    sameValueTestFailed = true;
                }
                if (!sameValueTestFailed && sameValueTestResult) continue;
                if (sortOrderingCompare) {
                    return 2;
                }
                throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
            }
            if (!sortOrderingCompare) {
                if (v1.isNull() && v2.isNull()) continue;
                throw new ExprNotComparableException("Can't compare " + value1 + " and " + value2);
            }
            if (v1.isNull() && !v2.isNull()) {
                return -1;
            }
            if (!v2.isNull() || v1.isNull()) continue;
            return 1;
        }
        int sizeDiff = map1.size() - map2.size();
        if (sizeDiff < 0) {
            return -1;
        }
        if (sizeDiff > 0) {
            return 1;
        }
        if (sortOrderingCompare) {
            return CompositeDatatypeMap.compareByLexicalForms(value1, value2);
        }
        return 0;
    }

    public static boolean isMapLiteral(Node n) {
        return n.isLiteral() && n.getLiteralDatatypeURI().equals(uri);
    }

    public static boolean isMapLiteral(LiteralLabel lit) {
        return lit.getDatatypeURI().equals(uri);
    }

    public static Map<CDTKey, CDTValue> getValue(LiteralLabel lit) throws DatatypeFormatException {
        Object value = lit.getValue();
        if (value == null || !(value instanceof Map)) {
            throw new IllegalArgumentException(lit.toString() + " - " + value);
        }
        Map map = (Map)value;
        return map;
    }

    protected static class CDTKeySorter
    implements Comparator<CDTKey> {
        protected CDTKeySorter() {
        }

        @Override
        public int compare(CDTKey k1, CDTKey k2) {
            String lex2;
            String dt2;
            Node n1 = k1.asNode();
            Node n2 = k2.asNode();
            if (n1.isURI()) {
                if (!n2.isURI()) {
                    return -1;
                }
                String uri1 = n1.getURI();
                String uri2 = n2.getURI();
                return uri1.compareTo(uri2);
            }
            if (n2.isURI()) {
                return 1;
            }
            String dt1 = n1.getLiteralDatatypeURI();
            int dtCmp = dt1.compareTo(dt2 = n2.getLiteralDatatypeURI());
            if (dtCmp != 0) {
                return dtCmp;
            }
            String lex1 = n1.getLiteralLexicalForm();
            int lexCmp = lex1.compareTo(lex2 = n2.getLiteralLexicalForm());
            if (lexCmp != 0 || !RDFLangString.rdfLangString.getURI().equals(dt1)) {
                return lexCmp;
            }
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            return lang1.compareTo(lang2);
        }
    }
}

