/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.XSDNumUtils;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdType;
import org.apache.jena.tdb2.store.value.DateTimeNode;
import org.apache.jena.tdb2.store.value.DecimalNode56;
import org.apache.jena.tdb2.store.value.DoubleNode62;
import org.apache.jena.tdb2.store.value.FloatNode;
import org.apache.jena.tdb2.store.value.IntegerNode;

public class NodeIdInline {
    private static Set<RDFDatatype> datatypes = new HashSet<RDFDatatype>();
    private static BidiMap<NodeIdType, RDFDatatype> derivedTypeMap;

    public static NodeId inline(Node node) {
        if (node == null) {
            Log.warn(NodeId.class, (String)("Null node: " + node));
            return null;
        }
        if (!NodeId.enableInlineLiterals) {
            return null;
        }
        if (!node.isLiteral()) {
            return null;
        }
        if (NodeUtils.isSimpleString((Node)node) || NodeUtils.isLangString((Node)node)) {
            return null;
        }
        try {
            return NodeIdInline.inline$(node);
        }
        catch (Throwable th) {
            Log.warn(NodeId.class, (String)("Failed to process " + node));
            return null;
        }
    }

    public static boolean hasInlineDatatype(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        RDFDatatype dtn = node.getLiteralDatatype();
        return datatypes.contains(dtn);
    }

    private static NodeId inline$(Node node) {
        if (!NodeIdInline.hasInlineDatatype(node)) {
            return null;
        }
        LiteralLabel lit = node.getLiteral();
        if (node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal)) {
            if (!XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                return null;
            }
            BigDecimal decimal = new BigDecimal(lit.getLexicalForm().trim());
            DecimalNode56 dn = DecimalNode56.valueOf(decimal);
            if (dn != null) {
                return NodeId.createRaw(NodeIdType.XSD_DECIMAL, dn.pack());
            }
            return null;
        }
        if (XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            if (lit.getLexicalForm().length() > 19) {
                return null;
            }
            NodeIdType type = (NodeIdType)((Object)derivedTypeMap.inverseBidiMap().getOrDefault((Object)lit.getDatatype(), (Object)NodeIdType.XSD_INTEGER));
            try {
                long v = ((Number)lit.getValue()).longValue();
                v = IntegerNode.pack56(v);
                if (v == -1L) {
                    return null;
                }
                return NodeId.createRaw(type, v);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
            double d = ((Number)lit.getValue()).doubleValue();
            long v = DoubleNode62.pack(d);
            if (v == -72057594037927936L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DOUBLE, v);
        }
        if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
            float f = ((Number)lit.getValue()).floatValue();
            long v = FloatNode.pack(f);
            return NodeId.createRaw(NodeIdType.XSD_FLOAT, v);
        }
        if (lit.getDatatype().equals(XSDDatatype.XSDdateTimeStamp) && XSDDatatype.XSDdateTimeStamp.isValidLiteral(lit)) {
            long v = DateTimeNode.packDateTime(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATETIMESTAMP, v);
        }
        if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
            long v = DateTimeNode.packDateTime(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATETIME, v);
        }
        if (XSDDatatype.XSDdate.isValidLiteral(lit)) {
            long v = DateTimeNode.packDate(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATE, v);
        }
        if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
            long v = 0L;
            boolean b = (Boolean)lit.getValue();
            if (b) {
                v |= 1L;
            }
            return NodeId.createRaw(NodeIdType.XSD_BOOLEAN, v);
        }
        return null;
    }

    public static Node extract(NodeId nodeId) {
        if (nodeId == NodeId.NodeDoesNotExist) {
            return null;
        }
        NodeIdType type = nodeId.type();
        if (type == NodeIdType.PTR || type == NodeIdType.SPECIAL) {
            return null;
        }
        switch (type) {
            case XSD_INTEGER: 
            case XSD_POSITIVE_INTEGER: 
            case XSD_NEGATIVE_INTEGER: 
            case XSD_NON_NEGATIVE_INTEGER: 
            case XSD_NON_POSITIVE_INTEGER: 
            case XSD_LONG: 
            case XSD_INT: 
            case XSD_SHORT: 
            case XSD_BYTE: 
            case XSD_UNSIGNEDLONG: 
            case XSD_UNSIGNEDINT: 
            case XSD_UNSIGNEDSHORT: 
            case XSD_UNSIGNEDBYTE: {
                long val = IntegerNode.unpack56(nodeId.value2);
                RDFDatatype dt = (RDFDatatype)derivedTypeMap.getOrDefault((Object)type, (Object)XSDDatatype.XSDinteger);
                Node n = NodeFactory.createLiteralDT((String)Long.toString(val), (RDFDatatype)dt);
                return n;
            }
            case XSD_DECIMAL: {
                BigDecimal decimal = DecimalNode56.unpackAsBigDecimal(nodeId.value2);
                String x = XSDNumUtils.stringForm((BigDecimal)decimal);
                return NodeFactory.createLiteralDT((String)x, (RDFDatatype)XSDDatatype.XSDdecimal);
            }
            case XSD_DOUBLE: {
                double d = DoubleNode62.unpack(nodeId.value2);
                String xsdStr = XSDNumUtils.stringForm((double)d);
                Node n = NodeFactory.createLiteralDT((String)xsdStr, (RDFDatatype)XSDDatatype.XSDdouble);
                return n;
            }
            case XSD_FLOAT: {
                float f = FloatNode.unpack(nodeId.value2);
                String xsdStr = XSDNumUtils.stringForm((float)f);
                Node n = NodeFactory.createLiteralDT((String)xsdStr, (RDFDatatype)XSDDatatype.XSDfloat);
                return n;
            }
            case XSD_DATETIMESTAMP: 
            case XSD_DATETIME: {
                XSDDatatype dt = type == NodeIdType.XSD_DATETIMESTAMP ? XSDDatatype.XSDdateTimeStamp : XSDDatatype.XSDdateTime;
                long val = nodeId.getValue2();
                String lex = DateTimeNode.unpackDateTime(val);
                return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)dt);
            }
            case XSD_DATE: {
                long val = nodeId.getValue2();
                String lex = DateTimeNode.unpackDate(val);
                return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
            }
            case XSD_BOOLEAN: {
                long val = nodeId.getValue2();
                if (val == 0L) {
                    return NodeConst.nodeFalse;
                }
                if (val == 1L) {
                    return NodeConst.nodeTrue;
                }
                throw new TDBException("Unrecognized boolean node id : " + val);
            }
        }
        throw new TDBException("Unrecognized node id type: " + type);
    }

    static {
        datatypes.add((RDFDatatype)XSDDatatype.XSDdecimal);
        datatypes.add((RDFDatatype)XSDDatatype.XSDinteger);
        datatypes.add((RDFDatatype)XSDDatatype.XSDdouble);
        datatypes.add((RDFDatatype)XSDDatatype.XSDfloat);
        datatypes.add((RDFDatatype)XSDDatatype.XSDlong);
        datatypes.add((RDFDatatype)XSDDatatype.XSDint);
        datatypes.add((RDFDatatype)XSDDatatype.XSDshort);
        datatypes.add((RDFDatatype)XSDDatatype.XSDbyte);
        datatypes.add((RDFDatatype)XSDDatatype.XSDpositiveInteger);
        datatypes.add((RDFDatatype)XSDDatatype.XSDnonPositiveInteger);
        datatypes.add((RDFDatatype)XSDDatatype.XSDnegativeInteger);
        datatypes.add((RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        datatypes.add((RDFDatatype)XSDDatatype.XSDunsignedLong);
        datatypes.add((RDFDatatype)XSDDatatype.XSDunsignedInt);
        datatypes.add((RDFDatatype)XSDDatatype.XSDunsignedShort);
        datatypes.add((RDFDatatype)XSDDatatype.XSDunsignedByte);
        datatypes.add((RDFDatatype)XSDDatatype.XSDdateTimeStamp);
        datatypes.add((RDFDatatype)XSDDatatype.XSDdateTime);
        datatypes.add((RDFDatatype)XSDDatatype.XSDdate);
        datatypes.add((RDFDatatype)XSDDatatype.XSDboolean);
        derivedTypeMap = new DualHashBidiMap();
        derivedTypeMap.put((Object)NodeIdType.XSD_LONG, (Object)XSDDatatype.XSDlong);
        derivedTypeMap.put((Object)NodeIdType.XSD_INT, (Object)XSDDatatype.XSDint);
        derivedTypeMap.put((Object)NodeIdType.XSD_SHORT, (Object)XSDDatatype.XSDshort);
        derivedTypeMap.put((Object)NodeIdType.XSD_BYTE, (Object)XSDDatatype.XSDbyte);
        derivedTypeMap.put((Object)NodeIdType.XSD_POSITIVE_INTEGER, (Object)XSDDatatype.XSDpositiveInteger);
        derivedTypeMap.put((Object)NodeIdType.XSD_NON_POSITIVE_INTEGER, (Object)XSDDatatype.XSDnonPositiveInteger);
        derivedTypeMap.put((Object)NodeIdType.XSD_NEGATIVE_INTEGER, (Object)XSDDatatype.XSDnegativeInteger);
        derivedTypeMap.put((Object)NodeIdType.XSD_NON_NEGATIVE_INTEGER, (Object)XSDDatatype.XSDnonNegativeInteger);
        derivedTypeMap.put((Object)NodeIdType.XSD_UNSIGNEDLONG, (Object)XSDDatatype.XSDunsignedLong);
        derivedTypeMap.put((Object)NodeIdType.XSD_UNSIGNEDINT, (Object)XSDDatatype.XSDunsignedInt);
        derivedTypeMap.put((Object)NodeIdType.XSD_UNSIGNEDSHORT, (Object)XSDDatatype.XSDunsignedShort);
        derivedTypeMap.put((Object)NodeIdType.XSD_UNSIGNEDBYTE, (Object)XSDDatatype.XSDunsignedByte);
    }
}

