/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shacl.engine.SparqlConstraints;
import org.apache.jena.shacl.engine.constraint.ClassConstraint;
import org.apache.jena.shacl.engine.constraint.ClosedConstraint;
import org.apache.jena.shacl.engine.constraint.DatatypeConstraint;
import org.apache.jena.shacl.engine.constraint.DisjointConstraint;
import org.apache.jena.shacl.engine.constraint.EqualsConstraint;
import org.apache.jena.shacl.engine.constraint.HasValueConstraint;
import org.apache.jena.shacl.engine.constraint.InConstraint;
import org.apache.jena.shacl.engine.constraint.LessThanConstraint;
import org.apache.jena.shacl.engine.constraint.LessThanOrEqualsConstraint;
import org.apache.jena.shacl.engine.constraint.MaxCount;
import org.apache.jena.shacl.engine.constraint.MinCount;
import org.apache.jena.shacl.engine.constraint.NodeKindConstraint;
import org.apache.jena.shacl.engine.constraint.PatternConstraint;
import org.apache.jena.shacl.engine.constraint.QualifiedValueShape;
import org.apache.jena.shacl.engine.constraint.ShAnd;
import org.apache.jena.shacl.engine.constraint.ShNode;
import org.apache.jena.shacl.engine.constraint.ShNot;
import org.apache.jena.shacl.engine.constraint.ShOr;
import org.apache.jena.shacl.engine.constraint.ShXone;
import org.apache.jena.shacl.engine.constraint.StrLanguageIn;
import org.apache.jena.shacl.engine.constraint.StrMaxLengthConstraint;
import org.apache.jena.shacl.engine.constraint.StrMinLengthConstraint;
import org.apache.jena.shacl.engine.constraint.UniqueLangConstraint;
import org.apache.jena.shacl.engine.constraint.ValueMaxExclusiveConstraint;
import org.apache.jena.shacl.engine.constraint.ValueMaxInclusiveConstraint;
import org.apache.jena.shacl.engine.constraint.ValueMinExclusiveConstraint;
import org.apache.jena.shacl.engine.constraint.ValueMinInclusiveConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapesParser;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Constraints {
    static Map<Node, ConstraintMaker> dispatch = new HashMap<Node, ConstraintMaker>();
    static Set<Node> immediate;

    static List<Constraint> parseConstraints(Graph shapesGraph, Node shape, Map<Node, Shape> parsed, Set<Node> traversed) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        ExtendedIterator iter = G.find((Graph)shapesGraph, (Node)shape, null, null);
        iter.forEachRemaining(t -> {
            Node o;
            Node p = t.getPredicate();
            if (SHACL.property.equals((Object)p)) {
                return;
            }
            if (SHACL.path.equals((Object)p)) {
                return;
            }
            Node s = t.getSubject();
            Constraint c = Constraints.parseConstraint(shapesGraph, s, p, o = t.getObject(), parsed, traversed);
            if (c != null) {
                constraints.add(c);
            }
        });
        return constraints;
    }

    private static Constraint parseConstraint(Graph g, Node s, Node p, Node o, Map<Node, Shape> parsed, Set<Node> traversed) {
        ConstraintMaker maker = dispatch.get(p);
        if (maker != null) {
            return maker.make(g, s, p, o);
        }
        if (p.equals((Object)SHACL.not)) {
            Shape shape = ShapesParser.parseShapeStep(traversed, parsed, g, o);
            return new ShNot(shape);
        }
        if (p.equals((Object)SHACL.or)) {
            List<Node> elts = Constraints.list(g, o);
            List<Shape> shapes = Constraints.shapes(g, parsed, traversed, elts);
            return new ShOr(shapes);
        }
        if (p.equals((Object)SHACL.and)) {
            List<Node> elts = Constraints.list(g, o);
            List<Shape> shapes = Constraints.shapes(g, parsed, traversed, elts);
            return new ShAnd(shapes);
        }
        if (p.equals((Object)SHACL.xone)) {
            List<Node> elts = Constraints.list(g, o);
            List<Shape> shapes = Constraints.shapes(g, parsed, traversed, elts);
            return new ShXone(shapes);
        }
        if (p.equals((Object)SHACL.node)) {
            Shape other = ShapesParser.parseShapeStep(traversed, parsed, g, o);
            if (other instanceof PropertyShape) {
                throw new ShaclParseException("Object of sh:node must be a node shape, not a property shape");
            }
            return new ShNode(other);
        }
        if (p.equals((Object)SHACL.pattern)) {
            Node pat = o;
            if (!Util.isSimpleString((Node)pat)) {
                throw new ShaclParseException("Pattern is not a string: Node = " + ShLib.displayStr(s) + " : Pattern = " + ShLib.displayStr(pat));
            }
            Node flagsNode = G.getSP((Graph)g, (Node)s, (Node)SHACL.flags);
            if (flagsNode != null && !Util.isSimpleString((Node)flagsNode)) {
                throw new ShaclParseException("Pattern flags not a string: Node = " + ShLib.displayStr(s) + " : Pattern = " + ShLib.displayStr(flagsNode));
            }
            return new PatternConstraint(pat.getLiteralLexicalForm(), flagsNode != null ? flagsNode.getLiteralLexicalForm() : null);
        }
        if (p.equals((Object)SHACL.ignoredProperties)) {
            return null;
        }
        if (p.equals((Object)SHACL.qualifiedValueShape)) {
            return Constraints.parseQualifiedValueShape(g, s, p, o, parsed, traversed);
        }
        if (p.equals((Object)SHACL.QualifiedMinCountConstraintComponent) || p.equals((Object)SHACL.QualifiedMaxCountConstraintComponent) || p.equals((Object)SHACL.qualifiedValueShapesDisjoint)) {
            return null;
        }
        if (p.equals((Object)SHACL.path)) {
            throw new ShaclParseException("Unexpected constraint: " + ShLib.displayStr(p) + " on " + s);
        }
        if (p.equals((Object)SHACL.property)) {
            throw new ShaclParseException("Unexpected constraint: " + ShLib.displayStr(p) + " on " + s);
        }
        return null;
    }

    private static List<Shape> shapes(Graph g, Map<Node, Shape> parsed, Set<Node> traversed, List<Node> elts) {
        return elts.stream().map(x -> ShapesParser.parseShapeStep(traversed, parsed, g, x)).toList();
    }

    private static Constraint parseQualifiedValueShape(Graph g, Node s, Node p, Node o, Map<Node, Shape> parsed, Set<Node> traversed) {
        Shape sub = ShapesParser.parseShapeStep(traversed, parsed, g, o);
        Node qMin = G.getZeroOrOneSP((Graph)g, (Node)s, (Node)SHACL.qualifiedMinCount);
        Node qMax = G.getZeroOrOneSP((Graph)g, (Node)s, (Node)SHACL.qualifiedMaxCount);
        int vMin = Constraints.intValue(qMin, -1);
        int vMax = Constraints.intValue(qMax, -1);
        Node qDisjoint = G.getZeroOrOneSP((Graph)g, (Node)s, (Node)SHACL.qualifiedValueShapesDisjoint);
        if (vMin < 0 && vMax < 0) {
            throw new ShaclParseException("At least one of sh:qualifiedMinCount and sh:qualifiedMaxCount required");
        }
        return new QualifiedValueShape(sub, vMin, vMax, Constraints.booleanValueStrict(qDisjoint));
    }

    private static Constraint notImplemented(Node p) {
        throw new NotImplemented(ShLib.displayStr(p));
    }

    static Node checkObjectIRI(Graph g, Node shape, Node p, Node o) {
        if (!o.isURI()) {
            throw new ShaclParseException("IRI required: " + ShLib.displayStr(o) + " at " + shape + " " + ShLib.displayStr(p));
        }
        return o;
    }

    static int intValue(Node n) {
        return (Integer)n.getLiteralValue();
    }

    static int intValue(Node n, int dftValue) {
        if (n == null) {
            return dftValue;
        }
        return Constraints.intValue(n);
    }

    private static boolean booleanValueStrict(Node node) {
        return C.TRUE.equals((Object)node);
    }

    private static boolean booleanValue(Node node) {
        return (Boolean)node.getLiteralValue();
    }

    private static List<Node> list(Graph g, Node node) {
        return G.rdfList((Graph)g, (Node)node);
    }

    private static List<String> listString(Graph g, Node node) {
        List<Node> elts = Constraints.list(g, node);
        return elts.stream().map(n -> {
            if (!Util.isSimpleString((Node)n)) {
                throw new ShaclParseException("Not a string " + ShLib.displayStr(n) + " in list " + elts);
            }
            return n.getLiteralLexicalForm();
        }).toList();
    }

    static {
        dispatch.put(SHACL.class_, (g, s, p, o) -> new ClassConstraint(o));
        dispatch.put(SHACL.datatype, (g, s, p, o) -> new DatatypeConstraint(o));
        dispatch.put(SHACL.nodeKind, (g, s, p, o) -> new NodeKindConstraint(o));
        dispatch.put(SHACL.minCount, (g, s, p, o) -> new MinCount(Constraints.intValue(o)));
        dispatch.put(SHACL.maxCount, (g, s, p, o) -> new MaxCount(Constraints.intValue(o)));
        dispatch.put(SHACL.minInclusive, (g, s, p, o) -> new ValueMinInclusiveConstraint(o));
        dispatch.put(SHACL.minExclusive, (g, s, p, o) -> new ValueMinExclusiveConstraint(o));
        dispatch.put(SHACL.maxInclusive, (g, s, p, o) -> new ValueMaxInclusiveConstraint(o));
        dispatch.put(SHACL.maxExclusive, (g, s, p, o) -> new ValueMaxExclusiveConstraint(o));
        dispatch.put(SHACL.minLength, (g, s, p, o) -> new StrMinLengthConstraint(Constraints.intValue(o)));
        dispatch.put(SHACL.maxLength, (g, s, p, o) -> new StrMaxLengthConstraint(Constraints.intValue(o)));
        dispatch.put(SHACL.languageIn, (g, s, p, o) -> new StrLanguageIn(Constraints.listString(g, o)));
        dispatch.put(SHACL.uniqueLang, (g, s, p, o) -> new UniqueLangConstraint(Constraints.booleanValueStrict(o)));
        dispatch.put(SHACL.equals, (g, s, p, o) -> new EqualsConstraint(Constraints.checkObjectIRI(g, s, p, o)));
        dispatch.put(SHACL.disjoint, (g, s, p, o) -> new DisjointConstraint(Constraints.checkObjectIRI(g, s, p, o)));
        dispatch.put(SHACL.lessThan, (g, s, p, o) -> new LessThanConstraint(Constraints.checkObjectIRI(g, s, p, o)));
        dispatch.put(SHACL.lessThanOrEquals, (g, s, p, o) -> new LessThanOrEqualsConstraint(Constraints.checkObjectIRI(g, s, p, o)));
        dispatch.put(SHACL.hasValue, (g, s, p, o) -> new HasValueConstraint(o));
        dispatch.put(SHACL.in, (g, s, p, o) -> new InConstraint(Constraints.list(g, o)));
        dispatch.put(SHACL.closed, (g, s, p, o) -> new ClosedConstraint(g, s, Constraints.booleanValue(o)));
        dispatch.put(SHACL.sparql, (g, s, p, o) -> SparqlConstraints.parseSparqlConstraint(g, s, p, o));
        immediate = new HashSet<Node>();
        immediate.add(SHACL.datatype);
        immediate.add(SHACL.nodeKind);
        immediate.add(SHACL.minExclusive);
        immediate.add(SHACL.minInclusive);
        immediate.add(SHACL.maxExclusive);
        immediate.add(SHACL.maxInclusive);
        immediate.add(SHACL.minLength);
        immediate.add(SHACL.maxLength);
        immediate.add(SHACL.languageIn);
        immediate.add(SHACL.in);
        immediate.add(SHACL.pattern);
    }

    static interface ConstraintMaker {
        public Constraint make(Graph var1, Node var2, Node var3, Node var4);
    }
}

