/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;

public class PutFct
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new QueryBuildException("Function '" + Lib.className((Object)this) + "' takes two or three arguments");
        }
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        CDTValue newValue;
        if (args.size() < 2 || args.size() > 3) {
            throw new ExprException("wrong number of arguments (" + args.size() + "), must be 2 or 3");
        }
        NodeValue nv2 = args.get(1).eval(binding, env);
        Node n2 = nv2.asNode();
        if (!n2.isURI() && !n2.isLiteral()) {
            throw new ExprEvalException("Not a valid map key: " + nv2);
        }
        NodeValue nv1 = args.get(0).eval(binding, env);
        Map<CDTKey, CDTValue> map = CDTLiteralFunctionUtils.checkAndGetMap(nv1);
        CDTKey key = CDTFactory.createKey(n2);
        if (args.size() == 2) {
            newValue = CDTFactory.getNullValue();
        } else {
            NodeValue nv3 = null;
            try {
                nv3 = args.get(2).eval(binding, env);
            }
            catch (ExprException exprException) {
                // empty catch block
            }
            newValue = nv3 != null ? CDTFactory.createValue(nv3.asNode()) : CDTFactory.getNullValue();
        }
        CDTValue oldValue = map.get(key);
        if (oldValue != null) {
            Node nn;
            Node on;
            if (oldValue.isNull() && newValue.isNull()) {
                return nv1;
            }
            if (!oldValue.isNull() && !newValue.isNull() && (on = oldValue.asNode()).equals((Object)(nn = newValue.asNode()))) {
                return nv1;
            }
        }
        HashMap<CDTKey, CDTValue> newMap = new HashMap<CDTKey, CDTValue>(map);
        newMap.put(key, newValue);
        return CDTLiteralFunctionUtils.createNodeValue(newMap);
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        throw new IllegalStateException("should never end up here");
    }
}

