/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;

public class NodeValueOps {
    private static final String dtXSDdayTimeDuration = XSDDatatype.XSDdayTimeDuration.getURI();
    private static final String dtXSDyearMonthDuration = XSDDatatype.XSDyearMonthDuration.getURI();

    public static NodeValue additionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpace vs1 = nv1.getValueSpace();
        ValueSpace vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpace.VSPACE_NUM) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            return XSDFuncOp.numAdd(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_STRING) && vs2.equals((Object)ValueSpace.VSPACE_STRING)) {
            return NodeValue.makeString(nv1.asString() + nv2.asString());
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DURATION) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            boolean isDTDur = dtXSDdayTimeDuration.equals(nv1.getDatatypeURI()) && dtXSDdayTimeDuration.equals(nv2.getDatatypeURI());
            boolean isYMDur = dtXSDyearMonthDuration.equals(nv1.getDatatypeURI()) && dtXSDyearMonthDuration.equals(nv2.getDatatypeURI());
            Duration d3 = nv1.getDuration().add(nv2.getDuration());
            String lex = d3.toString();
            Node n = isDTDur ? NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdayTimeDuration) : (isYMDur ? NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDyearMonthDuration) : NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDduration));
            return NodeValue.makeNodeDuration(d3, n);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DATETIME) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDateTime(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DATE) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDate(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_TIME) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_add(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeNode(result.toXMLFormat(), (RDFDatatype)XSDDatatype.XSDtime);
            return r;
        }
        throw new ExprEvalTypeException("Operator '+' : Undefined addition: " + nv1 + " and " + nv2);
    }

    public static NodeValue subtractionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpace vs1 = nv1.getValueSpace();
        ValueSpace vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpace.VSPACE_NUM) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            return XSDFuncOp.numSubtract(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DURATION) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            boolean isDTDur = dtXSDdayTimeDuration.equals(nv1.getDatatypeURI()) && dtXSDdayTimeDuration.equals(nv2.getDatatypeURI());
            boolean isYMDur = dtXSDyearMonthDuration.equals(nv1.getDatatypeURI()) && dtXSDyearMonthDuration.equals(nv2.getDatatypeURI());
            Duration d3 = nv1.getDuration().subtract(nv2.getDuration());
            String lex = d3.toString();
            Node n = isDTDur ? NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdayTimeDuration) : (isYMDur ? NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDyearMonthDuration) : NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDduration));
            return NodeValue.makeNodeDuration(d3, n);
        }
        if (NodeValueOps.isDT(vs1) && NodeValueOps.isDT(vs2)) {
            boolean isDef2;
            XMLGregorianCalendar cal1 = nv1.getDateTime();
            XMLGregorianCalendar cal2 = nv2.getDateTime();
            boolean isDef1 = cal1.getTimezone() == Integer.MIN_VALUE;
            boolean bl = isDef2 = cal2.getTimezone() == Integer.MIN_VALUE;
            if (isDef1 && !isDef2 || !isDef1 && isDef2) {
                throw new ExprEvalTypeException("Operator '-': can't substract timezone/non-timezone values");
            }
            return NodeValue.makeDuration(NodeValueOps.xsd_substract(cal1, cal2));
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DATETIME) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDateTime(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DATE) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeDate(result);
            return r;
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_TIME) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            XMLGregorianCalendar cal = nv1.getDateTime();
            XMLGregorianCalendar result = NodeValueOps.xsd_subtract(cal, nv2.getDuration());
            NodeValue r = NodeValue.makeNode(result.toXMLFormat(), (RDFDatatype)XSDDatatype.XSDtime);
            return r;
        }
        throw new ExprEvalTypeException("Operator '-' : Undefined subtraction: " + nv1 + " and " + nv2);
    }

    public static NodeValue multiplicationNV(NodeValue nv1, NodeValue nv2) {
        ValueSpace vs1 = nv1.getValueSpace();
        ValueSpace vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpace.VSPACE_NUM) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            return XSDFuncOp.numMultiply(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DURATION) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            Duration dur = nv1.getDuration();
            boolean valid = XSDFuncOp.isDayTime(dur);
            if (!valid) {
                throw new ExprEvalTypeException("Operator '*': only dayTime duration.  Got: " + nv1);
            }
            BigDecimal dec = nv2.getDecimal();
            Duration r = dur.multiply(dec);
            Node n = NodeFactory.createLiteralDT((String)r.toString(), (RDFDatatype)XSDDatatype.XSDduration);
            return NodeValue.makeNodeDuration(r, n);
        }
        throw new ExprEvalTypeException("Operator '*' : Undefined multiply: " + nv1 + " and " + nv2);
    }

    public static NodeValue divisionNV(NodeValue nv1, NodeValue nv2) {
        ValueSpace vs1 = nv1.getValueSpace();
        ValueSpace vs2 = nv2.getValueSpace();
        if (vs1.equals((Object)ValueSpace.VSPACE_NUM) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            return XSDFuncOp.numDivide(nv1, nv2);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DURATION) && vs2.equals((Object)ValueSpace.VSPACE_NUM)) {
            Duration dur = nv1.getDuration();
            BigDecimal dec = nv2.getDecimal();
            if (dec.equals(BigDecimal.ZERO)) {
                throw new ExprEvalTypeException("Divide by zero in duration division");
            }
            BigDecimal dec1 = BigDecimal.ONE.divide(dec);
            Duration r = dur.multiply(dec1);
            Node n = NodeFactory.createLiteralDT((String)r.toString(), (RDFDatatype)XSDDatatype.XSDduration);
            return NodeValue.makeNodeDuration(r, n);
        }
        if (vs1.equals((Object)ValueSpace.VSPACE_DURATION) && vs2.equals((Object)ValueSpace.VSPACE_DURATION)) {
            Duration dur1 = nv1.getDuration();
            Duration dur2 = nv2.getDuration();
            if (XSDFuncOp.isDayTime(dur1) && XSDFuncOp.isDayTime(dur2)) {
                double x1 = NodeValueOps.durationDayTimeAsSeconds(dur1);
                double x2 = NodeValueOps.durationDayTimeAsSeconds(dur2);
                if (x2 == 0.0) {
                    throw new ExprEvalTypeException("Divide by zero duration in xsd:dayTimeDuration division");
                }
                return NodeValue.makeDecimal(x1 / x2);
            }
            if (XSDFuncOp.isYearMonth(dur1) && XSDFuncOp.isYearMonth(dur2)) {
                double x1 = NodeValueOps.durationYearMonthAsMonths(dur1);
                double x2 = NodeValueOps.durationYearMonthAsMonths(dur2);
                if (x2 == 0.0) {
                    throw new ExprEvalTypeException("Divide by zero duration in xsd:YearMonthDuration division");
                }
                return NodeValue.makeDecimal(x1 / x2);
            }
            throw new ExprEvalTypeException("Durations not both day-time nor year-month: " + nv1 + " and " + nv2);
        }
        throw new ExprEvalTypeException("Operator '/' : Undefined division: " + nv1 + " and " + nv2);
    }

    private static double durationYearMonthAsMonths(Duration dur) {
        return 12 * dur.getYears() + dur.getMonths();
    }

    private static double durationDayTimeAsSeconds(Duration dur) {
        double x = dur.getDays();
        x *= 24.0;
        x += (double)dur.getHours();
        x *= 60.0;
        x += (double)dur.getMinutes();
        x *= 60.0;
        return x += (double)dur.getSeconds();
    }

    private static boolean isDT(ValueSpace vs) {
        switch (vs) {
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: {
                return true;
            }
        }
        return false;
    }

    private static XMLGregorianCalendar xsd_add(XMLGregorianCalendar cal, Duration duration) {
        XMLGregorianCalendar result = (XMLGregorianCalendar)cal.clone();
        result.add(duration);
        return result;
    }

    private static XMLGregorianCalendar xsd_subtract(XMLGregorianCalendar cal, Duration duration) {
        return NodeValueOps.xsd_add(cal, duration.negate());
    }

    private static Duration xsd_substract(XMLGregorianCalendar cal1, XMLGregorianCalendar cal2) {
        GregorianCalendar gcal1 = cal1.toGregorianCalendar();
        GregorianCalendar gcal2 = cal2.toGregorianCalendar();
        long x1 = gcal1.getTimeInMillis();
        long x2 = gcal2.getTimeInMillis();
        return NodeValue.xmlDatatypeFactory.newDuration(x1 - x2);
    }
}

