/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sys;

import org.apache.jena.base.module.Subsystem;
import org.apache.jena.base.module.SubsystemLifecycle;
import org.apache.jena.base.module.SubsystemRegistry;
import org.apache.jena.base.module.SubsystemRegistryServiceLoader;
import org.apache.jena.sys.JenaSubsystemLifecycle;

public class JenaSystem {
    private static Subsystem<JenaSubsystemLifecycle> singleton = null;
    public static boolean DEBUG_INIT = false;
    private static volatile boolean initialized = false;

    private static void setup() {
        if (singleton == null) {
            singleton = new Subsystem(JenaSubsystemLifecycle.class);
            SubsystemRegistryServiceLoader reg = new SubsystemRegistryServiceLoader(JenaSubsystemLifecycle.class);
            singleton.setSubsystemRegistry((SubsystemRegistry)reg);
            reg.add((SubsystemLifecycle)new JenaInitLevel0());
        }
    }

    public static void logLifecycle(String fmt, Object ... args) {
        if (!DEBUG_INIT) {
            return;
        }
        System.err.printf(fmt, args);
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Class<JenaSystem> clazz = JenaSystem.class;
        synchronized (JenaSystem.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            JenaSystem.setup();
            if (DEBUG_INIT) {
                singleton.debug(DEBUG_INIT);
            }
            singleton.initialize();
            singleton.debug(false);
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void shutdown() {
        singleton.shutdown();
    }

    private static class JenaInitLevel0
    implements JenaSubsystemLifecycle {
        private JenaInitLevel0() {
        }

        public void start() {
            JenaSystem.logLifecycle("Jena initialization", new Object[0]);
        }

        public void stop() {
            JenaSystem.logLifecycle("Jena shutdown", new Object[0]);
        }

        public int level() {
            return 0;
        }
    }
}

