/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.util.XML11Char;
import org.apache.jena.util.XMLChar;

public class PrefixMappingImpl
implements PrefixMapping {
    private Map<String, String> prefixToURI = new ConcurrentHashMap<String, String>();
    private Map<String, String> URItoPrefix = new ConcurrentHashMap<String, String>();
    private boolean locked;

    protected void set(String prefix, String uri) {
        this.prefixToURI.put(prefix, uri);
        this.URItoPrefix.put(uri, prefix);
    }

    protected String get(String prefix) {
        return this.prefixToURI.get(prefix);
    }

    protected void remove(String prefix) {
        this.prefixToURI.remove(prefix);
    }

    @Override
    public PrefixMapping lock() {
        this.locked = true;
        return this;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.checkLegalPrefix(prefix);
        if (!prefix.equals("")) {
            this.checkProperURI(uri);
        }
        if (uri == null) {
            throw new NullPointerException("null URIs are prohibited as arguments to setNsPrefix");
        }
        this.set(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        this.remove(prefix);
        this.regenerateReverseMapping();
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.checkUnlocked();
        ArrayList<String> prefixes = new ArrayList<String>(this.prefixToURI.keySet());
        prefixes.forEach(p -> this.remove((String)p));
        this.regenerateReverseMapping();
        return this;
    }

    protected void regenerateReverseMapping() {
        this.URItoPrefix.clear();
        for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
            this.URItoPrefix.put(e.getValue(), e.getKey());
        }
    }

    protected void checkUnlocked() {
        if (this.locked) {
            throw new PrefixMapping.JenaLockedException(this);
        }
    }

    private void checkProperURI(String uri) {
    }

    private void checkLegalPrefix(String prefix) {
        if (prefix.length() > 0 && !XML11Char.isXML11ValidNCName(prefix)) {
            throw new PrefixMapping.IllegalPrefixException(prefix);
        }
    }

    @Deprecated
    public static boolean isNiceURI(String uri) {
        if (uri.equals("")) {
            return false;
        }
        char last = uri.charAt(uri.length() - 1);
        return !XMLChar.isNCName(last);
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.checkUnlocked();
        for (Map.Entry<String, String> e : other.getNsPrefixMap().entrySet()) {
            String prefix = e.getKey();
            String uri = e.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> other) {
        this.checkUnlocked();
        for (Map.Entry<String, String> e : other.entrySet()) {
            this.setNsPrefix(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.get(prefix);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return CollectionFactory.createHashedMap(this.prefixToURI);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.URItoPrefix.get(uri);
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String uri = this.get(prefixed.substring(0, colon));
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public String toString() {
        return "pm:" + this.prefixToURI;
    }

    @Override
    public String qnameFor(String uri) {
        int split = SplitIRI.splitXML(uri);
        if (split == uri.length()) {
            return null;
        }
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        String prefix = this.URItoPrefix.get(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    @Override
    public String shortForm(String uri) {
        Map.Entry<String, String> e = this.findMapping(uri, true);
        return e == null ? uri : e.getKey() + ":" + uri.substring(e.getValue().length());
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return other instanceof PrefixMappingImpl ? this.equals((PrefixMappingImpl)other) : this.equalsByMap(other);
    }

    @Override
    public boolean hasNoMappings() {
        return this.prefixToURI.isEmpty();
    }

    @Override
    public int numPrefixes() {
        return this.prefixToURI.size();
    }

    protected boolean equals(PrefixMappingImpl other) {
        return other.sameAs(this);
    }

    protected boolean sameAs(PrefixMappingImpl other) {
        return this.prefixToURI.equals(other.prefixToURI);
    }

    protected final boolean equalsByMap(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }

    private Map.Entry<String, String> findMapping(String uri, boolean partial) {
        for (Map.Entry<String, String> e : this.prefixToURI.entrySet()) {
            String ss = e.getValue();
            if (!uri.startsWith(ss) || !partial && ss.length() != uri.length()) continue;
            return e;
        }
        return null;
    }
}

