/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.G;

public abstract class DatasetGraphCollection
extends DatasetGraphBaseFind {
    @Override
    public void add(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        if (g == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g.add(quad.asTriple());
    }

    @Override
    public void delete(Quad quad) {
        Graph g = this.fetchGraph(quad.getGraph());
        if (g == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g.delete(quad.asTriple());
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return G.triples2quadsDftGraph((Iterator<Triple>)this.getDefaultGraph().find(s, p, o));
    }

    protected Iter<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        Graph graph = this.fetchGraph(g);
        if (graph == null) {
            return Iter.nullIter();
        }
        return G.triples2quads(g, (Iterator<Triple>)graph.find(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        IteratorConcat iter = new IteratorConcat();
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iter<Quad> qIter = this.findInSpecificNamedGraph(gn, s, p, o);
            if (qIter == null) continue;
            iter.add(qIter);
        }
        return iter;
    }

    @Override
    public abstract Iterator<Node> listGraphNodes();

    @Override
    public void clear() {
        this.getDefaultGraph().clear();
        List gnList = Iter.toList(this.listGraphNodes());
        for (Node gn : gnList) {
            this.removeGraph(gn);
        }
    }

    protected Graph fetchGraph(Node gn) {
        if (Quad.isDefaultGraph(gn) || Objects.equals(gn, Quad.tripleInQuad)) {
            return this.getDefaultGraph();
        }
        return this.getGraph(gn);
    }
}

