/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.Version;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class RIOT {
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();
    public static final String riotIRI = "http://jena.apache.org/#riot";
    public static final String NAME = "RIOT";
    public static final String VERSION = Version.versionForClass(RIOT.class).orElse("<development>");
    public static final String PATH = "org.apache.jena.riot";
    public static final Symbol multilineLiterals = Symbol.create("riot.multiline_literals");
    private static Context systemGlobalContext = new Context();
    private static boolean registered = false;
    private static String TURTLE_SYMBOL_BASE = "http://jena.apache.org/riot/turtle#";
    private static String RDFXML_SYMBOL_BASE = "http://jena.apache.org/riot/rdfxml#";
    @Deprecated(forRemoval=true)
    public static Symbol symRDFXML0 = SystemARQ.allocSymbol(RDFXML_SYMBOL_BASE, "rdfxml0");
    public static final Symbol symTurtleDirectiveStyle = SystemARQ.allocSymbol(TURTLE_SYMBOL_BASE, "directiveStyle");
    public static final Symbol symTurtleOmitBase = SystemARQ.allocSymbol(TURTLE_SYMBOL_BASE, "omitBase");
    public static final Symbol symTurtleIndentStyle = SystemARQ.allocSymbol(TURTLE_SYMBOL_BASE, "indentStyle");

    public static Context getContext() {
        return systemGlobalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle((String)"RIOT.init - skip", (Object[])new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle((String)"RIOT.init - start", (Object[])new Object[0]);
            if (systemGlobalContext == null) {
                JenaSystem.logLifecycle((String)"RIOT.init - Warning: initializing systemGlobalContext in RIOT.init", (Object[])new Object[0]);
                systemGlobalContext = new Context();
            }
            RIOT.setRIOTSettings();
            RDFLanguages.init();
            RDFParserRegistry.init();
            RDFWriterRegistry.init();
            ResultSetLang.init();
            MappingRegistry.addPrefixMapping("rdfxml", RDFXML_SYMBOL_BASE);
            MappingRegistry.addPrefixMapping("ttl", TURTLE_SYMBOL_BASE);
            MappingRegistry.addPrefixMapping("trig", TURTLE_SYMBOL_BASE);
            IO_Jena.wireIntoJena();
            JenaSystem.logLifecycle((String)"RIOT.init - finish", (Object[])new Object[0]);
        }
    }

    private static void setRIOTSettings() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
    }

    public static String getVersion() {
        return VERSION;
    }
}

