/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Properties;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;

public class PropertyUtils {
    public static Properties loadFromFile(String filename) throws IOException {
        Properties properties = new Properties();
        PropertyUtils.loadFromFile(properties, filename);
        return properties;
    }

    public static void loadFromFile(Properties properties, String filename) throws IOException {
        Objects.requireNonNull(filename, "File name must not be null");
        if ("-".equals(filename)) {
            throw new IllegalArgumentException("Filename is \"-\" (stdin not supported)");
        }
        try (FileInputStream in = new FileInputStream(filename);
             BufferedReader r = IO.asBufferedUTF8(in);){
            properties.load(r);
        }
    }

    public static void storeToFile(Properties properties, String comment, String filename) throws IOException {
        String str = comment;
        if (str == null) {
            str = filename;
        }
        try (FileOutputStream fos = new FileOutputStream(filename);){
            Writer w = IO.asBufferedUTF8(fos);
            properties.store(w, "Metadata: " + str);
            w.flush();
        }
    }

    public static int getPropertyAsInteger(Properties properties, String key) {
        String x = properties.getProperty(key);
        if (x == null) {
            throw new AtlasException("No such property key: " + key);
        }
        return Integer.parseInt(x);
    }

    public static int getPropertyAsInteger(Properties properties, String key, int defaultValue) {
        String x = properties.getProperty(key);
        if (x == null) {
            return defaultValue;
        }
        return Integer.parseInt(x);
    }

    public static boolean getPropertyAsBoolean(Properties properties, String key, boolean dftValue) {
        String x = properties.getProperty(key);
        if (x == null) {
            return dftValue;
        }
        if (x.equalsIgnoreCase("true")) {
            return true;
        }
        if (x.equalsIgnoreCase("false")) {
            return true;
        }
        throw new AtlasException("Value '" + x + "'not recognized for " + key);
    }

    public static Boolean getPropertyAsBoolean(Properties properties, String key) {
        String x = properties.getProperty(key);
        if (x == null) {
            throw new AtlasException("No such property key: " + key);
        }
        if (x.equalsIgnoreCase("true")) {
            return true;
        }
        if (x.equalsIgnoreCase("false")) {
            return true;
        }
        throw new AtlasException("Value '" + x + "'not recognized for " + key);
    }

    public boolean propertyEquals(Properties properties, String key, String value) {
        return Objects.equals(properties.getProperty(key), value);
    }

    public void ensurePropertySet(Properties properties, String key, String expected) {
        this.getOrSetDefault(properties, key, expected);
    }

    public String getOrSetDefault(Properties properties, String key, String expected) {
        String x = properties.getProperty(key);
        if (x == null) {
            properties.setProperty(key, expected);
            x = expected;
        }
        return x;
    }

    public void checkOrSetProperty(Properties properties, String key, String expected) {
        String x = properties.getProperty(key);
        if (x == null) {
            properties.setProperty(key, expected);
            return;
        }
        if (x.equals(expected)) {
            return;
        }
        this.inconsistent(properties, key, x, expected);
    }

    public void checkMetadata(Properties properties, String key, String expected) {
        String value = properties.getProperty(key);
        if (!Objects.equals(value, expected)) {
            this.inconsistent(properties, key, value, expected);
        }
    }

    private void inconsistent(Properties properties, String key, String actual, String expected) {
        String msg = String.format("Inconsistent: key=%s value=%s expected=%s", key, actual == null ? "<null>" : actual, expected == null ? "<null>" : expected);
        throw new AtlasException(msg);
    }
}

