/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;

@FunctionalInterface
public interface EnhNodeFilter {
    public static final EnhNodeFilter TRUE = new EnhNodeFilter(){

        @Override
        public boolean test(Node n, EnhGraph g) {
            return true;
        }

        public String toString() {
            return "TRUE";
        }
    };
    public static final EnhNodeFilter FALSE = new EnhNodeFilter(){

        @Override
        public boolean test(Node n, EnhGraph g) {
            return false;
        }

        public String toString() {
            return "FALSE";
        }
    };
    public static final EnhNodeFilter URI = new EnhNodeFilter(){

        @Override
        public boolean test(Node n, EnhGraph g) {
            return n.isURI();
        }

        public String toString() {
            return "URI";
        }
    };
    public static final EnhNodeFilter ANON = new EnhNodeFilter(){

        @Override
        public boolean test(Node n, EnhGraph g) {
            return n.isBlank();
        }

        public String toString() {
            return "BLANK";
        }
    };

    public boolean test(Node var1, EnhGraph var2);

    default public EnhNodeFilter and(final EnhNodeFilter other) {
        if (Objects.requireNonNull(other, "Null and-filter.").equals(TRUE)) {
            return this;
        }
        if (this.equals(TRUE)) {
            return other;
        }
        if (other.equals(FALSE)) {
            return FALSE;
        }
        if (this.equals(FALSE)) {
            return FALSE;
        }
        return new EnhNodeFilter(){

            @Override
            public boolean test(Node n, EnhGraph g) {
                return EnhNodeFilter.this.test(n, g) && other.test(n, g);
            }

            public String toString() {
                return "(" + EnhNodeFilter.this + ")AND(" + other + ")";
            }
        };
    }

    default public EnhNodeFilter or(final EnhNodeFilter other) {
        if (Objects.requireNonNull(other, "Null or-filter.").equals(TRUE)) {
            return TRUE;
        }
        if (this.equals(TRUE)) {
            return TRUE;
        }
        if (other.equals(FALSE)) {
            return this;
        }
        if (this.equals(FALSE)) {
            return other;
        }
        return new EnhNodeFilter(){

            @Override
            public boolean test(Node n, EnhGraph g) {
                return EnhNodeFilter.this.test(n, g) || other.test(n, g);
            }

            public String toString() {
                return "(" + EnhNodeFilter.this + ")OR(" + other + ")";
            }
        };
    }

    default public EnhNodeFilter accumulate(EnhNodeFilter ... filters) {
        EnhNodeFilter res = this;
        for (EnhNodeFilter o : filters) {
            res = res.and(o);
        }
        return res;
    }

    public static class HasOneOfType
    implements EnhNodeFilter {
        protected final Set<Node> types;

        public HasOneOfType(Collection<Resource> types) {
            if (types.isEmpty()) {
                throw new IllegalStateException();
            }
            this.types = types.stream().map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        public boolean test(Node node, EnhGraph eg) {
            return Graphs.hasOneOfType(node, eg.asGraph(), this.types);
        }

        public String toString() {
            return "HasType::" + this.types;
        }
    }

    public static class HasType
    implements EnhNodeFilter {
        protected final Node type;

        public HasType(Resource type) {
            this.type = Objects.requireNonNull(type, "Null type.").asNode();
        }

        @Override
        public boolean test(Node node, EnhGraph eg) {
            return eg.asGraph().contains(node, RDF.Nodes.type, this.type);
        }

        public String toString() {
            return "HasType::" + this.type.getLocalName();
        }
    }

    public static class HasPredicate
    implements EnhNodeFilter {
        protected final Node predicate;

        public HasPredicate(Property predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Null predicate.").asNode();
        }

        @Override
        public boolean test(Node n, EnhGraph g) {
            return g.asGraph().contains(n, this.predicate, Node.ANY);
        }

        public String toString() {
            return "HasPredicate::" + this.predicate.getLocalName();
        }
    }
}

