/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.mgt;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;

public class Explain {
    public static boolean MultiLineMode = true;
    public static final Logger logExec = ARQ.getExecLogger();
    public static final Logger logInfo = ARQ.getInfoLogger();
    private static final boolean MultiLinesForOps = true;
    private static final boolean MultiLinesForPatterns = true;

    public static void explain(Query query, Context context2) {
        Explain.explain("Query", query, context2);
    }

    public static void explain(String message, Query query, Context context2) {
        if (Explain.explaining(InfoLevel.INFO, logExec, context2)) {
            IndentedLineBuffer iBuff = new IndentedLineBuffer();
            iBuff.incIndent();
            query.serialize((IndentedWriter)iBuff);
            String x = iBuff.asString();
            Explain._explain(logExec, message, x, true);
        }
    }

    public static void explain(Op op, Context context2) {
        Explain.explain("Algebra", op, context2);
    }

    public static void explain(String message, Op op, Context context2) {
        if (Explain.explaining(InfoLevel.FINE, logExec, context2)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                op.output((IndentedWriter)iBuff);
                String x = iBuff.asString();
                Explain._explain(logExec, message, x, true);
            }
        }
    }

    public static void explain(BasicPattern bgp, Context context2) {
        Explain.explain("BGP", bgp, context2);
    }

    public static void explain(String message, BasicPattern bgp, Context context2) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context2)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                Explain.formatTriples(iBuff, bgp);
                iBuff.flush();
                String str2 = iBuff.toString();
                Explain._explain(logExec, message, str2, false);
            }
        }
    }

    public static void explain(String message, QuadPattern quads, Context context2) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context2)) {
            try (IndentedLineBuffer iBuff = new IndentedLineBuffer();){
                iBuff.incIndent();
                Explain.formatQuads(iBuff, quads);
                iBuff.flush();
                String str2 = iBuff.toString();
                Explain._explain(logExec, message, str2, false);
            }
        }
    }

    private static void formatQuads(IndentedLineBuffer out, QuadPattern quads) {
        SerializationContext sCxt = SSE.sCxt(SSE.getPrefixMapWrite());
        boolean first = true;
        for (Quad qp : quads) {
            if (first) {
                first = false;
            }
            out.print("(");
            if (qp.getGraph() == null) {
                out.print("_");
            } else {
                WriterNode.output((IndentedWriter)out, qp.getGraph(), sCxt);
            }
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getSubject(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getPredicate(), sCxt);
            out.print(" ");
            WriterNode.output((IndentedWriter)out, qp.getObject(), sCxt);
            out.print(")");
            out.println();
        }
    }

    private static void formatTriples(IndentedLineBuffer out, BasicPattern triples) {
        SerializationContext sCxt = SSE.sCxt(SSE.getPrefixMapWrite());
        boolean first = true;
        for (Triple qp : triples) {
            if (!first) {
                // empty if block
            }
            first = false;
            WriterNode.outputPlain((IndentedWriter)out, qp, sCxt);
            out.println();
        }
    }

    private static void _explain(Logger logger, String reason, String explanation, boolean newlineAlways) {
        while (((String)explanation).endsWith("\n") || ((String)explanation).endsWith("\r")) {
            explanation = StrUtils.chop((String)explanation);
        }
        explanation = newlineAlways || ((String)explanation).contains("\n") ? reason + "\n" + (String)explanation : reason + " :: " + (String)explanation;
        Explain._explain(logger, (String)explanation);
    }

    private static void _explain(Logger logger, String explanation) {
        logger.info(explanation);
    }

    public static void explain(Context context2, String message) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context2)) {
            Explain._explain(logInfo, message);
        }
    }

    public static void explain(Context context2, String format, Object ... args) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context2)) {
            String str2 = String.format(format, args);
            Explain._explain(logInfo, str2);
        }
    }

    public static boolean explaining(InfoLevel level, Logger logger, Context context2) {
        if (!Explain._explaining(level, context2)) {
            return false;
        }
        return logger.isInfoEnabled();
    }

    private static boolean _explaining(InfoLevel level, Context context2) {
        if (level == InfoLevel.NONE) {
            return false;
        }
        Object x = context2.get(ARQ.symLogExec);
        if (x == null) {
            return false;
        }
        if (x instanceof InfoLevel) {
            InfoLevel z = (InfoLevel)((Object)x);
            if (z == InfoLevel.NONE) {
                return false;
            }
            return z.level() >= level.level();
        }
        if (x instanceof String) {
            String s = (String)x;
            if (s.equalsIgnoreCase("info")) {
                return level.equals((Object)InfoLevel.INFO);
            }
            if (s.equalsIgnoreCase("fine")) {
                return level.equals((Object)InfoLevel.FINE) || level.equals((Object)InfoLevel.INFO);
            }
            if (s.equalsIgnoreCase("all")) {
                return true;
            }
            if (s.equalsIgnoreCase("none")) {
                return false;
            }
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return Boolean.TRUE.equals(x);
    }

    public static void explain(Node s, Path path, Node o, Context context2) {
        Explain.explain("Path", s, path, o, context2);
    }

    public static void explain(String message, Node s, Path path, Node o, Context context2) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context2)) {
            String str2 = s + " " + path + " " + o;
            Explain._explain(logExec, message, str2, false);
        }
    }

    public static enum InfoLevel {
        INFO(10),
        FINE(20),
        ALL(30),
        NONE(-1);

        private final int level;

        private InfoLevel(int xlevel) {
            this.level = xlevel;
        }

        public int level() {
            return this.level;
        }

        public static InfoLevel get(String name) {
            if ("ALL".equalsIgnoreCase(name)) {
                return ALL;
            }
            if ("FINE".equalsIgnoreCase(name)) {
                return FINE;
            }
            if ("INFO".equalsIgnoreCase(name)) {
                return INFO;
            }
            if ("NONE".equalsIgnoreCase(name)) {
                return NONE;
            }
            return null;
        }
    }
}

