/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.protobuf.ProtobufRDF;
import org.apache.jena.riot.protobuf.RiotProtobufException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class WriterDatasetProtobuf
implements WriterDatasetRIOT {
    private final boolean withValues;

    public WriterDatasetProtobuf(RDFFormat fmt) {
        this.withValues = RDFFormat.RDF_PROTO_VALUES.equals(fmt);
    }

    @Override
    public Lang getLang() {
        return Lang.RDFPROTO;
    }

    @Override
    public void write(Writer out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context2) {
        throw new RiotProtobufException("Writing binary data to a java.io.Writer is not supported. Please use an OutputStream");
    }

    @Override
    public void write(OutputStream out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context2) {
        StreamRDF stream = ProtobufRDF.streamToOutputStream(out, this.withValues);
        stream.start();
        StreamRDFOps.sendDatasetToStream(dsg, stream, baseURI, prefixMap);
        stream.finish();
    }
}

